/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.synthetic;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.ModuleEndpointsFilter;
import com.intellij.microservices.oas.OasEndpointPath;
import com.intellij.microservices.oas.OasHttpMethod;
import com.intellij.microservices.oas.OasModelUtils;
import com.intellij.microservices.oas.OasOperation;
import com.intellij.microservices.oas.OasParameter;
import com.intellij.microservices.oas.OasParameterIn;
import com.intellij.microservices.oas.OasResponse;
import com.intellij.microservices.oas.OasSchema;
import com.intellij.microservices.oas.OasSchemaFormat;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlQueryParameter;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.swagger.synthetic.OasSerializationUtilsKt;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000r\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002\u001a.\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u001e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u0010H\u0007\u001a\u0018\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007\u001a.\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00162\u0014\u0010\u0019\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001b0\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u0016\u0010\u001c\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u001aH\u0007\u001a>\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u001e\"\b\b\u0000\u0010\u001f*\u00020 \"\b\b\u0001\u0010!*\u00020 2\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u0002H\u001f\u0012\u0004\u0012\u0002H!0\u001bH\u0002\u001a\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0\u00102\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010%H\u0000\u001a,\u0010'\u001a\b\u0012\u0004\u0012\u00020\t0\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\u0014\u0010\u0019\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001b0\u001aH\u0002\u001a^\u0010(\u001a\u0004\u0018\u0001H)\"\b\b\u0000\u0010!*\u00020 \"\b\b\u0001\u0010\u001f*\u00020 \"\u0006\b\u0002\u0010)\u0018\u00012\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u0002H\u001f\u0012\u0004\u0012\u0002H!0\u001b2\u0006\u0010*\u001a\u0002H\u001f2\u0006\u0010+\u001a\u0002H!2\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H)0-H\u0082\b\u00a2\u0006\u0002\u0010.\u001a\u001c\u0010/\u001a\b\u0012\u0004\u0012\u00020\t0\u001a2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u001aH\u0000\u00a8\u00060"}, d2={"appendOperationToJson", "", "pathNode", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "operation", "Lcom/intellij/microservices/oas/OasOperation;", "appendPathToJson", "root", "model", "Lcom/intellij/microservices/oas/OasEndpointPath;", "generateOasContent", "factory", "Lcom/fasterxml/jackson/core/JsonFactory;", "projectName", "", "models", "", "writer", "Ljava/io/Writer;", "generateOasDraft", "generateOasExports", "module", "Lcom/intellij/openapi/module/Module;", "path", "Ljava/nio/file/Path;", "providers", "", "Lcom/intellij/microservices/endpoints/EndpointsProvider;", "generateOasPreview", "getEndpoints", "Lkotlin/sequences/Sequence;", "G", "", "E", "provider", "getModelByUrls", "urls", "", "Lcom/intellij/microservices/url/UrlTargetInfo;", "getModuleModels", "getProviderData", "T", "group", "endpoint", "dataKey", "Lcom/intellij/openapi/actionSystem/DataKey;", "(Lcom/intellij/microservices/endpoints/EndpointsProvider;Ljava/lang/Object;Ljava/lang/Object;Lcom/intellij/openapi/actionSystem/DataKey;)Ljava/lang/Object;", "squashModelsPerPath", "intellij.swagger"})
public final class OasSerializationUtilsKt {
    /*
     * WARNING - void declaration
     */
    @ApiStatus.Experimental
    @NlsSafe
    @NotNull
    public static final String generateOasPreview(@NotNull List<OasEndpointPath> models2) {
        Intrinsics.checkNotNullParameter(models2, (String)"models");
        YAMLFactory factory = new YAMLFactory().configure(YAMLGenerator.Feature.WRITE_DOC_START_MARKER, false);
        StringWriter writer = new StringWriter();
        ObjectMapper mapper = new ObjectMapper((JsonFactory)factory);
        Iterable $this$forEachIndexed$iv = models2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void model;
            ObjectNode root;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            OasEndpointPath oasEndpointPath = (OasEndpointPath)item$iv;
            int index = n;
            boolean bl2 = false;
            if (index != 0) {
                writer.getBuffer().append("\n---\n");
            }
            YAMLGenerator generator = factory.createGenerator((Writer)writer);
            ObjectNode objectNode = root = mapper.createObjectNode();
            Intrinsics.checkNotNullExpressionValue((Object)objectNode, (String)"root");
            OasSerializationUtilsKt.appendPathToJson(objectNode, (OasEndpointPath)model);
            mapper.writeTree((JsonGenerator)generator, (JsonNode)root);
        }
        String string = writer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writer.toString()");
        String document = string;
        StringBuilder paddingBuilder = new StringBuilder();
        for (String s : StringsKt.split$default((CharSequence)document, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null)) {
            if (Intrinsics.areEqual((Object)s, (Object)"---")) {
                paddingBuilder.append(s);
            } else {
                paddingBuilder.append("  ").append(s);
            }
            paddingBuilder.append("\n");
        }
        String string2 = paddingBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"paddingBuilder.toString()");
        String string3 = string2;
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trimEnd((CharSequence)string4)).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Experimental
    public static final void generateOasExports(@NotNull Module module, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        boolean $i$f$runReadAction = false;
        List models2 = (List)ApplicationManager.getApplication().runReadAction(new Computable(module){
            final /* synthetic */ Module $module$inlined;
            {
                this.$module$inlined = module;
            }

            public final T compute() {
                boolean bl = false;
                return (T)OasSerializationUtilsKt.access$getModuleModels(this.$module$inlined, EndpointsProvider.Companion.getAllProviders());
            }
        });
        if (models2.isEmpty()) {
            return;
        }
        Closeable closeable = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            BufferedWriter it = (BufferedWriter)closeable;
            boolean bl3 = false;
            JsonFactory jsonFactory = new JsonFactory();
            String string = module.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"module.name");
            Collection collection = models2;
            BufferedWriter bufferedWriter = it;
            Intrinsics.checkNotNullExpressionValue((Object)bufferedWriter, (String)"it");
            OasSerializationUtilsKt.generateOasContent(jsonFactory, string, collection, bufferedWriter);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final void generateOasExports(@NotNull Module module, @NotNull List<? extends EndpointsProvider<?, ?>> providers, @NotNull Writer writer) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        List<OasEndpointPath> models2 = OasSerializationUtilsKt.getModuleModels(module, providers);
        JsonFactory jsonFactory = new JsonFactory();
        String string = module.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"module.name");
        OasSerializationUtilsKt.generateOasContent(jsonFactory, string, (Collection<OasEndpointPath>)models2, writer);
    }

    private static final List<OasEndpointPath> getModuleModels(Module module, List<? extends EndpointsProvider<?, ?>> providers) {
        return SequencesKt.toList((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)providers), (Function1)new Function1<EndpointsProvider<?, ?>, Boolean>(module){
            final /* synthetic */ Module $module;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke(@NotNull EndpointsProvider<?, ?> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                if (!Intrinsics.areEqual((Object)it.getEndpointType(), (Object)EndpointTypes.HTTP_SERVER_TYPE)) return false;
                Project project = this.$module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
                if (it.getStatus(project) == EndpointsProvider.Status.UNAVAILABLE) return false;
                return true;
            }
            {
                this.$module = module;
                super(1);
            }
        }), (Function1)new Function1<EndpointsProvider<?, ?>, Sequence<? extends OasEndpointPath>>(module){
            final /* synthetic */ Module $module;

            @NotNull
            public final Sequence<OasEndpointPath> invoke(@NotNull EndpointsProvider<?, ?> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return OasSerializationUtilsKt.access$getEndpoints(this.$module, it);
            }
            {
                this.$module = module;
                super(1);
            }
        }));
    }

    @ApiStatus.Experimental
    @NlsSafe
    @NotNull
    public static final String generateOasDraft(@NotNull String projectName, @NotNull Collection<OasEndpointPath> models2) {
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter(models2, (String)"models");
        YAMLFactory factory = new YAMLFactory().configure(YAMLGenerator.Feature.WRITE_DOC_START_MARKER, false);
        Writer writer = new StringWriter();
        YAMLFactory yAMLFactory = factory;
        Intrinsics.checkNotNullExpressionValue((Object)yAMLFactory, (String)"factory");
        OasSerializationUtilsKt.generateOasContent((JsonFactory)yAMLFactory, projectName, models2, writer);
        return writer.toString();
    }

    private static final void generateOasContent(JsonFactory factory, String projectName, Collection<OasEndpointPath> models2, Writer writer) {
        ObjectMapper mapper = new ObjectMapper(factory);
        String string = FileUtil.sanitizeFileName((String)projectName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.sanitizeFileName(projectName)");
        String safeProjectName = string;
        ObjectNode root = mapper.createObjectNode();
        root.put("openapi", "3.0.3");
        ObjectNode objectNode = root.putObject("info");
        boolean bl = false;
        boolean bl2 = false;
        ObjectNode $this$apply = objectNode;
        boolean bl3 = false;
        $this$apply.put("title", safeProjectName + " API");
        $this$apply.put("description", safeProjectName + " API");
        $this$apply.put("version", "1.0.0");
        objectNode = root.putArray("servers");
        bl = false;
        bl2 = false;
        $this$apply = objectNode;
        boolean bl4 = false;
        $this$apply.addObject().put("url", "https://" + safeProjectName);
        ObjectNode pathsNode = root.putObject("paths");
        for (OasEndpointPath model : models2) {
            ObjectNode objectNode2 = pathsNode;
            Intrinsics.checkNotNullExpressionValue((Object)objectNode2, (String)"pathsNode");
            OasSerializationUtilsKt.appendPathToJson(objectNode2, model);
        }
        JsonGenerator generator = factory.createGenerator(writer);
        if (!(factory instanceof YAMLFactory)) {
            generator.useDefaultPrettyPrinter();
        }
        mapper.writeTree(generator, (JsonNode)root);
    }

    private static final <G, E> Sequence<OasEndpointPath> getEndpoints(Module module, EndpointsProvider<G, E> provider) {
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        return SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)provider.getEndpointGroups(project, (EndpointsFilter)new ModuleEndpointsFilter(module, true, false))), (Function1)new Function1<G, Sequence<? extends OasEndpointPath>>(provider){
            final /* synthetic */ EndpointsProvider $provider;

            @NotNull
            public final Sequence<OasEndpointPath> invoke(@NotNull G group) {
                Intrinsics.checkNotNullParameter(group, (String)"group");
                return SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this.$provider.getEndpoints(group)), (Function1)((Function1)new Function1<E, Sequence<? extends OasEndpointPath>>(this, group){
                    final /* synthetic */ getEndpoints.1 this$0;
                    final /* synthetic */ Object $group;

                    @NotNull
                    public final Sequence<OasEndpointPath> invoke(@NotNull E it) {
                        Iterable iterable;
                        Object group$iv;
                        EndpointsProvider provider$iv;
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        EndpointsProvider endpointsProvider = this.this$0.$provider;
                        Object object = this.$group;
                        DataKey dataKey$iv = EndpointsProvider.OPENAPI_PATH;
                        boolean $i$f$getProviderData = false;
                        String string = dataKey$iv.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dataKey.name");
                        Object object2 = provider$iv.getEndpointData(group$iv, it, string);
                        if (!(object2 instanceof Iterable)) {
                            object2 = null;
                        }
                        if ((iterable = (Iterable)object2) == null) {
                            provider$iv = this.this$0.$provider;
                            group$iv = this.$group;
                            dataKey$iv = EndpointsProvider.URL_TARGET_INFO;
                            $i$f$getProviderData = false;
                            String string2 = dataKey$iv.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dataKey.name");
                            Object object3 = provider$iv.getEndpointData(group$iv, it, string2);
                            if (!(object3 instanceof Iterable)) {
                                object3 = null;
                            }
                            iterable = OasSerializationUtilsKt.getModelByUrls((Iterable)object3);
                        }
                        Iterable models2 = iterable;
                        return CollectionsKt.asSequence((Iterable)models2);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$group = object;
                        super(1);
                    }
                }));
            }
            {
                this.$provider = endpointsProvider;
                super(1);
            }
        });
    }

    private static final /* synthetic */ <E, G, T> T getProviderData(EndpointsProvider<G, E> provider, G group, E endpoint, DataKey<T> dataKey) {
        int $i$f$getProviderData = 0;
        String string = dataKey.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dataKey.name");
        Object object = provider.getEndpointData(group, endpoint, string);
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        return (T)object;
    }

    private static final void appendPathToJson(ObjectNode root, OasEndpointPath model) {
        if (Intrinsics.areEqual((Object)model.getPath(), (Object)"<unknown>") && model.getOperations().isEmpty()) {
            return;
        }
        String path = StringsKt.startsWith$default((String)model.getPath(), (String)"/", (boolean)false, (int)2, null) ? model.getPath() : '/' + model.getPath();
        ObjectNode pathNode = root.putObject(path);
        if (model.getSummary() != null) {
            pathNode.put("summary", model.getSummary());
        }
        for (OasOperation operation : model.getOperations()) {
            ObjectNode objectNode = pathNode;
            Intrinsics.checkNotNullExpressionValue((Object)objectNode, (String)"pathNode");
            OasSerializationUtilsKt.appendOperationToJson(objectNode, operation);
        }
    }

    private static final void appendOperationToJson(ObjectNode pathNode, OasOperation operation) {
        Collection parametersNode;
        ObjectNode methodNode = pathNode.putObject(operation.getMethod().getMethodName());
        if (operation.getSummary() != null) {
            methodNode.put("summary", operation.getSummary());
        }
        if (operation.getDescription() != null) {
            methodNode.put("description", operation.getDescription());
        }
        if (operation.isDeprecated()) {
            methodNode.put("deprecated", true);
        }
        if (operation.getOperationId() != null) {
            methodNode.put("operationId", operation.getOperationId());
        }
        Collection collection = operation.getParameters();
        boolean bl = false;
        if (!collection.isEmpty()) {
            parametersNode = methodNode.putArray("parameters");
            for (OasParameter parameter : operation.getParameters()) {
                OasSchema schema2;
                ObjectNode parameterNode = parametersNode.addObject();
                parameterNode.put("name", parameter.getName());
                parameterNode.put("in", parameter.getInPlace().getPlaceName());
                if (parameter.isDeprecated()) {
                    parameterNode.put("deprecated", true);
                }
                if (parameter.isRequired()) {
                    parameterNode.put("required", true);
                }
                if ((schema2 = parameter.getSchema()) == null) continue;
                ObjectNode schemaObject = parameterNode.putObject("schema");
                schemaObject.put("type", schema2.getType().getTypeName());
                if (schema2.getFormat() != null) {
                    OasSchemaFormat oasSchemaFormat;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    OasSchemaFormat it = oasSchemaFormat;
                    boolean bl4 = false;
                    schemaObject.put("format", it.getFormatName());
                }
            }
        }
        parametersNode = operation.getResponses();
        boolean parameter = false;
        if (!parametersNode.isEmpty()) {
            ObjectNode responsesNode = methodNode.putObject("responses");
            for (OasResponse response : operation.getResponses()) {
                ObjectNode objectNode = responsesNode.putObject(response.getCode());
                String string = response.getDescription();
                if (string == null) {
                    string = "";
                }
                objectNode.put("description", string);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<OasEndpointPath> getModelByUrls(@Nullable Iterable<? extends UrlTargetInfo> urls) {
        void $this$mapTo$iv$iv;
        if (urls == null) {
            return CollectionsKt.emptyList();
        }
        Iterable<? extends UrlTargetInfo> $this$map$iv = urls;
        boolean $i$f$map = false;
        Iterable<? extends UrlTargetInfo> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void urlTargetInfo;
            UrlTargetInfo urlTargetInfo2 = (UrlTargetInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            OasEndpointPath oasEndpointPath = new OasEndpointPath.Builder(urlTargetInfo.getPath().getPresentation(OasModelUtils.getOPEN_API_PRESENTATION())).build((Function1)new Function1<OasEndpointPath.Builder, Unit>((UrlTargetInfo)urlTargetInfo){
                final /* synthetic */ UrlTargetInfo $urlTargetInfo;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull OasEndpointPath.Builder $this$build) {
                    Object object;
                    String it;
                    Collection collection;
                    Iterable $this$mapTo$iv$iv;
                    Object element$iv$iv$iv;
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$filterIsInstanceTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$receiver");
                    Iterable $this$filterIsInstance$iv = this.$urlTargetInfo.getPath().getSegments();
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable = $this$filterIsInstance$iv;
                    Iterable<OasParameter> destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof UrlPath.PathSegment.Variable)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
                    boolean $i$f$mapNotNull = false;
                    $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        OasParameter oasParameter;
                        T element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        UrlPath.PathSegment.Variable it2 = (UrlPath.PathSegment.Variable)element$iv$iv;
                        boolean bl2 = false;
                        String variableName = it2.getVariableName();
                        if ((variableName != null ? OasParameter.Builder.build$default((OasParameter.Builder)new OasParameter.Builder(variableName, OasParameterIn.PATH), null, (int)1, null) : null) == null) continue;
                        oasParameter = oasParameter;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        OasParameter it$iv$iv = oasParameter;
                        boolean bl5 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List pathParams = (List)destination$iv$iv;
                    Iterable $this$map$iv = this.$urlTargetInfo.getQueryParameters();
                    boolean $i$f$map = false;
                    destination$iv$iv = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        element$iv$iv$iv = (UrlQueryParameter)item$iv$iv;
                        collection = destination$iv$iv2;
                        boolean bl = false;
                        object = OasParameter.Builder.build$default((OasParameter.Builder)new OasParameter.Builder(it.getName(), OasParameterIn.QUERY), null, (int)1, null);
                        collection.add(object);
                    }
                    List queryParams = (List)destination$iv$iv2;
                    $this$map$iv = this.$urlTargetInfo.getMethods();
                    collection = $this$build;
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void method;
                        it = (String)item$iv$iv;
                        object = destination$iv$iv2;
                        boolean bl = false;
                        OasOperation oasOperation = new OasOperation.Builder((String)method).build((Function1)new Function1<OasOperation.Builder, Unit>((String)method, this, pathParams, queryParams){
                            final /* synthetic */ String $method;
                            final /* synthetic */ getModelByUrls.1.1 this$0;
                            final /* synthetic */ List $pathParams$inlined;
                            final /* synthetic */ List $queryParams$inlined;
                            {
                                this.$method = string;
                                this.this$0 = var2_2;
                                this.$pathParams$inlined = list;
                                this.$queryParams$inlined = list2;
                                super(1);
                            }

                            public final void invoke(@NotNull OasOperation.Builder $this$build) {
                                Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$receiver");
                                StringBuilder stringBuilder = new StringBuilder();
                                String string = this.$method;
                                boolean bl = false;
                                String string2 = string;
                                if (string2 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                                }
                                String string3 = string2.toUpperCase();
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
                                $this$build.setSummary(stringBuilder.append(string3).append(" ").append(this.this$0.$urlTargetInfo.getPath().getPresentation(UrlPath.FULL_PATH_VARIABLE_PRESENTATION)).toString());
                                $this$build.setDeprecated(this.this$0.$urlTargetInfo.isDeprecated());
                                $this$build.setResponses(CollectionsKt.listOf((Object)new OasResponse("200", "OK")));
                                $this$build.setParameters(CollectionsKt.plus((Collection)this.$pathParams$inlined, (Iterable)this.$queryParams$inlined));
                            }
                        });
                        object.add(oasOperation);
                    }
                    object = (List)destination$iv$iv2;
                    collection.setOperations((Collection)object);
                }
                {
                    this.$urlTargetInfo = urlTargetInfo;
                    super(1);
                }
            });
            collection.add(oasEndpointPath);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<OasEndpointPath> squashModelsPerPath(@NotNull List<OasEndpointPath> models2) {
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(models2, (String)"models");
        if (models2.size() <= 1) {
            return models2;
        }
        Iterable $this$groupBy$iv = models2;
        boolean bl = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            OasEndpointPath it = (OasEndpointPath)element$iv$iv;
            boolean bl2 = false;
            key$iv$iv = it.getPath();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl22 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map grouped = destination$iv$iv;
        boolean bl3 = false;
        List list = new ArrayList();
        destination$iv$iv = grouped;
        $i$f$groupByTo = false;
        for (Map.Entry entry : destination$iv$iv.entrySet()) {
            boolean bl4;
            List operations;
            String summary;
            String path;
            block13: {
                Iterator $this$flatMapTo$iv$iv;
                List items = (List)entry.getValue();
                if (items.size() == 1) {
                    list.addAll(items);
                    continue;
                }
                path = (String)entry.getKey();
                summary = ((OasEndpointPath)items.get(0)).getSummary();
                Iterable $this$flatMap$iv = items;
                boolean $i$f$flatMap = false;
                key$iv$iv = $this$flatMap$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                Iterator value$iv$iv$iv = $this$flatMapTo$iv$iv.iterator();
                while (value$iv$iv$iv.hasNext()) {
                    Object element$iv$iv = value$iv$iv$iv.next();
                    OasEndpointPath it = (OasEndpointPath)element$iv$iv;
                    boolean bl32 = false;
                    Iterable list$iv$iv = it.getOperations();
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                operations = (List)destination$iv$iv2;
                Iterable $this$all$iv = items;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl4 = true;
                } else {
                    $this$flatMapTo$iv$iv = $this$all$iv.iterator();
                    while ($this$flatMapTo$iv$iv.hasNext()) {
                        Object element$iv = $this$flatMapTo$iv$iv.next();
                        OasEndpointPath it = (OasEndpointPath)element$iv;
                        boolean bl42 = false;
                        if (Intrinsics.areEqual((Object)it.getSummary(), (Object)summary)) continue;
                        bl4 = false;
                        break block13;
                    }
                    bl4 = true;
                }
            }
            if (bl4) {
                Iterable $this$distinctBy$iv = operations;
                boolean $i$f$distinctBy = false;
                HashSet<OasHttpMethod> set$iv = new HashSet<OasHttpMethod>();
                ArrayList list$iv = new ArrayList();
                for (Object e$iv : $this$distinctBy$iv) {
                    OasOperation it = (OasOperation)e$iv;
                    boolean bl5 = false;
                    OasHttpMethod key$iv = it.getMethod();
                    if (!set$iv.add(key$iv)) continue;
                    list$iv.add(e$iv);
                }
                if (((List)list$iv).size() == operations.size()) {
                    list.add(new OasEndpointPath(path, summary, (Collection)operations));
                    continue;
                }
            }
            list.addAll((Collection)entry.getValue());
        }
        return list;
    }

    public static final /* synthetic */ List access$getModuleModels(Module module, List providers) {
        return OasSerializationUtilsKt.getModuleModels(module, providers);
    }

    public static final /* synthetic */ Sequence access$getEndpoints(Module module, EndpointsProvider provider) {
        return OasSerializationUtilsKt.getEndpoints(module, provider);
    }

    public static final /* synthetic */ Object access$getProviderData(EndpointsProvider provider, Object group, Object endpoint, DataKey dataKey) {
        return OasSerializationUtilsKt.getProviderData(provider, group, endpoint, dataKey);
    }
}

