/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.structureView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.swagger.SpecificationType;
import com.intellij.swagger.SwSpecificationDetectionKt;
import com.intellij.swagger.SwaggerBundle;
import com.intellij.swagger.index.SwIndexUtilsKt;
import com.intellij.swagger.model.api.SwDefinition;
import com.intellij.swagger.model.api.SwHttpOperation;
import com.intellij.swagger.model.api.SwModelElement;
import com.intellij.swagger.model.api.SwSyntheticContainer;
import com.intellij.swagger.model.api.SwSyntheticContainerKt;
import com.intellij.swagger.model.api.SwUrl;
import com.intellij.swagger.model.specification.SwSpecificationFile;
import com.intellij.swagger.model.specification.SwaggerFileHelper;
import com.intellij.swagger.model.specification.openapi.v3.Openapi3Callback;
import com.intellij.swagger.model.specification.openapi.v3.Openapi3Example;
import com.intellij.swagger.model.specification.openapi.v3.Openapi3Header;
import com.intellij.swagger.model.specification.openapi.v3.Openapi3Link;
import com.intellij.swagger.model.specification.openapi.v3.Openapi3RequestBody;
import com.intellij.swagger.structureView.OpenapiStructureViewBuilder;
import com.intellij.swagger.structureView.OpenapiStructureViewElement;
import com.intellij.swagger.traverser.SpecificationTraverser;
import com.intellij.swagger.traverser.SpecificationTraverserFactory;
import com.intellij.swagger.traverser.SwTreeUtil;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a4\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0002\u001a\u0004\u0018\u00010\u0012H\u0002\u001a\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"createCategoryPresentation", "Lcom/intellij/navigation/ItemPresentation;", "modelElement", "Lcom/intellij/swagger/model/api/SwSyntheticContainer;", "createItemPresentation", "presentableText", "", "locationString", "icon", "Ljavax/swing/Icon;", "attributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "getStructureViewBuilderOrNull", "Lcom/intellij/ide/structureView/StructureViewBuilder;", "psiFile", "Lcom/intellij/psi/PsiFile;", "needShowElementInStructure", "", "Lcom/intellij/swagger/model/api/SwModelElement;", "traverser", "Lcom/intellij/swagger/traverser/SpecificationTraverser;", "Lcom/intellij/swagger/structureView/OpenapiStructureViewElement;", "intellij.swagger"})
public final class OpenapiStructureViewKt {
    private static final StructureViewBuilder getStructureViewBuilderOrNull(PsiFile psiFile2) {
        Project project = psiFile2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"psiFile.project");
        if (SwIndexUtilsKt.isIndexingRightNow(project) || !SwSpecificationDetectionKt.detectIsSpecificationFile(psiFile2)) {
            return null;
        }
        PsiFile psiFile3 = psiFile2.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile3, (String)"psiFile.originalFile");
        VirtualFile virtualFile2 = psiFile3.getVirtualFile();
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile virtualFile3 = virtualFile2;
        Project project2 = psiFile2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"psiFile.project");
        SwSpecificationFile swSpecificationFile = SwaggerFileHelper.createSpecificationFile$default(SwaggerFileHelper.INSTANCE, psiFile2, virtualFile3, project2, false, false, 24, null);
        if (swSpecificationFile == null) {
            return null;
        }
        SwSpecificationFile specification = swSpecificationFile;
        return (StructureViewBuilder)new OpenapiStructureViewBuilder(specification, psiFile2);
    }

    private static final boolean needShowElementInStructure(SwModelElement modelElement) {
        SwModelElement swModelElement = modelElement;
        return swModelElement instanceof SwSpecificationFile || swModelElement instanceof SwUrl || swModelElement instanceof SwHttpOperation || swModelElement instanceof SwDefinition || swModelElement instanceof SwSyntheticContainer || swModelElement instanceof Openapi3RequestBody || swModelElement instanceof Openapi3Link || swModelElement instanceof Openapi3Header || swModelElement instanceof Openapi3Example || swModelElement instanceof Openapi3Callback;
    }

    private static final SpecificationTraverser traverser(OpenapiStructureViewElement $this$traverser) {
        PsiFile psiFile2 = $this$traverser.getSourcePsi().getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"sourcePsi.containingFile");
        FileType fileType = psiFile2.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"sourcePsi.containingFile.fileType");
        SpecificationTraverser specificationTraverser = SpecificationTraverserFactory.INSTANCE.getTraverserFor(fileType);
        Intrinsics.checkNotNull((Object)specificationTraverser);
        return specificationTraverser;
    }

    private static final ItemPresentation createCategoryPresentation(SwSyntheticContainer modelElement) {
        ItemPresentation itemPresentation;
        if (SwSyntheticContainerKt.isPathsContainer(modelElement)) {
            itemPresentation = OpenapiStructureViewKt.createItemPresentation$default(SwaggerBundle.message("structure.view.categories.paths", new Object[0]), null, AllIcons.General.Web, null, 8, null);
        } else if (SwSyntheticContainerKt.isComponentsContainer(modelElement)) {
            itemPresentation = OpenapiStructureViewKt.createItemPresentation$default(SwaggerBundle.message("structure.view.categories.openapi.v3.components", new Object[0]), null, AllIcons.Hierarchy.Subtypes, null, 8, null);
        } else if (SwSyntheticContainerKt.isDefinitionsContainer(modelElement)) {
            SwTreeUtil this_$iv = SwTreeUtil.INSTANCE;
            boolean withSelf$iv = false;
            boolean $i$f$getParentOfType = false;
            SwSpecificationFile swSpecificationFile = this_$iv.getParentOfType(((SwModelElement)modelElement).getSourcePsi(), SwSpecificationFile.class, withSelf$iv);
            SpecificationType specificationType = swSpecificationFile != null ? swSpecificationFile.getSpecificationType() : null;
            String presentableText = specificationType == SpecificationType.OPENAPI_3 ? SwaggerBundle.message("structure.view.categories.openapi.v3.top.level.schemes", new Object[0]) : SwaggerBundle.message("structure.view.categories.swagger.v2.definitions", new Object[0]);
            itemPresentation = OpenapiStructureViewKt.createItemPresentation$default(presentableText, null, AllIcons.Hierarchy.Subtypes, null, 8, null);
        } else {
            itemPresentation = SwSyntheticContainerKt.isParametersContainer(modelElement) ? OpenapiStructureViewKt.createItemPresentation$default(SwaggerBundle.message("structure.view.categories.parameters", new Object[0]), null, AllIcons.Hierarchy.Subtypes, null, 8, null) : (SwSyntheticContainerKt.isResponsesContainer(modelElement) ? OpenapiStructureViewKt.createItemPresentation$default(SwaggerBundle.message("structure.view.categories.responses", new Object[0]), null, AllIcons.Hierarchy.Subtypes, null, 8, null) : (SwSyntheticContainerKt.isRequestBodiesContainer(modelElement) ? OpenapiStructureViewKt.createItemPresentation$default(SwaggerBundle.message("structure.view.categories.openapi.v3.request.bodies", new Object[0]), null, AllIcons.Hierarchy.Subtypes, null, 8, null) : (SwSyntheticContainerKt.isCallBacksContainer(modelElement) ? OpenapiStructureViewKt.createItemPresentation$default(SwaggerBundle.message("structure.view.categories.openapi.v3.callbacks", new Object[0]), null, AllIcons.Hierarchy.Subtypes, null, 8, null) : (SwSyntheticContainerKt.isExamplesContainer(modelElement) ? OpenapiStructureViewKt.createItemPresentation$default(SwaggerBundle.message("structure.view.categories.openapi.v3.examples", new Object[0]), null, AllIcons.Hierarchy.Subtypes, null, 8, null) : (SwSyntheticContainerKt.isHeadersContainer(modelElement) ? OpenapiStructureViewKt.createItemPresentation$default(SwaggerBundle.message("structure.view.categories.openapi.v3.headers", new Object[0]), null, AllIcons.Hierarchy.Subtypes, null, 8, null) : (SwSyntheticContainerKt.isLinksContainer(modelElement) ? OpenapiStructureViewKt.createItemPresentation$default(SwaggerBundle.message("structure.view.categories.openapi.v3.links", new Object[0]), null, AllIcons.Hierarchy.Subtypes, null, 8, null) : (SwSyntheticContainerKt.isSecuritySchemesContainer(modelElement) ? OpenapiStructureViewKt.createItemPresentation$default(SwaggerBundle.message("structure.view.categories.openapi.v3.security.schemes", new Object[0]), null, AllIcons.Nodes.Padlock, null, 8, null) : OpenapiStructureViewKt.createItemPresentation$default(modelElement.getContainerName(), null, null, null, 14, null))))))));
        }
        return itemPresentation;
    }

    private static final ItemPresentation createItemPresentation(String presentableText, String locationString, Icon icon, TextAttributesKey attributesKey) {
        return (ItemPresentation)new ColoredItemPresentation(presentableText, locationString, icon, attributesKey){
            final /* synthetic */ String $presentableText;
            final /* synthetic */ String $locationString;
            final /* synthetic */ Icon $icon;
            final /* synthetic */ TextAttributesKey $attributesKey;

            @NotNull
            public String getPresentableText() {
                return this.$presentableText;
            }

            @Nullable
            public String getLocationString() {
                return this.$locationString;
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return this.$icon;
            }

            @Nullable
            public TextAttributesKey getTextAttributesKey() {
                return this.$attributesKey;
            }
            {
                this.$presentableText = $captured_local_variable$0;
                this.$locationString = $captured_local_variable$1;
                this.$icon = $captured_local_variable$2;
                this.$attributesKey = $captured_local_variable$3;
            }
        };
    }

    static /* synthetic */ ItemPresentation createItemPresentation$default(String string, String string2, Icon icon, TextAttributesKey textAttributesKey, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            icon = null;
        }
        if ((n & 8) != 0) {
            textAttributesKey = null;
        }
        return OpenapiStructureViewKt.createItemPresentation(string, string2, icon, textAttributesKey);
    }

    public static final /* synthetic */ StructureViewBuilder access$getStructureViewBuilderOrNull(PsiFile psiFile2) {
        return OpenapiStructureViewKt.getStructureViewBuilderOrNull(psiFile2);
    }

    public static final /* synthetic */ SpecificationTraverser access$traverser(OpenapiStructureViewElement $this$access_u24traverser) {
        return OpenapiStructureViewKt.traverser($this$access_u24traverser);
    }

    public static final /* synthetic */ boolean access$needShowElementInStructure(SwModelElement modelElement) {
        return OpenapiStructureViewKt.needShowElementInStructure(modelElement);
    }

    public static final /* synthetic */ ItemPresentation access$createItemPresentation(String presentableText, String locationString, Icon icon, TextAttributesKey attributesKey) {
        return OpenapiStructureViewKt.createItemPresentation(presentableText, locationString, icon, attributesKey);
    }

    public static final /* synthetic */ ItemPresentation access$createCategoryPresentation(SwSyntheticContainer modelElement) {
        return OpenapiStructureViewKt.createCategoryPresentation(modelElement);
    }
}

