/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.remote;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.intellij.json.JsonFileType;
import com.intellij.microservices.endpoints.EndpointsViewListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.swagger.FileCoordinates;
import com.intellij.swagger.SpecificationType;
import com.intellij.swagger.SwDownloadManager;
import com.intellij.swagger.SwDownloadableFileType;
import com.intellij.swagger.SwaggerBundle;
import com.intellij.swagger.model.remote.RemoteSpecificationFile;
import com.intellij.swagger.model.remote.openapi.v3.Openapi3RemoteSpecificationFile;
import com.intellij.swagger.model.remote.swagger.v2.Swagger2RemoteSpecificationFile;
import com.intellij.swagger.model.specification.SwSpecificationFile;
import com.intellij.swagger.model.specification.SwaggerFileHelper;
import com.intellij.swagger.notifications.SwaggerNotifications;
import com.intellij.swagger.remote.RemoteSpecificationEnricher;
import com.intellij.swagger.remote.RemoteSpecificationManager;
import com.intellij.swagger.remote.RemoteSpecificationManager$WhenMappings;
import com.intellij.swagger.settings.SwaggerSettings;
import com.intellij.swagger.settings.SwaggerSettingsState;
import com.intellij.swagger.settings.UrlInfo;
import com.intellij.util.Url;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLFileType;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001a\u0010\u0018\u001a\f\u0012\u0006\b\u0001\u0012\u00020\b\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J:\u0010\u001c\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u001a\b\u0002\u0010\u001d\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\u00130\u001eJ\u0018\u0010\u001f\u001a\u0004\u0018\u00010\b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/swagger/remote/RemoteSpecificationManager;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "downloadFilesAndNotify", "", "Lcom/intellij/swagger/model/specification/SwSpecificationFile;", "rawSpecificationUrls", "", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "force", "", "notify", "project", "Lcom/intellij/openapi/project/Project;", "fireSpecificationsAdded", "", "guessFactoryByFileType", "Lcom/fasterxml/jackson/core/JsonFactory;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "guessSpecificationClass", "Ljava/lang/Class;", "specificationType", "Lcom/intellij/swagger/SpecificationType;", "queueUpdateRemoteSpecifications", "onFinishHandler", "Lkotlin/Function1;", "tryParseSpecification", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "url", "Lcom/intellij/util/Url;", "intellij.swagger"})
public final class RemoteSpecificationManager {
    private static final Logger LOG;
    @NotNull
    public static final RemoteSpecificationManager INSTANCE;

    /*
     * WARNING - void declaration
     */
    public final void queueUpdateRemoteSpecifications(boolean force, boolean notify, @NotNull Project project, @NotNull Function1<? super List<? extends SwSpecificationFile>, Unit> onFinishHandler) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(onFinishHandler, (String)"onFinishHandler");
        Iterable $this$mapNotNull$iv = ((SwaggerSettingsState)SwaggerSettings.Companion.getInstance(project).getState()).getRemoteSpecificationUrls();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            UrlInfo it = (UrlInfo)element$iv$iv;
            boolean bl2 = false;
            if (it.getUrlString() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List urls = (List)destination$iv$iv;
        new Task.Backgroundable(urls, onFinishHandler, force, notify, project, project, SwaggerBundle.message("actions.reload.all.remote.specifications.title", new Object[0]), true){
            final /* synthetic */ List $urls;
            final /* synthetic */ Function1 $onFinishHandler;
            final /* synthetic */ boolean $force;
            final /* synthetic */ boolean $notify;
            final /* synthetic */ Project $project;

            /*
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                Collection<File> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$mapNotNullTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Iterable $this$mapNotNull$iv = this.$urls;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Object object = $this$forEach$iv$iv$iv.iterator();
                while (object.hasNext()) {
                    FileCoordinates fileCoordinates;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = object.next();
                    boolean bl = false;
                    String it = (String)element$iv$iv;
                    boolean bl2 = false;
                    if (SwDownloadManager.calculateLocalUrlFromRemote$default(SwDownloadManager.INSTANCE, it, SwDownloadableFileType.REMOTE_SPECIFICATION, false, 4, null) == null) continue;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    FileCoordinates it$iv$iv = fileCoordinates;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List filesToDownload = (List)destination$iv$iv;
                $this$mapNotNull$iv = filesToDownload;
                SwDownloadManager swDownloadManager = SwDownloadManager.INSTANCE;
                boolean $i$f$map = false;
                $this$mapNotNullTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    object = (FileCoordinates)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    File file = it.getPath().toFile();
                    collection.add(file);
                }
                collection = (List)destination$iv$iv;
                swDownloadManager.deleteOutdatedDownloads(CollectionsKt.toSet((Iterable)collection), SwDownloadableFileType.REMOTE_SPECIFICATION);
                this.$onFinishHandler.invoke((Object)RemoteSpecificationManager.access$downloadFilesAndNotify(RemoteSpecificationManager.INSTANCE, this.$urls, indicator, this.$force, this.$notify, this.$project));
            }
            {
                this.$urls = $captured_local_variable$0;
                this.$onFinishHandler = $captured_local_variable$1;
                this.$force = $captured_local_variable$2;
                this.$notify = $captured_local_variable$3;
                this.$project = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6, $super_call_param$7);
            }
        }.queue();
    }

    public static /* synthetic */ void queueUpdateRemoteSpecifications$default(RemoteSpecificationManager remoteSpecificationManager, boolean bl, boolean bl2, Project project, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            function1 = queueUpdateRemoteSpecifications.1.INSTANCE;
        }
        remoteSpecificationManager.queueUpdateRemoteSpecifications(bl, bl2, project, (Function1<? super List<? extends SwSpecificationFile>, Unit>)function1);
    }

    /*
     * WARNING - void declaration
     */
    private final List<SwSpecificationFile> downloadFilesAndNotify(List<String> rawSpecificationUrls, ProgressIndicator progressIndicator, boolean force, boolean notify, Project project) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        void $this$mapNotNull$iv2;
        Iterable iterable = rawSpecificationUrls;
        boolean $i$f$mapNotNull22 = false;
        void var9_9 = $this$mapNotNull$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            FileCoordinates fileCoordinates;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (SwDownloadManager.calculateLocalUrlFromRemote$default(SwDownloadManager.INSTANCE, it, SwDownloadableFileType.REMOTE_SPECIFICATION, false, 4, null) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            FileCoordinates it$iv$iv = fileCoordinates;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List filesToDownload = (List)destination$iv$iv;
        Iterable $i$f$mapNotNull22 = filesToDownload;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            element$iv$iv$iv = (FileCoordinates)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)SwDownloadManager.INSTANCE.downloadFile((FileCoordinates)it, progressIndicator, force), (Object)it.getRemoteUrl());
            collection.add(pair);
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            SwSpecificationFile swSpecificationFile;
            void virtualFile2;
            Object element$iv$iv$iv2;
            Object element$iv$iv = element$iv$iv$iv2 = iterator2.next();
            boolean bl = false;
            Pair $dstr$virtualFile$url = (Pair)element$iv$iv;
            boolean bl6 = false;
            VirtualFile virtualFile3 = (VirtualFile)$dstr$virtualFile$url.component1();
            Url url2 = (Url)$dstr$virtualFile$url.component2();
            if ((virtualFile2 != null ? INSTANCE.tryParseSpecification((VirtualFile)virtualFile2, url2) : null) == null) continue;
            swSpecificationFile = swSpecificationFile;
            boolean bl7 = false;
            boolean bl8 = false;
            SwSpecificationFile it$iv$iv = swSpecificationFile;
            boolean bl9 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List processedSpecifications = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
        if (notify) {
            Collection collection = rawSpecificationUrls;
            boolean bl = false;
            if (!collection.isEmpty()) {
                if (processedSpecifications.size() == rawSpecificationUrls.size()) {
                    SwaggerNotifications.INSTANCE.notifySuccessfulSpecificationsLoading$intellij_swagger(processedSpecifications, project);
                } else {
                    SwaggerNotifications.INSTANCE.notifyFailedSpecificationsLoading$intellij_swagger(processedSpecifications.size(), rawSpecificationUrls.size(), project);
                }
            }
        }
        this.fireSpecificationsAdded(project);
        return processedSpecifications;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final SwSpecificationFile tryParseSpecification(@NotNull VirtualFile file, @NotNull Url url2) {
        Object object;
        block12: {
            RemoteSpecificationFile remoteSpecificationFile;
            Object it2;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
            SpecificationType specificationKind = SwaggerFileHelper.calculateSpecificationKind$intellij_swagger$default(SwaggerFileHelper.INSTANCE, file, null, 2, null);
            FileType fileType = file.getFileType();
            Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"file.fileType");
            JsonFactory jsonFactory = this.guessFactoryByFileType(fileType);
            if (jsonFactory == null) {
                return null;
            }
            JsonFactory factory = jsonFactory;
            Class<? extends SwSpecificationFile> specificationClass = this.guessSpecificationClass(specificationKind);
            if (specificationClass == null) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(RemoteSpecificationManager.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                logger.warn("Unable to determine specification type for file with url: '" + url2.toDecodedForm() + '\'');
                return null;
            }
            object = new InputStreamReader(file.getInputStream());
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                SwSpecificationFile swSpecificationFile;
                it2 = (InputStreamReader)object;
                boolean bl3 = false;
                try {
                    swSpecificationFile = (SwSpecificationFile)new ObjectMapper(factory).readValue((Reader)it2, specificationClass);
                }
                catch (IOException ex) {
                    if (!(ex instanceof JsonParseException) && !(ex instanceof JsonMappingException)) {
                        throw (Throwable)ex;
                    }
                    LOG.warn("Unable to read " + (Object)((Object)specificationKind) + " specification into " + specificationClass + " class", (Throwable)ex);
                    swSpecificationFile = null;
                }
                it2 = swSpecificationFile;
            }
            catch (Throwable it2) {
                throwable = it2;
                throw it2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = it2;
            bl = false;
            boolean bl4 = false;
            it2 = object;
            boolean bl5 = false;
            Object $this$castSafelyTo$iv = it2;
            boolean $i$f$castSafelyTo = false;
            Object object2 = $this$castSafelyTo$iv;
            if (!(object2 instanceof RemoteSpecificationFile)) {
                object2 = null;
            }
            if ((remoteSpecificationFile = (RemoteSpecificationFile)object2) == null || (remoteSpecificationFile = RemoteSpecificationEnricher.INSTANCE.withExternalUrl(remoteSpecificationFile, url2)) == null || (remoteSpecificationFile = RemoteSpecificationEnricher.INSTANCE.withVirtualFile(remoteSpecificationFile, file)) == null) break block12;
            FileType fileType2 = file.getFileType();
            Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"file.fileType");
            RemoteSpecificationEnricher.INSTANCE.reformatAndWriteToTheDisk(remoteSpecificationFile, INSTANCE.guessFactoryByFileType(fileType2));
        }
        return object;
    }

    private final void fireSpecificationsAdded(Project project) {
        ((EndpointsViewListener)project.getMessageBus().syncPublisher(EndpointsViewListener.Companion.getTOPIC())).endpointsChanged(new EndpointsViewListener.ChangeEvent(project, EndpointsViewListener.ChangeType.ITEMS));
    }

    private final JsonFactory guessFactoryByFileType(FileType fileType) {
        FileType fileType2 = fileType;
        return fileType2 instanceof JsonFileType ? new JsonFactory() : (fileType2 instanceof YAMLFileType ? (JsonFactory)new YAMLFactory() : null);
    }

    private final Class<? extends SwSpecificationFile> guessSpecificationClass(SpecificationType specificationType) {
        Class clazz;
        switch (RemoteSpecificationManager$WhenMappings.$EnumSwitchMapping$0[specificationType.ordinal()]) {
            case 1: {
                clazz = Swagger2RemoteSpecificationFile.class;
                break;
            }
            case 2: {
                clazz = Openapi3RemoteSpecificationFile.class;
                break;
            }
            default: {
                clazz = null;
            }
        }
        return clazz;
    }

    private RemoteSpecificationManager() {
    }

    static {
        RemoteSpecificationManager remoteSpecificationManager;
        INSTANCE = remoteSpecificationManager = new RemoteSpecificationManager();
        Logger logger = Logger.getInstance(RemoteSpecificationManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Remot\u2026ationManager::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ List access$downloadFilesAndNotify(RemoteSpecificationManager $this, List rawSpecificationUrls, ProgressIndicator progressIndicator, boolean force, boolean notify, Project project) {
        return $this.downloadFilesAndNotify(rawSpecificationUrls, progressIndicator, force, notify, project);
    }
}

