/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.reference.definitions;

import com.intellij.swagger.reference.definitions.SwCoordinateItem;
import com.intellij.swagger.reference.definitions.SwDefinitionReferenceBuilderKt;
import com.intellij.util.PathUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001c\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0006\u0010\u0015\u001a\u00020\u0014J\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0017\u001a\u00020\u0014R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/intellij/swagger/reference/definitions/SwObjectCoordinates;", "", "objectsStorageUri", "Lcom/intellij/swagger/reference/definitions/SwCoordinateItem;", "objectDefinition", "Lcom/intellij/swagger/reference/definitions/SwCoordinateItem$SwDefinitionItem;", "(Lcom/intellij/swagger/reference/definitions/SwCoordinateItem;Lcom/intellij/swagger/reference/definitions/SwCoordinateItem$SwDefinitionItem;)V", "definitionCoordinates", "", "getDefinitionCoordinates", "()Ljava/lang/String;", "uriValue", "getUriValue", "computeCompletedDefinitionSegment", "caretOffsetInElement", "", "computeCompletedStorageUriSegment", "Lkotlin/Pair;", "getIndexOfCharBeforeCaret", "hasCompletedRelativePath", "", "isEmpty", "isStorageEdited", "isWebCoordinates", "intellij.swagger"})
public final class SwObjectCoordinates {
    private final SwCoordinateItem objectsStorageUri;
    private final SwCoordinateItem.SwDefinitionItem objectDefinition;

    @Nullable
    public final String getUriValue() {
        SwCoordinateItem swCoordinateItem = this.objectsStorageUri;
        return swCoordinateItem != null ? swCoordinateItem.getValue() : null;
    }

    @Nullable
    public final String getDefinitionCoordinates() {
        SwCoordinateItem.SwDefinitionItem swDefinitionItem = this.objectDefinition;
        return swDefinitionItem != null ? swDefinitionItem.getValue() : null;
    }

    public final boolean isEmpty() {
        return SwDefinitionReferenceBuilderKt.isNullOrEmpty(this.objectsStorageUri) && SwDefinitionReferenceBuilderKt.isNullOrEmpty(this.objectDefinition);
    }

    public final boolean isWebCoordinates() {
        return this.objectsStorageUri instanceof SwCoordinateItem.SwWebUrlItem;
    }

    public final boolean isStorageEdited(int caretOffsetInElement) {
        boolean isCaretInUriRange;
        boolean bl;
        SwCoordinateItem swCoordinateItem = this.objectsStorageUri;
        if (swCoordinateItem != null && (swCoordinateItem = swCoordinateItem.getRangeInElement()) != null) {
            int n = 0;
            int n2 = this.getIndexOfCharBeforeCaret(caretOffsetInElement);
            boolean bl2 = false;
            bl = swCoordinateItem.contains(Math.max(n, n2));
        } else {
            bl = isCaretInUriRange = false;
        }
        if (!isCaretInUriRange) {
            return false;
        }
        return !this.hasCompletedRelativePath(caretOffsetInElement);
    }

    @Nullable
    public final Pair<String, String> computeCompletedStorageUriSegment(int caretOffsetInElement) {
        Pair pair;
        if (this.objectsStorageUri == null) {
            return null;
        }
        int n = this.objectsStorageUri.getValue().length();
        boolean bl = false;
        int caretOffsetInValue = Math.min(n, caretOffsetInElement);
        CharSequence charSequence = this.objectsStorageUri.getValue();
        int n2 = 0;
        boolean bl2 = false;
        String string = charSequence;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.substring(n2, caretOffsetInValue);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String substringBeforeCaret = string2;
        charSequence = PathUtil.getFileExtension((String)substringBeforeCaret);
        n2 = 0;
        bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            return TuplesKt.to((Object)substringBeforeCaret, (Object)"");
        }
        int lastSlashIndex = StringsKt.lastIndexOf$default((CharSequence)substringBeforeCaret, (String)"/", (int)0, (boolean)false, (int)6, null);
        if (lastSlashIndex == -1) {
            pair = TuplesKt.to((Object)substringBeforeCaret, (Object)"");
        } else {
            String string3 = substringBeforeCaret;
            int n3 = 0;
            int n4 = 0;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n3, lastSlashIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String completeSegment = string5;
            String string6 = substringBeforeCaret;
            n4 = lastSlashIndex + 1;
            boolean bl3 = false;
            String string7 = string6;
            if (string7 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string8 = string7.substring(n4);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
            String incompleteSegment = string8;
            pair = TuplesKt.to((Object)completeSegment, (Object)incompleteSegment);
        }
        return pair;
    }

    @Nullable
    public final String computeCompletedDefinitionSegment(int caretOffsetInElement) {
        String string;
        if (this.objectDefinition == null) {
            return null;
        }
        int referenceRootIndex = StringsKt.indexOf$default((CharSequence)this.objectDefinition.getValue(), (String)"#/", (int)0, (boolean)false, (int)6, null);
        int definitionSegmentStart = referenceRootIndex == -1 ? 0 : referenceRootIndex + "#/".length();
        int n = this.getIndexOfCharBeforeCaret(caretOffsetInElement);
        SwCoordinateItem swCoordinateItem = this.objectsStorageUri;
        String string2 = swCoordinateItem != null ? swCoordinateItem.getValue() : null;
        int n2 = 0;
        String string3 = string2;
        if (string3 == null) {
            string3 = "";
        }
        int n3 = n - string3.length();
        n2 = 0;
        boolean bl = false;
        int relativeCaretOffsetInDefinition = Math.max(n3, n2);
        n2 = this.objectDefinition.getValue().length();
        bl = false;
        int caretOffsetInValue = Math.min(n2, relativeCaretOffsetInDefinition);
        if (caretOffsetInValue >= definitionSegmentStart) {
            String string4 = this.objectDefinition.getValue();
            bl = false;
            String string5 = string4;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(definitionSegmentStart, caretOffsetInValue);
            string = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string = null;
        }
        return string;
    }

    private final boolean hasCompletedRelativePath(int caretOffsetInElement) {
        Pair<String, String> pair = this.computeCompletedStorageUriSegment(caretOffsetInElement);
        CharSequence charSequence = pair != null ? (String)pair.getFirst() : null;
        boolean bl = false;
        CharSequence charSequence2 = charSequence;
        if (charSequence2 == null) {
            charSequence2 = "";
        }
        String completedPathSegment = charSequence2;
        charSequence = PathUtil.getFileExtension((String)completedPathSegment);
        bl = false;
        boolean bl2 = false;
        return !(charSequence == null || charSequence.length() == 0);
    }

    private final int getIndexOfCharBeforeCaret(int caretOffsetInElement) {
        return caretOffsetInElement - 1;
    }

    public SwObjectCoordinates(@Nullable SwCoordinateItem objectsStorageUri, @Nullable SwCoordinateItem.SwDefinitionItem objectDefinition) {
        this.objectsStorageUri = objectsStorageUri;
        this.objectDefinition = objectDefinition;
    }

    public /* synthetic */ SwObjectCoordinates(SwCoordinateItem swCoordinateItem, SwCoordinateItem.SwDefinitionItem swDefinitionItem, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            swCoordinateItem = null;
        }
        if ((n & 2) != 0) {
            swDefinitionItem = null;
        }
        this(swCoordinateItem, swDefinitionItem);
    }

    public SwObjectCoordinates() {
        this(null, null, 3, null);
    }
}

