/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.reference.definitions;

import com.intellij.openapi.util.TextRange;
import com.intellij.swagger.reference.definitions.SwCoordinateItem;
import com.intellij.swagger.reference.definitions.SwObjectCoordinates;
import com.intellij.util.Urls;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\b\u00a8\u0006\f"}, d2={"Lcom/intellij/swagger/reference/definitions/SwDefinitionCoordinatesParser;", "", "()V", "buildUriItem", "Lcom/intellij/swagger/reference/definitions/SwCoordinateItem;", "rawValue", "", "rangeInElement", "Lcom/intellij/openapi/util/TextRange;", "parseObjectCoordinates", "Lcom/intellij/swagger/reference/definitions/SwObjectCoordinates;", "valueRangeInElement", "intellij.swagger"})
public final class SwDefinitionCoordinatesParser {
    @NotNull
    public static final SwDefinitionCoordinatesParser INSTANCE;

    @NotNull
    public final SwObjectCoordinates parseObjectCoordinates(@NotNull String rawValue, @NotNull TextRange valueRangeInElement) {
        TextRange textRange;
        TextRange pathOrUrlRange;
        Intrinsics.checkNotNullParameter((Object)rawValue, (String)"rawValue");
        Intrinsics.checkNotNullParameter((Object)valueRangeInElement, (String)"valueRangeInElement");
        int objectDefinitionCoordinatesIndex = StringsKt.indexOf$default((CharSequence)rawValue, (String)"#/", (int)0, (boolean)false, (int)6, null);
        if (objectDefinitionCoordinatesIndex == -1) {
            return new SwObjectCoordinates(this.buildUriItem(rawValue, valueRangeInElement), null, 2, null);
        }
        TextRange textRange2 = TextRange.create((int)0, (int)objectDefinitionCoordinatesIndex).intersection(valueRangeInElement);
        if (textRange2 == null) {
            textRange2 = pathOrUrlRange = TextRange.EMPTY_RANGE;
        }
        if ((textRange = TextRange.create((int)objectDefinitionCoordinatesIndex, (int)StringsKt.getLastIndex((CharSequence)rawValue)).intersection(valueRangeInElement)) == null) {
            textRange = TextRange.EMPTY_RANGE;
        }
        TextRange definitionRange = textRange;
        TextRange textRange3 = pathOrUrlRange;
        Intrinsics.checkNotNullExpressionValue((Object)textRange3, (String)"pathOrUrlRange");
        SwCoordinateItem swCoordinateItem = this.buildUriItem(rawValue, textRange3);
        String string = definitionRange.substring(rawValue);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"definitionRange.substring(rawValue)");
        TextRange textRange4 = definitionRange;
        Intrinsics.checkNotNullExpressionValue((Object)textRange4, (String)"definitionRange");
        return new SwObjectCoordinates(swCoordinateItem, new SwCoordinateItem.SwDefinitionItem(string, textRange4));
    }

    private final SwCoordinateItem buildUriItem(String rawValue, TextRange rangeInElement) {
        SwCoordinateItem swCoordinateItem;
        if (Urls.parse((String)rawValue, (boolean)false) != null) {
            String string = rangeInElement.substring(rawValue);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"rangeInElement.substring(rawValue)");
            swCoordinateItem = new SwCoordinateItem.SwWebUrlItem(string, rangeInElement);
        } else {
            String string = rangeInElement.substring(rawValue);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"rangeInElement.substring(rawValue)");
            swCoordinateItem = new SwCoordinateItem.SwLocalPathItem(string, rangeInElement);
        }
        return swCoordinateItem;
    }

    private SwDefinitionCoordinatesParser() {
    }

    static {
        SwDefinitionCoordinatesParser swDefinitionCoordinatesParser;
        INSTANCE = swDefinitionCoordinatesParser = new SwDefinitionCoordinatesParser();
    }
}

