/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.providers.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.swagger.model.SwaggerMergedModel;
import com.intellij.swagger.model.api.SwMetaHolder;
import com.intellij.swagger.model.api.SwModelBase;
import com.intellij.swagger.model.api.SwModelElement;
import com.intellij.swagger.model.api.SwUrl;
import com.intellij.swagger.providers.resolve.SpecificationResolveHelperKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a+\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006H\u0000\u00a2\u0006\u0002\u0010\u0007\u001a\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0000\u00a8\u0006\u000e"}, d2={"resolveLocalObject", "Lcom/intellij/psi/PsiElement;", "psiFile", "Lcom/intellij/psi/PsiFile;", "path", "", "", "(Lcom/intellij/psi/PsiFile;[Ljava/lang/String;)Lcom/intellij/psi/PsiElement;", "resolveUrl", "Lkotlin/sequences/Sequence;", "Lcom/intellij/swagger/model/api/SwUrl;", "searchedUrl", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "intellij.swagger"})
public final class SpecificationResolveHelperKt {
    @NotNull
    public static final Sequence<SwUrl> resolveUrl(@NotNull String searchedUrl, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter((Object)searchedUrl, (String)"searchedUrl");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Project project = scope.getProject();
        if (project == null) {
            return SequencesKt.emptySequence();
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"scope.project ?: return emptySequence()");
        Project project2 = project;
        return SequencesKt.filter((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)SwaggerMergedModel.Companion.getInstance(project2).getBaseModelElements(scope)), (Function1)((Function1)new Function1<SwModelBase, SwModelBase>(project2){
            final /* synthetic */ Project $project;

            @NotNull
            public final SwModelBase invoke(@NotNull SwModelBase it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.substitute(this.$project);
            }
            {
                this.$project = project;
                super(1);
            }
        })), (Function1)resolveUrl.2.INSTANCE), (Function1)((Function1)new Function1<SwUrl, Boolean>(searchedUrl){
            final /* synthetic */ String $searchedUrl;

            public final boolean invoke(@NotNull SwUrl it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getUrlString(), (Object)this.$searchedUrl);
            }
            {
                this.$searchedUrl = string;
                super(1);
            }
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final PsiElement resolveLocalObject(@NotNull PsiFile psiFile2, String ... path) {
        Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Project project = psiFile2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"psiFile.project");
        SwaggerMergedModel swaggerMergedModel = SwaggerMergedModel.Companion.getInstance(project);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((PsiFile)psiFile2);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.fileScope(psiFile)");
        SwModelBase swModelBase = (SwModelBase)CollectionsKt.firstOrNull(swaggerMergedModel.getBaseModelElements(globalSearchScope));
        SwModelElement swModelElement = swModelBase;
        if (swModelBase == null) return null;
        SwModelBase swModelBase2 = swModelElement;
        boolean bl = false;
        boolean bl2 = false;
        SwModelBase it = swModelBase2;
        boolean bl3 = false;
        Project project2 = psiFile2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"psiFile.project");
        SwModelBase swModelBase3 = it.substitute(project2);
        if (!(swModelBase3 instanceof SwMetaHolder)) {
            swModelBase3 = null;
        }
        SwMetaHolder swMetaHolder = (SwMetaHolder)((Object)swModelBase3);
        swModelElement = swMetaHolder;
        if (swMetaHolder == null) return null;
        PsiElement psiElement = swModelElement.find(Arrays.copyOf(path, path.length));
        return psiElement;
    }
}

