/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.providers.endpoints;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.json.psi.JsonProperty;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsDocumentationProvider;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.ExternalEndpointsFilter;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.SearchScopeEndpointsFilter;
import com.intellij.microservices.endpoints.presentation.HttpMethodPresentation;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.microservices.utils.EndpointsViewUtils;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.ValueKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.swagger.SwaggerBundle;
import com.intellij.swagger.SwaggerIcons;
import com.intellij.swagger.SwaggerUiUtilsKt;
import com.intellij.swagger.SwaggerUtilsKt;
import com.intellij.swagger.documentation.SwDocumentationUtilsKt;
import com.intellij.swagger.model.SwaggerMergedModel;
import com.intellij.swagger.model.api.SwEndpoint;
import com.intellij.swagger.model.api.SwModelBase;
import com.intellij.swagger.model.remote.RemoteSpecificationModel;
import com.intellij.swagger.model.specification.SpecificationBasedModel;
import com.intellij.swagger.model.specification.SpecificationHttpOperation;
import com.intellij.swagger.model.specification.SwSpecificationFile;
import com.intellij.swagger.providers.endpoints.SwEndpointsProvider;
import com.intellij.swagger.providers.resolve.SwUrlTargetUtilsKt;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLKeyValue;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0004:\u0001-B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\"\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J \u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030\u001d2\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J\u0010\u0010%\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0002H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\u0018\u0010,\u001a\u00020+2\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0003H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006."}, d2={"Lcom/intellij/swagger/providers/endpoints/SwEndpointsProvider;", "Lcom/intellij/microservices/endpoints/EndpointsProvider;", "Lcom/intellij/swagger/model/api/SwModelBase;", "Lcom/intellij/swagger/model/api/SwEndpoint;", "Lcom/intellij/microservices/endpoints/EndpointsDocumentationProvider;", "()V", "endpointType", "Lcom/intellij/microservices/endpoints/EndpointType;", "getEndpointType", "()Lcom/intellij/microservices/endpoints/EndpointType;", "presentation", "Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getPresentation", "()Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "createLightEditor", "Ljavax/swing/JComponent;", "psiElement", "Lcom/intellij/psi/PsiElement;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "getElementPreviewText", "", "getEndpointData", "", "group", "endpoint", "dataId", "getEndpointDocumentation", "getEndpointGroups", "", "project", "Lcom/intellij/openapi/project/Project;", "filter", "Lcom/intellij/microservices/endpoints/EndpointsFilter;", "getEndpointPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getEndpoints", "getLocationString", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getStatus", "Lcom/intellij/microservices/endpoints/EndpointsProvider$Status;", "isDeprecated", "", "isValidEndpoint", "DisposablePanel", "intellij.swagger"})
public final class SwEndpointsProvider
implements EndpointsProvider<SwModelBase, SwEndpoint>,
EndpointsDocumentationProvider<SwModelBase, SwEndpoint> {
    @NotNull
    private final FrameworkPresentation presentation = new FrameworkPresentation("OpenAPI", SwaggerBundle.message("openapi.specification", new Object[0]), SwaggerIcons.Openapi);

    @NotNull
    public EndpointType getEndpointType() {
        return EndpointTypes.API_DEFINITION_TYPE;
    }

    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (SwaggerMergedModel.Companion.getInstance(project).hasSpecifications()) {
            return EndpointsProvider.Status.HAS_ENDPOINTS;
        }
        return EndpointsProvider.Status.AVAILABLE;
    }

    @NotNull
    public FrameworkPresentation getPresentation() {
        return this.presentation;
    }

    @Nullable
    public Object getEndpointData(@NotNull SwModelBase group, @NotNull SwEndpoint endpoint, @NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        ValueKey.BeforeIf beforeIf = ValueKey.match((String)dataId).ifEq((ValueKey)EndpointsProvider.URL_TARGET_INFO).thenGet(new Supplier(endpoint){
            final /* synthetic */ SwEndpoint $endpoint;

            /*
             * Enabled aggressive block sorting
             */
            public final Iterable<UrlTargetInfo> get() {
                Iterable iterable;
                Object object = SwUrlTargetUtilsKt.createEndpointData$default(this.$endpoint, null, false, 6, null);
                if (object != null) {
                    UrlTargetInfo urlTargetInfo = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    UrlTargetInfo p1 = urlTargetInfo;
                    boolean bl3 = false;
                    object = SetsKt.setOf((Object)p1);
                    if (object != null) {
                        iterable = (Iterable)object;
                        return iterable;
                    }
                }
                iterable = SetsKt.emptySet();
                return iterable;
            }
            {
                this.$endpoint = swEndpoint;
            }
        }).ifEq((ValueKey)EndpointsProvider.OPENAPI_PATH).thenGet((Supplier)getEndpointData.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)beforeIf, (String)"ValueKey.match(dataId)\n \u2026).thenGet { emptyList() }");
        return EndpointsViewUtils.orCheckCommonEndpointKeys((ValueKey.BeforeIf)beforeIf, (PsiElement)endpoint.getSourcePsi());
    }

    @NotNull
    public ItemPresentation getEndpointPresentation(@NotNull SwModelBase group, @NotNull SwEndpoint endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        TextAttributesKey textAttributesKey = CodeInsightColors.DEPRECATED_ATTRIBUTES;
        boolean bl = false;
        boolean bl2 = false;
        TextAttributesKey textAttributesKey2 = textAttributesKey;
        Icon icon = SwaggerIcons.Endpoint;
        String string = this.getLocationString(group);
        String string2 = endpoint.getHttpMethod().getValue();
        String string3 = endpoint.getUrl();
        boolean bl3 = false;
        boolean bl4 = this.isDeprecated(endpoint);
        TextAttributesKey textAttributesKey3 = bl4 ? textAttributesKey : null;
        Icon icon2 = icon;
        String string4 = string;
        String string5 = string2;
        String string6 = string3;
        return (ItemPresentation)new HttpMethodPresentation(string6, string5, string4, icon2, textAttributesKey3);
    }

    private final boolean isDeprecated(SwEndpoint endpoint) {
        Object object;
        SwEndpoint $this$castSafelyTo$iv = endpoint;
        boolean $i$f$castSafelyTo = false;
        SwEndpoint swEndpoint = $this$castSafelyTo$iv;
        if (!(swEndpoint instanceof SpecificationHttpOperation)) {
            swEndpoint = null;
        }
        return (object = (SpecificationHttpOperation)swEndpoint) != null && (object = ((SpecificationHttpOperation)object).isDeprecated()) != null && (object = (Boolean)object.getValue()) != null ? (Boolean)object : false;
    }

    private final String getLocationString(SwModelBase group) {
        Object object;
        String presentablePath;
        if (group.isRemote() && group instanceof SwSpecificationFile && (presentablePath = SwaggerUtilsKt.suggestRemoteSpecificationUrl((SwSpecificationFile)group)) != null) {
            return presentablePath;
        }
        PsiElement psiElement = group.getSourcePsi();
        if (!(psiElement instanceof PsiNamedElement)) {
            psiElement = null;
        }
        if ((object = (PsiNamedElement)psiElement) == null || (object = object.getName()) == null) {
            object = SwaggerBundle.message("unknown.specification", new Object[0]);
        }
        return object;
    }

    @NotNull
    public JComponent getEndpointDocumentation(@NotNull SwModelBase group, @NotNull SwEndpoint endpoint, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        PsiElement psiElement = endpoint.getSourcePsi();
        Intrinsics.checkNotNull((Object)psiElement);
        return this.createLightEditor(psiElement, parentDisposable);
    }

    private final JComponent createLightEditor(PsiElement psiElement, Disposable parentDisposable) {
        Project project = psiElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"psiElement.project");
        Project project2 = project;
        LanguageFileType fileType = FileTypeManager.getInstance().findFileTypeByLanguage(psiElement.getLanguage());
        if (fileType == null) {
            DocumentationComponent documentationComponent = DocumentationComponent.createAndFetch((Project)project2, (PsiElement)psiElement, (Disposable)parentDisposable);
            Intrinsics.checkNotNullExpressionValue((Object)documentationComponent, (String)"DocumentationComponent.c\u2026lement, parentDisposable)");
            return (JComponent)documentationComponent;
        }
        String string = fileType.getDefaultExtension();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fileType.defaultExtension");
        String ext = string;
        LightVirtualFile virtualFile2 = new LightVirtualFile("openapi-endpoint-preview." + ext, (FileType)fileType, (CharSequence)this.getElementPreviewText(psiElement));
        EditorEx editor = SwaggerUiUtilsKt.createOpenApiPreviewEditor(project2, (VirtualFile)virtualFile2);
        return (JComponent)((Object)new DisposablePanel(parentDisposable, (Editor)editor));
    }

    private final String getElementPreviewText(PsiElement psiElement) {
        String string;
        PsiElement psiElement2 = psiElement;
        if (psiElement2 instanceof YAMLKeyValue) {
            string = SwDocumentationUtilsKt.yamlDocumentationFragment$default((YAMLKeyValue)psiElement, false, 2, null);
        } else if (psiElement2 instanceof JsonProperty) {
            string = SwDocumentationUtilsKt.jsonDocumentationFragment$default((JsonProperty)psiElement, false, 2, null);
        } else {
            String string2 = psiElement.getText();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"psiElement.text");
        }
        return string;
    }

    public boolean isValidEndpoint(@NotNull SwModelBase group, @NotNull SwEndpoint endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return SwaggerUtilsKt.isElementValid(endpoint);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Iterable<SwModelBase> getEndpointGroups(@NotNull Project project, @NotNull EndpointsFilter filter) {
        SearchScopeEndpointsFilter searchScopeEndpointsFilter;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        if (filter instanceof ExternalEndpointsFilter) {
            void $this$mapTo$iv$iv;
            RemoteSpecificationModel remoteModel = RemoteSpecificationModel.Companion.getInstance(project);
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(project)");
            Iterable $this$map$iv = remoteModel.getBaseModelElements(globalSearchScope);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SwSpecificationFile swSpecificationFile = (SwSpecificationFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                SwModelBase swModelBase = it.substitute(project);
                collection.add(swModelBase);
            }
            return (List)destination$iv$iv;
        }
        EndpointsFilter endpointsFilter = filter;
        if (!(endpointsFilter instanceof SearchScopeEndpointsFilter)) {
            endpointsFilter = null;
        }
        if ((searchScopeEndpointsFilter = (SearchScopeEndpointsFilter)endpointsFilter) == null || (searchScopeEndpointsFilter = searchScopeEndpointsFilter.getSearchScope()) == null) {
            return CollectionsKt.emptyList();
        }
        SearchScopeEndpointsFilter searchScope = searchScopeEndpointsFilter;
        return SpecificationBasedModel.INSTANCE.getBaseModelElements((GlobalSearchScope)searchScope);
    }

    @NotNull
    public Iterable<SwEndpoint> getEndpoints(@NotNull SwModelBase group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        return group.getEndpoints();
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return SwaggerUtilsKt.getYamlJsonModificationTracker(project);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/intellij/swagger/providers/endpoints/SwEndpointsProvider$DisposablePanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/openapi/Disposable;", "parent", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/editor/Editor;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "dispose", "", "intellij.swagger"})
    private static final class DisposablePanel
    extends BorderLayoutPanel
    implements Disposable {
        @NotNull
        private final Editor editor;

        public void dispose() {
            EditorFactory.getInstance().releaseEditor(this.editor);
        }

        @NotNull
        public final Editor getEditor() {
            return this.editor;
        }

        public DisposablePanel(@NotNull Disposable parent, @NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            this.editor = editor;
            Disposer.register((Disposable)parent, (Disposable)this);
            this.addToCenter(this.editor.getComponent());
        }
    }
}

