/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.providers;

import com.intellij.ide.presentation.Presentation;
import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlResolveRequest;
import com.intellij.microservices.url.UrlResolver;
import com.intellij.microservices.url.UrlResolverFactory;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.swagger.SwaggerUtilsKt;
import com.intellij.swagger.model.SwaggerMergedModel;
import com.intellij.swagger.model.api.SwAuthority;
import com.intellij.swagger.model.api.SwHttpOperation;
import com.intellij.swagger.model.api.SwModelBase;
import com.intellij.swagger.model.api.SwSchema;
import com.intellij.swagger.model.api.SwUrl;
import com.intellij.swagger.providers.resolve.SpecificationResolveHelperKt;
import com.intellij.swagger.providers.resolve.SwUrlTargetUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(typeName="Swagger", icon="com.intellij.swagger.SwaggerIcons.Endpoint")
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u001aH\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\t\u00a8\u0006\u001f"}, d2={"Lcom/intellij/swagger/providers/SwUrlResolver;", "Lcom/intellij/microservices/url/UrlResolver;", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "authorityHints", "", "Lcom/intellij/microservices/url/Authority$Exact;", "getAuthorityHints", "()Ljava/util/List;", "model", "Lcom/intellij/swagger/model/SwaggerMergedModel;", "projectSearchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "Lorg/jetbrains/annotations/NotNull;", "supportedSchemes", "", "getSupportedSchemes", "collectEndpoints", "Lkotlin/sequences/Sequence;", "Lcom/intellij/microservices/url/UrlTargetInfo;", "url", "Lcom/intellij/swagger/model/api/SwUrl;", "isRemote", "", "getVariants", "", "resolve", "request", "Lcom/intellij/microservices/url/UrlResolveRequest;", "Factory", "intellij.swagger"})
public final class SwUrlResolver
implements UrlResolver {
    private final SwaggerMergedModel model;
    private final GlobalSearchScope projectSearchScope;
    private final Project myProject;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Authority.Exact> getAuthorityHints() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.model.getAuthorities(this.projectSearchScope);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SwAuthority swAuthority = (SwAuthority)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Authority.Exact exact = new Authority.Exact(it.getAuthorityValue().getValue());
            collection.add(exact);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> getSupportedSchemes() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.model.getSchemes(this.projectSearchScope);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SwSchema swSchema = (SwSchema)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = SwaggerUtilsKt.withEndingSlash(it.getSchemaValue().getValue());
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public Iterable<UrlTargetInfo> resolve(@NotNull UrlResolveRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMap((Sequence)UrlPath.Companion.combinations(request.getPath()), (Function1)((Function1)new Function1<UrlPath, Sequence<? extends UrlTargetInfo>>(this){
            final /* synthetic */ SwUrlResolver this$0;

            @NotNull
            public final Sequence<UrlTargetInfo> invoke(@NotNull UrlPath it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return SequencesKt.flatMap(SpecificationResolveHelperKt.resolveUrl(SwaggerUtilsKt.withLeadingSlash(it.toStringWithStars()), SwUrlResolver.access$getProjectSearchScope$p(this.this$0)), (Function1)((Function1)new Function1<SwUrl, Sequence<? extends UrlTargetInfo>>(this.this$0){

                    @NotNull
                    public final Sequence<UrlTargetInfo> invoke(@NotNull SwUrl p1) {
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        return SwUrlResolver.collectEndpoints$default((SwUrlResolver)this.receiver, p1, false, 2, null);
                    }
                }));
            }
            {
                this.this$0 = swUrlResolver;
                super(1);
            }
        })));
    }

    @NotNull
    public Iterable<UrlTargetInfo> getVariants() {
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.model.getBaseModelElements(this.projectSearchScope)), (Function1)((Function1)new Function1<SwModelBase, SwModelBase>(this){
            final /* synthetic */ SwUrlResolver this$0;

            @NotNull
            public final SwModelBase invoke(@NotNull SwModelBase it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.substitute(SwUrlResolver.access$getMyProject$p(this.this$0));
            }
            {
                this.this$0 = swUrlResolver;
                super(1);
            }
        })), (Function1)((Function1)new Function1<SwModelBase, List<? extends UrlTargetInfo>>(this){
            final /* synthetic */ SwUrlResolver this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<UrlTargetInfo> invoke(@NotNull SwModelBase model) {
                void $this$flatMapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                Iterable $this$flatMap$iv = model.getUrls();
                boolean $i$f$flatMapSequence = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapSequenceTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    SwUrl it = (SwUrl)element$iv$iv;
                    boolean bl = false;
                    Sequence list$iv$iv = SwUrlResolver.access$collectEndpoints(this.this$0, it, model.isRemote());
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Sequence)list$iv$iv);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = swUrlResolver;
                super(1);
            }
        })));
    }

    private final Sequence<UrlTargetInfo> collectEndpoints(SwUrl url2, boolean isRemote) {
        List<SwHttpOperation> supportedOperations = url2.getSupportedOperations();
        Collection collection = supportedOperations;
        boolean bl = false;
        return !collection.isEmpty() ? SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)supportedOperations), (Function1)((Function1)new Function1<SwHttpOperation, UrlTargetInfo>(url2, isRemote){
            final /* synthetic */ SwUrl $url;
            final /* synthetic */ boolean $isRemote;

            @Nullable
            public final UrlTargetInfo invoke(@NotNull SwHttpOperation it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return SwUrlTargetUtilsKt.createEndpointData(it, this.$url.getUrlString(), this.$isRemote);
            }
            {
                this.$url = swUrl;
                this.$isRemote = bl;
                super(1);
            }
        })) : SequencesKt.sequenceOf((Object[])new UrlTargetInfo[]{SwUrlTargetUtilsKt.createUrlData(url2)});
    }

    static /* synthetic */ Sequence collectEndpoints$default(SwUrlResolver swUrlResolver, SwUrl swUrl, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return swUrlResolver.collectEndpoints(swUrl, bl);
    }

    public SwUrlResolver(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        this.model = SwaggerMergedModel.Companion.getInstance(this.myProject);
        GlobalSearchScope globalSearchScope = ProjectScope.getProjectScope((Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"ProjectScope.getProjectScope(myProject)");
        this.projectSearchScope = globalSearchScope;
    }

    public static final /* synthetic */ GlobalSearchScope access$getProjectSearchScope$p(SwUrlResolver $this) {
        return $this.projectSearchScope;
    }

    public static final /* synthetic */ Project access$getMyProject$p(SwUrlResolver $this) {
        return $this.myProject;
    }

    public static final /* synthetic */ Sequence access$collectEndpoints(SwUrlResolver $this, SwUrl url2, boolean isRemote) {
        return $this.collectEndpoints(url2, isRemote);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/swagger/providers/SwUrlResolver$Factory;", "Lcom/intellij/microservices/url/UrlResolverFactory;", "()V", "forProject", "Lcom/intellij/microservices/url/UrlResolver;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.swagger"})
    public static final class Factory
    implements UrlResolverFactory {
        @Nullable
        public UrlResolver forProject(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return SwaggerMergedModel.Companion.getInstance(project).hasSpecifications() ? (UrlResolver)new SwUrlResolver(project) : null;
        }
    }
}

