/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.providers;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.swagger.SpecificationType;
import com.intellij.swagger.SwaggerUtilsKt;
import com.intellij.swagger.providers.SwJsonSchemaPatchUtils$WhenMappings;
import com.intellij.swagger.providers.SwJsonSchemaPatchUtils$hasTextNode$;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\rH\u0002J\u0016\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0016J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00162\u0006\u0010\b\u001a\u00020\u0004J\f\u0010\u001c\u001a\u00020\u0004*\u00020\u0016H\u0002J\u0014\u0010\u001d\u001a\u00020\u0014*\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/swagger/providers/SwJsonSchemaPatchUtils;", "", "()V", "PATCHES_DIRECTORY", "", "myJsonObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "applySuitablePatches", "jsonSchemaContent", "specificationType", "Lcom/intellij/swagger/SpecificationType;", "findAllSuitablePatches", "Lkotlin/sequences/Sequence;", "Lcom/intellij/openapi/vfs/VirtualFile;", "mergeArrays", "", "targetArray", "Lcom/fasterxml/jackson/databind/node/ArrayNode;", "patchArray", "mergePatchIntoSchema", "", "schemaRootNode", "Lcom/fasterxml/jackson/databind/JsonNode;", "patchVirtualFile", "mergeTrees", "targetSchema", "patch", "readTree", "asPrettyString", "hasTextNode", "textNode", "Lcom/fasterxml/jackson/databind/node/TextNode;", "intellij.swagger"})
public final class SwJsonSchemaPatchUtils {
    private static final String PATCHES_DIRECTORY = "schema/patches";
    private static final ObjectMapper myJsonObjectMapper;
    @NotNull
    public static final SwJsonSchemaPatchUtils INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String applySuitablePatches(@NotNull String jsonSchemaContent, @NotNull SpecificationType specificationType) {
        String string;
        boolean allPatchesApplied;
        JsonNode schemaRootNode;
        block4: {
            boolean bl;
            void $this$all$iv;
            Intrinsics.checkNotNullParameter((Object)jsonSchemaContent, (String)"jsonSchemaContent");
            Intrinsics.checkNotNullParameter((Object)((Object)specificationType), (String)"specificationType");
            JsonNode jsonNode = this.readTree(jsonSchemaContent);
            if (jsonNode == null) {
                return jsonSchemaContent;
            }
            schemaRootNode = jsonNode;
            Sequence<VirtualFile> sequence = this.findAllSuitablePatches(specificationType);
            boolean $i$f$all = false;
            for (Object element$iv : $this$all$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl2 = false;
                if (INSTANCE.mergePatchIntoSchema(schemaRootNode, it)) continue;
                bl = false;
                break block4;
            }
            bl = allPatchesApplied = true;
        }
        if (allPatchesApplied) {
            string = this.asPrettyString(schemaRootNode);
        } else {
            Logger.getInstance(SwJsonSchemaPatchUtils.class).warn("Some patches were applied with errors, default schema for specification type " + (Object)((Object)specificationType) + " will be used");
            string = jsonSchemaContent;
        }
        return string;
    }

    @Nullable
    public final JsonNode readTree(@NotNull String jsonSchemaContent) {
        JsonNode jsonNode;
        Intrinsics.checkNotNullParameter((Object)jsonSchemaContent, (String)"jsonSchemaContent");
        try {
            jsonNode = myJsonObjectMapper.readTree(jsonSchemaContent);
        }
        catch (IOException exception) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(SwJsonSchemaPatchUtils.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.warn("Unable to read json schema from provided file", (Throwable)exception);
            jsonNode = null;
        }
        return jsonNode;
    }

    @NotNull
    public final JsonNode mergeTrees(@NotNull JsonNode targetSchema, @NotNull JsonNode patch) {
        block3: {
            JsonNode jsonNode;
            block2: {
                Intrinsics.checkNotNullParameter((Object)targetSchema, (String)"targetSchema");
                Intrinsics.checkNotNullParameter((Object)patch, (String)"patch");
                jsonNode = targetSchema;
                if (!(jsonNode instanceof ObjectNode)) break block2;
                Iterator iterator = patch.fields();
                Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"patch.fields()");
                Iterator iterator2 = iterator;
                boolean bl = false;
                Iterator iterator3 = iterator2;
                while (iterator3.hasNext()) {
                    Map.Entry node = (Map.Entry)iterator3.next();
                    if (targetSchema.has((String)node.getKey())) {
                        JsonNode jsonNode2 = targetSchema.get((String)node.getKey());
                        Intrinsics.checkNotNullExpressionValue((Object)jsonNode2, (String)"targetSchema.get(node.key)");
                        Object v = node.getValue();
                        Intrinsics.checkNotNullExpressionValue(v, (String)"node.value");
                        this.mergeTrees(jsonNode2, (JsonNode)v);
                        continue;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)((ObjectNode)targetSchema).set((String)node.getKey(), (JsonNode)node.getValue()), (String)"targetSchema.set(node.key, node.value)");
                }
                break block3;
            }
            if (!(jsonNode instanceof ArrayNode) || !(patch instanceof ArrayNode)) break block3;
            this.mergeArrays((ArrayNode)targetSchema, (ArrayNode)patch);
        }
        return targetSchema;
    }

    private final String asPrettyString(JsonNode $this$asPrettyString) {
        String string = myJsonObjectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)$this$asPrettyString);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"myJsonObjectMapper.write\u2026.writeValueAsString(this)");
        return string;
    }

    private final boolean mergePatchIntoSchema(JsonNode schemaRootNode, VirtualFile patchVirtualFile) {
        boolean bl;
        try {
            String patchContent = ((Object)LoadTextUtil.loadText((VirtualFile)patchVirtualFile)).toString();
            JsonNode jsonNode = this.readTree(patchContent);
            if (jsonNode == null) {
                return false;
            }
            JsonNode patchRootNode = jsonNode;
            this.mergeTrees(schemaRootNode, patchRootNode);
            bl = true;
        }
        catch (IOException ex) {
            Logger.getInstance(SwJsonSchemaPatchUtils.class).warn("Unable to apply patch " + patchVirtualFile.getName() + " to json schema", (Throwable)ex);
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final Sequence<VirtualFile> findAllSuitablePatches(@NotNull SpecificationType specificationType) {
        Intrinsics.checkNotNullParameter((Object)((Object)specificationType), (String)"specificationType");
        VirtualFile virtualFile2 = SwaggerUtilsKt.getBundledResource(PATCHES_DIRECTORY);
        Object[] $this$orEmpty$iv = virtualFile2 != null ? virtualFile2.getChildren() : null;
        boolean $i$f$orEmpty = false;
        Object[] objectArray = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            objectArray = new VirtualFile[]{};
        }
        return SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)((Function1)new Function1<VirtualFile, Boolean>(specificationType){
            final /* synthetic */ SpecificationType $specificationType;

            public final boolean invoke(VirtualFile it) {
                boolean bl;
                switch (SwJsonSchemaPatchUtils$WhenMappings.$EnumSwitchMapping$0[this.$specificationType.ordinal()]) {
                    case 1: {
                        VirtualFile virtualFile2 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"it");
                        String string = virtualFile2.getNameWithoutExtension();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.nameWithoutExtension");
                        bl = StringsKt.startsWith$default((String)string, (String)"2_0", (boolean)false, (int)2, null);
                        break;
                    }
                    case 2: {
                        VirtualFile virtualFile3 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"it");
                        String string = virtualFile3.getNameWithoutExtension();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.nameWithoutExtension");
                        bl = StringsKt.startsWith$default((String)string, (String)"3_0_0", (boolean)false, (int)2, null);
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
                return bl;
            }
            {
                this.$specificationType = specificationType;
                super(1);
            }
        }));
    }

    private final void mergeArrays(ArrayNode targetArray, ArrayNode patchArray) {
        Iterator iterator = patchArray.elements();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"patchArray.elements()");
        Iterator iterator2 = iterator;
        boolean bl = false;
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            JsonNode arrayItem = (JsonNode)iterator3.next();
            if (!(arrayItem instanceof TextNode) || this.hasTextNode(targetArray, (TextNode)arrayItem)) continue;
            targetArray.add(arrayItem);
        }
    }

    private final boolean hasTextNode(ArrayNode $this$hasTextNode, TextNode textNode) {
        boolean bl;
        block2: {
            Iterator iterator = $this$hasTextNode.elements();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"elements()");
            Sequence $this$filterIsInstance$iv = SequencesKt.asSequence((Iterator)iterator);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)hasTextNode$$inlined$filterIsInstance$1.INSTANCE);
            if (sequence == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
            }
            Sequence $this$any$iv = sequence;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                TextNode it = (TextNode)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.textValue(), (Object)textNode.textValue())) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    private SwJsonSchemaPatchUtils() {
    }

    static {
        SwJsonSchemaPatchUtils swJsonSchemaPatchUtils;
        INSTANCE = swJsonSchemaPatchUtils = new SwJsonSchemaPatchUtils();
        myJsonObjectMapper = new ObjectMapper(new JsonFactory());
    }
}

