/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.npm;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.swagger.FileCoordinates;
import com.intellij.swagger.SwDownloadManager;
import com.intellij.swagger.SwDownloadableFileType;
import com.intellij.swagger.npm.DistributiveInfo;
import com.intellij.swagger.npm.LibraryVersion;
import com.intellij.swagger.npm.NpmLibraryCoordinates;
import com.intellij.swagger.npm.Tag;
import com.intellij.util.io.Decompressor;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J!\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\fH\u0002\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u0004J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/swagger/npm/SwNpmDownloadManager;", "", "()V", "NPM_REGISTRY_URL", "", "collectArchiveUrl", "npmCoordinates", "Lcom/intellij/swagger/npm/NpmLibraryCoordinates;", "deleteTempFiles", "", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "([Lcom/intellij/openapi/vfs/VirtualFile;)V", "downloadLibrary", "libraryName", "downloadOrGetCachedLibrary", "getIfAlreadyExists", "getLibraryPath", "Ljava/nio/file/Path;", "intellij.swagger"})
public final class SwNpmDownloadManager {
    private static final String NPM_REGISTRY_URL = "https://registry.npmjs.org/%s";
    @NotNull
    public static final SwNpmDownloadManager INSTANCE;

    @Nullable
    public final VirtualFile downloadOrGetCachedLibrary(@NotNull String libraryName) {
        Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
        VirtualFile virtualFile2 = this.getIfAlreadyExists(libraryName);
        if (virtualFile2 == null) {
            virtualFile2 = this.downloadLibrary(libraryName);
        }
        return virtualFile2;
    }

    @NotNull
    public final Path getLibraryPath(@NotNull String libraryName) {
        Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
        Path path = SwDownloadManager.INSTANCE.getFullPath$intellij_swagger(SwDownloadableFileType.NPM_LIBRARY).resolve(libraryName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"SwDownloadManager.getFul\u2026    .resolve(libraryName)");
        return path;
    }

    private final VirtualFile getIfAlreadyExists(String libraryName) {
        Path path = this.getLibraryPath(libraryName);
        boolean bl = false;
        boolean bl2 = false;
        Path it = path;
        boolean bl3 = false;
        return PathKt.exists((Path)it) ? VfsUtil.findFileByIoFile((File)it.toFile(), (boolean)true) : null;
    }

    private final VirtualFile downloadLibrary(String libraryName) {
        Object libraryCoordinates;
        String string = NPM_REGISTRY_URL;
        Unit unit = new Object[]{libraryName};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(unit, ((Object[])unit).length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
        VirtualFile virtualFile2 = SwDownloadManager.INSTANCE.downloadFile(string2, SwDownloadableFileType.NPM_LIBRARY_DESCRIPTOR, ProgressManager.getGlobalProgressIndicator(), true);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile libraryDescriptor = virtualFile2;
        try {
            unit = new ObjectMapper(new JsonFactory()).readValue(libraryDescriptor.getInputStream(), NpmLibraryCoordinates.class);
        }
        catch (Exception ex) {
            Exception exception = ex;
            if (!(exception instanceof IOException || exception instanceof JsonParseException || exception instanceof JsonMappingException)) {
                throw (Throwable)ex;
            }
            Logger.getInstance(SwNpmDownloadManager.class).warn("Unable to read library metadata from NPM registry", (Throwable)ex);
            unit = Unit.INSTANCE;
        }
        Object object = libraryCoordinates = unit;
        if (!(libraryCoordinates instanceof NpmLibraryCoordinates)) {
            object = null;
        }
        String string3 = this.collectArchiveUrl((NpmLibraryCoordinates)object);
        if (string3 == null) {
            return null;
        }
        String archiveUrl = string3;
        FileCoordinates fileCoordinates = SwDownloadManager.INSTANCE.calculateLocalUrlFromRemote(archiveUrl, SwDownloadableFileType.NPM_LIBRARY, false);
        if (fileCoordinates == null) {
            return null;
        }
        FileCoordinates archiveCoordinates = fileCoordinates;
        VirtualFile virtualFile3 = SwDownloadManager.INSTANCE.downloadFile(archiveCoordinates, ProgressManager.getGlobalProgressIndicator(), false);
        if (virtualFile3 == null) {
            return null;
        }
        VirtualFile archive = virtualFile3;
        Path libraryFolder = this.getLibraryPath(libraryName);
        new Decompressor.Tar(archive.getInputStream()).extract(libraryFolder);
        this.deleteTempFiles(archive, libraryDescriptor);
        return VfsUtil.findFile((Path)libraryFolder, (boolean)true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String collectArchiveUrl(NpmLibraryCoordinates npmCoordinates) {
        NpmLibraryCoordinates npmLibraryCoordinates = npmCoordinates;
        Object object = npmLibraryCoordinates;
        if (npmLibraryCoordinates == null) return null;
        Map<String, LibraryVersion> map2 = ((NpmLibraryCoordinates)object).getVersions();
        object = map2;
        if (map2 == null) return null;
        Object object2 = object;
        Tag tag = npmCoordinates.getDistTags();
        String string = tag != null ? tag.getLatest() : null;
        boolean bl = false;
        LibraryVersion libraryVersion = (LibraryVersion)object2.get(string);
        object = libraryVersion;
        if (libraryVersion == null) return null;
        DistributiveInfo distributiveInfo = ((LibraryVersion)object).getDist();
        object = distributiveInfo;
        if (distributiveInfo == null) return null;
        String string2 = ((DistributiveInfo)object).getTarball();
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private final void deleteTempFiles(VirtualFile ... files) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        VirtualFile[] $this$map$iv = files;
        boolean $i$f$map = false;
        VirtualFile[] virtualFileArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var7_8 = $this$mapTo$iv$iv;
        int n = ((void)var7_8).length;
        for (int i = 0; i < n; ++i) {
            void p1;
            void item$iv$iv;
            void var11_14 = item$iv$iv = var7_8[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Path path = p1.toNioPath();
            collection.add(path);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            File file;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Path p1 = (Path)element$iv$iv;
            boolean bl2 = false;
            if (p1.toFile() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            File it$iv$iv = file;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            FileUtilRt.delete((File)it);
        }
    }

    private SwNpmDownloadManager() {
    }

    static {
        SwNpmDownloadManager swNpmDownloadManager;
        INSTANCE = swNpmDownloadManager = new SwNpmDownloadManager();
    }
}

