/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.intentions;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.swagger.SwaggerBundle;
import com.intellij.swagger.SwaggerUtilsKt;
import com.intellij.swagger.model.api.SwDefinition;
import com.intellij.swagger.model.api.SwModelElement;
import com.intellij.swagger.model.specification.Openapi3PathsProvider;
import com.intellij.swagger.model.specification.Swagger2PathsProvider;
import com.intellij.swagger.model.specification.openapi.v3.Openapi3Callback;
import com.intellij.swagger.model.specification.openapi.v3.Openapi3Definition;
import com.intellij.swagger.model.specification.openapi.v3.Openapi3Example;
import com.intellij.swagger.model.specification.openapi.v3.Openapi3Header;
import com.intellij.swagger.model.specification.openapi.v3.Openapi3RequestBody;
import com.intellij.swagger.model.specification.openapi.v3.Openapi3Response;
import com.intellij.swagger.refactoring.SwRefactoringUtilsKt;
import com.intellij.swagger.traverser.SpecificationTraverser;
import com.intellij.swagger.traverser.SpecificationTraverserFactory;
import com.intellij.swagger.traverser.SwTreeUtil;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0001.B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\"\u0010\u000f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0010\u001a\u00020\u0006H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J+\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0017\"\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u001a2\u0006\u0010\u001b\u001a\u00020\bH\u0002J\b\u0010\u001c\u001a\u00020\u0006H\u0016J\b\u0010\u001d\u001a\u00020\u0006H\u0016J\"\u0010\u001e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\bH\u0002J#\u0010#\u001a\u00020$2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\bH\u0096\u0002J\"\u0010(\u001a\u00020)2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\bH\u0016J\u0018\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020\b2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010,\u001a\u00020$2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\bH\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010!2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006/"}, d2={"Lcom/intellij/swagger/intentions/SwExtractModelDeclarationIntention;", "Lcom/intellij/codeInsight/intention/PsiElementBaseIntentionAction;", "()V", "createDeclarationNode", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "name", "", "childMapping", "Lcom/intellij/psi/PsiElement;", "createEol", "project", "Lcom/intellij/openapi/project/Project;", "createIndent", "size", "", "createNodeWithName", "value", "createValue", "Lorg/jetbrains/yaml/psi/YAMLValue;", "findOrCreateContainerNode", "swModelElement", "Lcom/intellij/swagger/model/api/SwModelElement;", "pathSegments", "", "(Lcom/intellij/swagger/model/api/SwModelElement;[Ljava/lang/String;)Lcom/intellij/psi/PsiElement;", "findSuitableModelElements", "Lkotlin/sequences/Sequence;", "psiElement", "getFamilyName", "getText", "introduceModelDeclaration", "modelElement", "suggestedModelData", "Lcom/intellij/swagger/intentions/SwExtractModelDeclarationIntention$SuggestedModelData;", "sourcePsi", "invoke", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "isAvailable", "", "renameIntroducedModel", "keyElement", "replaceInlinedDeclarationWithReference", "suggestModelPath", "SuggestedModelData", "intellij.swagger"})
public final class SwExtractModelDeclarationIntention
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getText() {
        return SwaggerBundle.message("intention.extract.model.declaration.name", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return SwaggerBundle.message("intention.extract.model.declaration.name", new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        SwModelElement swModelElement = (SwModelElement)SequencesKt.firstOrNull(this.findSuitableModelElements(element));
        PsiElement psiElement = swModelElement != null ? swModelElement.getSourcePsi() : null;
        boolean bl = false;
        boolean bl2 = false;
        PsiElement it = psiElement;
        boolean bl3 = false;
        if (!(it instanceof YAMLMapping)) return false;
        String string = ((YAMLMapping)it).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
        if (StringsKt.startsWith$default((String)string, (String)"$ref", (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        PsiElement psiElement;
        SwModelElement modelElement;
        block8: {
            block7: {
                void $this$parentOfType$iv;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (editor == null) {
                    return;
                }
                SwModelElement swModelElement = (SwModelElement)SequencesKt.firstOrNull(this.findSuitableModelElements(element));
                if (swModelElement == null) {
                    return;
                }
                modelElement = swModelElement;
                psiElement = modelElement.getSourcePsi();
                if (psiElement == null) break block7;
                PsiElement psiElement2 = psiElement;
                boolean withSelf$iv = true;
                boolean $i$f$parentOfType = false;
                psiElement = (YAMLMapping)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, YAMLMapping.class, (boolean)false);
                if (psiElement != null) break block8;
            }
            return;
        }
        PsiElement sourcePsi = psiElement;
        SuggestedModelData suggestedModelData = this.suggestModelPath(modelElement);
        if (suggestedModelData == null) {
            return;
        }
        SuggestedModelData suggestedModelData2 = suggestedModelData;
        PsiElement psiElement3 = this.introduceModelDeclaration(modelElement, suggestedModelData2, sourcePsi);
        if (psiElement3 == null) {
            return;
        }
        PsiElement actualDeclarationKey = psiElement3;
        this.replaceInlinedDeclarationWithReference(suggestedModelData2, sourcePsi);
        this.renameIntroducedModel(actualDeclarationKey, editor);
    }

    private final PsiElement introduceModelDeclaration(SwModelElement modelElement, SuggestedModelData suggestedModelData, PsiElement sourcePsi) {
        Object object;
        String[] stringArray = suggestedModelData.getPath();
        PsiElement psiElement = this.findOrCreateContainerNode(modelElement, Arrays.copyOf(stringArray, stringArray.length));
        if (psiElement != null) {
            PsiElement psiElement2 = psiElement;
            boolean bl = false;
            boolean bl2 = false;
            PsiElement $this$run = psiElement2;
            boolean bl3 = false;
            Project project = $this$run.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            $this$run.add(this.createEol(project));
            PsiElement $this$castSafelyTo$iv = $this$run.add((PsiElement)this.createDeclarationNode(suggestedModelData.getName(), sourcePsi));
            boolean $i$f$castSafelyTo = false;
            PsiElement psiElement3 = $this$castSafelyTo$iv;
            if (!(psiElement3 instanceof YAMLKeyValue)) {
                psiElement3 = null;
            }
            YAMLKeyValue yAMLKeyValue = (YAMLKeyValue)psiElement3;
            object = yAMLKeyValue != null ? yAMLKeyValue.getKey() : null;
        } else {
            object = null;
        }
        return object;
    }

    private final void replaceInlinedDeclarationWithReference(SuggestedModelData suggestedModelData, PsiElement sourcePsi) {
        String string = null;
        CharSequence charSequence = null;
        int n = 0;
        CharSequence charSequence2 = null;
        CharSequence charSequence3 = "/";
        CharSequence charSequence4 = "#/";
        string = ArraysKt.joinToString$default((Object[])ArraysKt.plus((Object[])suggestedModelData.getPath(), (Object)suggestedModelData.getName()), (CharSequence)charSequence3, (CharSequence)charSequence4, charSequence2, (int)n, charSequence, string, (int)60, null);
        boolean bl = false;
        n = 0;
        String it = string;
        boolean bl2 = false;
        String referenceText = "$ref: '" + it + '\'';
        Project project = sourcePsi.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"sourcePsi.project");
        sourcePsi.replace((PsiElement)this.createValue(project, referenceText));
    }

    private final SuggestedModelData suggestModelPath(SwModelElement swModelElement) {
        SwModelElement swModelElement2 = swModelElement;
        return swModelElement2 instanceof Openapi3RequestBody ? new SuggestedModelData("RequestBody", new String[]{Openapi3PathsProvider.INSTANCE.getCOMPONENTS(), Openapi3PathsProvider.INSTANCE.getREQUEST_BODIES()}) : (swModelElement2 instanceof Openapi3Response ? new SuggestedModelData("Response", new String[]{Openapi3PathsProvider.INSTANCE.getCOMPONENTS(), Openapi3PathsProvider.INSTANCE.getRESPONSES()}) : (swModelElement2 instanceof Openapi3Definition ? new SuggestedModelData("Schema", new String[]{Openapi3PathsProvider.INSTANCE.getCOMPONENTS(), Openapi3PathsProvider.INSTANCE.getOBJECT_DEFINITIONS()}) : (swModelElement2 instanceof Openapi3Callback ? new SuggestedModelData("Callback", new String[]{Openapi3PathsProvider.INSTANCE.getCOMPONENTS(), Openapi3PathsProvider.INSTANCE.getCALLBACKS()}) : (swModelElement2 instanceof Openapi3Header ? new SuggestedModelData("Header", new String[]{Openapi3PathsProvider.INSTANCE.getCOMPONENTS(), Openapi3PathsProvider.INSTANCE.getHEADERS()}) : (swModelElement2 instanceof Openapi3Example ? new SuggestedModelData("Example", new String[]{Openapi3PathsProvider.INSTANCE.getCOMPONENTS(), Openapi3PathsProvider.INSTANCE.getEXAMPLES()}) : (swModelElement2 instanceof SwDefinition ? new SuggestedModelData("Definition", new String[]{Swagger2PathsProvider.INSTANCE.getOBJECT_DEFINITIONS()}) : null))))));
    }

    /*
     * WARNING - void declaration
     */
    private final PsiElement findOrCreateContainerNode(SwModelElement swModelElement, String ... pathSegments) {
        void $this$foldIndexed$iv;
        PsiElement psiElement = swModelElement.getSourcePsi();
        if (psiElement == null || (psiElement = psiElement.getContainingFile()) == null) {
            return null;
        }
        PsiElement containingFile = psiElement;
        FileType fileType = containingFile.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"containingFile.fileType");
        SpecificationTraverser specificationTraverser = SpecificationTraverserFactory.INSTANCE.getTraverserFor(fileType);
        if (specificationTraverser == null) {
            return null;
        }
        SpecificationTraverser traverser = specificationTraverser;
        Project project = containingFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"containingFile.project");
        Project project2 = project;
        String[] stringArray = pathSegments;
        PsiElement psiElement2 = containingFile;
        if (psiElement2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiElement");
        }
        PsiElement initial$iv = psiElement2;
        boolean $i$f$foldIndexed = false;
        int index$iv = 0;
        PsiElement accumulator$iv = initial$iv;
        for (void element$iv : $this$foldIndexed$iv) {
            void pathSegment;
            void currentNode;
            int n = index$iv++;
            void var15_15 = element$iv;
            PsiElement psiElement3 = accumulator$iv;
            int depth = n;
            boolean bl = false;
            PsiElement psiElement4 = traverser.findByPath((PsiElement)currentNode, new String[]{pathSegment});
            if (psiElement4 == null) {
                SwExtractModelDeclarationIntention swExtractModelDeclarationIntention = this;
                boolean bl2 = false;
                boolean bl3 = false;
                SwExtractModelDeclarationIntention $this$run = swExtractModelDeclarationIntention;
                boolean bl4 = false;
                void $this$castSafelyTo$iv = currentNode;
                boolean $i$f$castSafelyTo = false;
                Object v7 = $this$castSafelyTo$iv;
                if (!(v7 instanceof PsiFile)) {
                    v7 = null;
                }
                PsiFile psiFile2 = v7;
                SpecificationTraverser specificationTraverser2 = traverser;
                boolean bl5 = false;
                boolean bl6 = false;
                PsiFile p1 = psiFile2;
                boolean bl7 = false;
                psiFile2 = SwaggerUtilsKt.or(specificationTraverser2.getTopLevelValueOf(p1), currentNode);
                boolean bl8 = false;
                bl5 = false;
                PsiElement $this$run2 = (PsiElement)psiFile2;
                boolean bl9 = false;
                $this$run2.add($this$run.createEol(project2));
                $this$run2.add($this$run.createIndent(project2, depth));
                PsiElement psiElement5 = $this$run2.add((PsiElement)SwExtractModelDeclarationIntention.createNodeWithName$default($this$run, project2, (String)pathSegment, null, 4, null));
                psiElement4 = psiElement5;
                Intrinsics.checkNotNullExpressionValue((Object)psiElement5, (String)"run {\n        currentNod\u2026gment))\n        }\n      }");
            }
            accumulator$iv = psiElement4;
        }
        return accumulator$iv;
    }

    private final Sequence<SwModelElement> findSuitableModelElements(PsiElement psiElement) {
        return SwTreeUtil.INSTANCE.getParentsOfTypes(psiElement, SwDefinition.class, Openapi3Definition.class, Openapi3Callback.class, Openapi3RequestBody.class, Openapi3Header.class, Openapi3Example.class);
    }

    private final void renameIntroducedModel(PsiElement keyElement, Editor editor) {
        PsiElement psiElement;
        PsiElement psiElement2 = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)keyElement);
        if (psiElement2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"CodeInsightUtilCore.forc\u2026ent(keyElement) ?: return");
        PsiElement $this$parentOfType$iv = psiElement = psiElement2;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        PsiElement psiElement3 = PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, YAMLKeyValue.class, (boolean)true);
        Intrinsics.checkNotNull((Object)psiElement3);
        YAMLKeyValue reformattedKey = (YAMLKeyValue)psiElement3;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            return;
        }
        ModalityState modalityState$iv = null;
        boolean $i$f$invokeLater = false;
        Application application2 = ApplicationManager.getApplication();
        Runnable runnable = new Runnable(reformattedKey, editor){
            final /* synthetic */ YAMLKeyValue $reformattedKey$inlined;
            final /* synthetic */ Editor $editor$inlined;
            {
                this.$reformattedKey$inlined = yAMLKeyValue;
                this.$editor$inlined = editor;
            }

            public final void run() {
                boolean bl = false;
                new RenameDialog(this.$reformattedKey$inlined.getProject(), (PsiElement)this.$reformattedKey$inlined, null, this.$editor$inlined).show();
            }
        };
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
        application2.invokeLater(runnable, modalityState);
    }

    private final YAMLKeyValue createDeclarationNode(String name2, PsiElement childMapping) {
        Project project = childMapping.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"childMapping.project");
        return this.createNodeWithName(project, name2, SwRefactoringUtilsKt.getIndent(childMapping) + childMapping.getText());
    }

    private final YAMLValue createValue(Project project, String value) {
        YAMLValue yAMLValue = this.createNodeWithName(project, "nobodyShouldSeeIt", value).getValue();
        Intrinsics.checkNotNull((Object)yAMLValue);
        return yAMLValue;
    }

    private final YAMLKeyValue createNodeWithName(Project project, String name2, String value) {
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(YAMLElementGenerator.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        YAMLKeyValue yAMLKeyValue = ((YAMLElementGenerator)object).createYamlKeyValue(name2, value);
        Intrinsics.checkNotNullExpressionValue((Object)yAMLKeyValue, (String)"project.service<YAMLElem\u2026YamlKeyValue(name, value)");
        return yAMLKeyValue;
    }

    static /* synthetic */ YAMLKeyValue createNodeWithName$default(SwExtractModelDeclarationIntention swExtractModelDeclarationIntention, Project project, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        return swExtractModelDeclarationIntention.createNodeWithName(project, string, string2);
    }

    private final PsiElement createEol(Project project) {
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(YAMLElementGenerator.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        PsiElement psiElement = ((YAMLElementGenerator)object).createEol();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"project.service<YAMLElem\u2026tGenerator>().createEol()");
        return psiElement;
    }

    private final PsiElement createIndent(Project project, int size) {
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(YAMLElementGenerator.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        PsiElement psiElement = ((YAMLElementGenerator)object).createIndent(size);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"project.service<YAMLElem\u2026tor>().createIndent(size)");
        return psiElement;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\"\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0011\u0010\u0004\u001a\r\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\u0004\u001a\r\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lcom/intellij/swagger/intentions/SwExtractModelDeclarationIntention$SuggestedModelData;", "", "name", "", "path", "", "Lcom/intellij/openapi/util/NlsSafe;", "(Ljava/lang/String;[Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getPath", "()[Ljava/lang/String;", "[Ljava/lang/String;", "intellij.swagger"})
    private static final class SuggestedModelData {
        @NotNull
        private final String name;
        @NotNull
        private final String[] path;

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String[] getPath() {
            return this.path;
        }

        public SuggestedModelData(@NlsSafe @NotNull String name2, @NotNull String[] path) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.name = name2;
            this.path = path;
        }
    }
}

