/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.index;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.swagger.model.specification.SwSpecificationFile;
import com.intellij.swagger.model.specification.SwaggerFileHelper;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a*\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000f\"\u0004\b\u0000\u0010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0014H\u0000\u001a\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0000\u001a8\u0010\u0018\u001a\u00020\u0016\"\u0004\b\u0000\u0010\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000f2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u00020\u00160\u001dH\u0000\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"INDEXED_VIRTUAL_FILE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getSpecificationFileFor", "Lcom/intellij/swagger/model/specification/SwSpecificationFile;", "fileContent", "Lcom/intellij/util/indexing/FileContent;", "getVirtualFileFromUserData", "psiFile", "Lcom/intellij/psi/PsiFile;", "isIndexingRightNow", "", "project", "Lcom/intellij/openapi/project/Project;", "readListOfObjects", "", "T", "dataInput", "Ljava/io/DataInput;", "objectReader", "Lkotlin/Function0;", "storeVirtualFileInUserData", "", "virtualFile", "writeListOfObjects", "dataOutput", "Ljava/io/DataOutput;", "objects", "objectWriter", "Lkotlin/Function1;", "intellij.swagger"})
public final class SwIndexUtilsKt {
    private static final Key<VirtualFile> INDEXED_VIRTUAL_FILE_KEY;

    public static final <T> void writeListOfObjects(@NotNull DataOutput dataOutput, @NotNull List<? extends T> objects, @NotNull Function1<? super T, Unit> objectWriter) {
        Intrinsics.checkNotNullParameter((Object)dataOutput, (String)"dataOutput");
        Intrinsics.checkNotNullParameter(objects, (String)"objects");
        Intrinsics.checkNotNullParameter(objectWriter, (String)"objectWriter");
        DataInputOutputUtil.writeINT((DataOutput)dataOutput, (int)objects.size());
        for (T singleObject : objects) {
            objectWriter.invoke(singleObject);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> List<T> readListOfObjects(@NotNull DataInput dataInput, @NotNull Function0<? extends T> objectReader) {
        Intrinsics.checkNotNullParameter((Object)dataInput, (String)"dataInput");
        Intrinsics.checkNotNullParameter(objectReader, (String)"objectReader");
        int size = DataInputOutputUtil.readINT((DataInput)dataInput);
        ArrayList<Object> objects = new ArrayList<Object>(size);
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i;
            objects.add(objectReader.invoke());
            ++i;
        }
        return objects;
    }

    @Nullable
    public static final SwSpecificationFile getSpecificationFileFor(@NotNull FileContent fileContent) {
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        PsiFile psiFile2 = fileContent.getPsiFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"fileContent.psiFile");
        VirtualFile virtualFile2 = fileContent.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"fileContent.file");
        Project project = fileContent.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"fileContent.project");
        return SwaggerFileHelper.createSpecificationFile$default(SwaggerFileHelper.INSTANCE, psiFile2, virtualFile2, project, false, false, 16, null);
    }

    public static final void storeVirtualFileInUserData(@NotNull PsiFile psiFile2, @Nullable VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
        psiFile2.putUserData(INDEXED_VIRTUAL_FILE_KEY, (Object)virtualFile2);
    }

    @Nullable
    public static final VirtualFile getVirtualFileFromUserData(@NotNull PsiFile psiFile2) {
        Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
        return (VirtualFile)psiFile2.getUserData(INDEXED_VIRTUAL_FILE_KEY);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isIndexingRightNow(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        boolean $i$f$runReadAction = false;
        if ((Boolean)ApplicationManager.getApplication().runReadAction(new Computable(project){
            final /* synthetic */ Project $project$inlined;
            {
                this.$project$inlined = project;
            }

            public final T compute() {
                boolean bl = false;
                return (T)Boolean.valueOf(DumbService.isDumb((Project)this.$project$inlined));
            }
        }) != false) return true;
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileBasedIndex, (String)"FileBasedIndex.getInstance()");
        if (fileBasedIndex.getFileBeingCurrentlyIndexed() == null) return false;
        return true;
    }

    static {
        Key key = Key.create((String)"swIndexedVirtualFile");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create(\"swIndexedVirtualFile\")");
        INDEXED_VIRTUAL_FILE_KEY = key;
    }
}

