/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.hub;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.swagger.SpecificationType;
import com.intellij.swagger.SwConnectionTuner;
import com.intellij.swagger.SwaggerUtilsKt;
import com.intellij.swagger.hub.ApisJson;
import com.intellij.swagger.hub.HubRequest;
import com.intellij.swagger.hub.HubSpecification;
import com.intellij.swagger.hub.HubSpecificationModel;
import com.intellij.swagger.hub.Property;
import com.intellij.swagger.settings.SwaggerSettings;
import com.intellij.swagger.settings.SwaggerSettingsState;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00042\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u0012\u0010\u001f\u001a\u00020\u00042\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150!2\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\"\u001a\u0004\u0018\u00010\u0004J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u0012\u001a\u00020%H\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/swagger/hub/SwaggerHubManager;", "", "()V", "DEFAULT_SWAGGER_HUB_HOST", "", "GENERIC_HUB_SPECIFICATION_URL_PATTERN", "Lkotlin/text/Regex;", "OWNER_GROUP_INDEX", "", "PASSWORD_SAFE_ATTRIBUTES", "Lcom/intellij/credentialStore/CredentialAttributes;", "getPASSWORD_SAFE_ATTRIBUTES$intellij_swagger", "()Lcom/intellij/credentialStore/CredentialAttributes;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "assembleSpecificationUrl", "partialUrl", "buildUrl", "request", "Lcom/intellij/swagger/hub/HubRequest;", "collectApisInformation", "Lcom/intellij/swagger/hub/HubSpecificationModel;", "specification", "Lcom/intellij/swagger/hub/HubSpecification;", "getOwnerFromUrl", "url", "isSwaggerHubUrl", "", "host", "project", "Lcom/intellij/openapi/project/Project;", "retrieveHubHost", "retrieveSpecifications", "", "retrieveToken", "tryParseResponse", "Lcom/intellij/swagger/hub/ApisJson;", "Lcom/intellij/util/io/HttpRequests$Request;", "intellij.swagger"})
public final class SwaggerHubManager {
    @NlsSafe
    @NotNull
    public static final String DEFAULT_SWAGGER_HUB_HOST = "api.swaggerhub.com";
    private static final Regex GENERIC_HUB_SPECIFICATION_URL_PATTERN;
    private static final int OWNER_GROUP_INDEX = 1;
    @NotNull
    private static final CredentialAttributes PASSWORD_SAFE_ATTRIBUTES;
    private static final ObjectMapper mapper;
    @NotNull
    public static final SwaggerHubManager INSTANCE;

    @NotNull
    public final CredentialAttributes getPASSWORD_SAFE_ATTRIBUTES$intellij_swagger() {
        return PASSWORD_SAFE_ATTRIBUTES;
    }

    @Nullable
    public final String retrieveToken() {
        return PasswordSafe.Companion.getInstance().getPassword(PASSWORD_SAFE_ATTRIBUTES);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String retrieveHubHost(Project project) {
        String string;
        Object object = project;
        if (object != null) {
            Project project2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Project it = project2;
            boolean bl3 = false;
            object = SwaggerSettings.Companion.getInstance(it);
            if (object != null && (object = (SwaggerSettingsState)object.getState()) != null) {
                string = object.getLocalHubAddress();
                return SwaggerUtilsKt.or(string, DEFAULT_SWAGGER_HUB_HOST);
            }
        }
        string = null;
        return SwaggerUtilsKt.or(string, DEFAULT_SWAGGER_HUB_HOST);
    }

    public final boolean isSwaggerHubUrl(@NotNull String host, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return Intrinsics.areEqual((Object)host, (Object)this.retrieveHubHost(project));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<HubSpecificationModel> retrieveSpecifications(@NotNull HubRequest request) {
        List list;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Function1 function1 = (Function1)new Function1<HttpRequests.Request, ApisJson>(this){

            @Nullable
            public final ApisJson invoke(@NotNull HttpRequests.Request p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return SwaggerHubManager.access$tryParseResponse((SwaggerHubManager)this.receiver, p1);
            }
        };
        Object object = (ApisJson)HttpRequests.request((String)this.buildUrl(request)).forceHttps(true).tuner(new HttpRequests.ConnectionTuner(request){
            final /* synthetic */ HubRequest $request;

            public final void tune(@NotNull URLConnection it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                SwConnectionTuner.INSTANCE.tuneConnection(it, this.$request.getProject());
            }
            {
                this.$request = hubRequest;
            }
        }).connect(new HttpRequests.RequestProcessor(function1){
            private final /* synthetic */ Function1 function;
            {
                this.function = function1;
            }

            public final /* synthetic */ Object process(@NotNull HttpRequests.Request p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return this.function.invoke((Object)p0);
            }
        });
        if (object != null && (object = ((ApisJson)object).getApis()) != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = (Iterable)object;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                HubSpecificationModel hubSpecificationModel;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                HubSpecification it = (HubSpecification)element$iv$iv;
                boolean bl2 = false;
                if (INSTANCE.collectApisInformation(it, request) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                HubSpecificationModel it$iv$iv = hubSpecificationModel;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        function1 = list;
        boolean bl = false;
        Object object2 = function1;
        if (object2 == null) {
            object2 = CollectionsKt.emptyList();
        }
        return object2;
    }

    @NotNull
    public final String assembleSpecificationUrl(@NotNull String partialUrl) {
        Intrinsics.checkNotNullParameter((Object)partialUrl, (String)"partialUrl");
        if (StringsKt.endsWith$default((String)partialUrl, (String)".yaml", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)partialUrl, (String)".json", (boolean)false, (int)2, null)) {
            return partialUrl;
        }
        Object object = SwaggerUtilsKt.buildUrlFrom(partialUrl);
        if (object == null || (object = SwaggerUtilsKt.addPathSegment(object, "swagger.yaml")) == null || (object = object.toString()) == null) {
            object = partialUrl;
        }
        return object;
    }

    private final ApisJson tryParseResponse(HttpRequests.Request request) {
        ApisJson apisJson;
        try {
            apisJson = (ApisJson)mapper.readValue(request.getInputStream(), ApisJson.class);
        }
        catch (JsonProcessingException ex) {
            Logger.getInstance(SwaggerHubManager.class).warn("Unable to map swagger hub response into jackson wrapper", (Throwable)ex);
            apisJson = null;
        }
        catch (IOException ex) {
            Logger.getInstance(SwaggerHubManager.class).warn("Unable to read specifications from swagger hub into apis.json format", (Throwable)ex);
            apisJson = null;
        }
        return apisJson;
    }

    /*
     * WARNING - void declaration
     */
    private final HubSpecificationModel collectApisInformation(HubSpecification specification, HubRequest request) {
        boolean bl;
        Object object;
        boolean isPrivate;
        boolean bl2;
        Object object2;
        String description2;
        String $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Iterable iterable = specification.getProperties();
        boolean bl3 = false;
        List list = iterable;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        iterable = list;
        boolean $i$f$mapNotNull = false;
        void var6_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv22 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach22 = false;
        Iterator iterator = $this$forEach$iv$iv$iv2.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl4 = false;
            Property it = (Property)element$iv$iv;
            boolean bl5 = false;
            if ((it.getType() != null ? TuplesKt.to((Object)it.getType(), (Object)it) : null) == null) continue;
            pair = pair;
            boolean bl6 = false;
            boolean bl7 = false;
            Pair it$iv$iv = pair;
            boolean bl8 = false;
            destination$iv$iv22.add(it$iv$iv);
        }
        Map properties = MapsKt.toMap((Iterable)((List)destination$iv$iv22));
        String string = specification.getName();
        if (string == null) {
            return null;
        }
        String name2 = string;
        $this$mapNotNullTo$iv$iv = specification.getDescription();
        boolean destination$iv$iv22 = false;
        String string2 = $this$mapNotNullTo$iv$iv;
        if (string2 == null) {
            string2 = description2 = "";
        }
        if ((object2 = (Property)properties.get("Swagger")) == null || (object2 = ((Property)object2).getUrl()) == null) {
            return null;
        }
        Object url2 = object2;
        Object object3 = (Property)properties.get("X-Private");
        if (object3 != null && (object3 = ((Property)object3).getValue()) != null) {
            Object $i$f$mapNotNullTo2 = object3;
            boolean $this$forEach$iv$iv$iv2 = false;
            bl2 = Boolean.parseBoolean((String)$i$f$mapNotNullTo2);
        } else {
            bl2 = isPrivate = false;
        }
        if ((object = (Property)properties.get("X-Published")) != null && (object = ((Property)object).getValue()) != null) {
            Object $this$forEach$iv$iv$iv2 = object;
            $i$f$forEach22 = false;
            bl = Boolean.parseBoolean((String)$this$forEach$iv$iv$iv2);
        } else {
            bl = false;
        }
        boolean isPublished = bl;
        String $i$f$forEach22 = request.getOwner();
        boolean bl9 = false;
        boolean bl10 = false;
        String it = $i$f$forEach22;
        boolean bl11 = false;
        CharSequence charSequence = it;
        boolean bl12 = false;
        boolean bl13 = false;
        String string3 = !(charSequence == null || charSequence.length() == 0) ? $i$f$forEach22 : null;
        if (string3 == null) {
            string3 = this.getOwnerFromUrl((String)url2);
        }
        String owner = string3;
        Property property = (Property)properties.get("X-OASVersion");
        String string4 = property != null ? property.getValue() : null;
        bl10 = false;
        String string5 = string4;
        if (string5 == null) {
            string5 = "";
        }
        String versionString = string5;
        SpecificationType specificationType = StringsKt.startsWith$default((String)versionString, (String)"2", (boolean)false, (int)2, null) ? SpecificationType.SWAGGER_2 : (StringsKt.startsWith$default((String)versionString, (String)"3", (boolean)false, (int)2, null) ? SpecificationType.OPENAPI_3 : null);
        return new HubSpecificationModel(name2, description2, (String)url2, isPrivate, isPublished, owner, specificationType);
    }

    private final String buildUrl(HubRequest request) {
        String hubHost = this.retrieveHubHost(request.getProject());
        URIBuilder uRIBuilder = SwaggerUtilsKt.buildUrlFrom(hubHost);
        if (uRIBuilder == null) {
            URIBuilder uRIBuilder2 = new URIBuilder();
            boolean bl = false;
            boolean bl2 = false;
            URIBuilder $this$apply = uRIBuilder2;
            boolean bl3 = false;
            $this$apply.setScheme("https");
            $this$apply.setHost(StringsKt.removeSuffix((String)StringsKt.removePrefix((String)hubHost, (CharSequence)"/"), (CharSequence)"/"));
            uRIBuilder = uRIBuilder2;
        }
        URIBuilder localOrDefaultHubAddress = uRIBuilder;
        String string = SwaggerUtilsKt.addQueryParameter(SwaggerUtilsKt.addQueryParameter(SwaggerUtilsKt.addQueryParameter(SwaggerUtilsKt.addQueryParameter(SwaggerUtilsKt.addQueryParameter(SwaggerUtilsKt.addQueryParameter(SwaggerUtilsKt.addQueryParameter(SwaggerUtilsKt.addParameterIfNotNull(SwaggerUtilsKt.addQueryParameter(SwaggerUtilsKt.addPathSegment(localOrDefaultHubAddress, "specs"), "query", request.getSearchedValue()), "owner", request.getOwner()), "state", request.getStateType().getState()), "visibility", request.getVisibilityType().getVisibility()), "specType", "API"), "order", request.getSortingAndOrdering().getOrder()), "sort", request.getSortingAndOrdering().getSort()), "limit", String.valueOf(request.getLimit())), "page", String.valueOf(request.getPage())).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"localOrDefaultHubAddress\u2026ring())\n      .toString()");
        return string;
    }

    private final String getOwnerFromUrl(String url2) {
        Object object = GENERIC_HUB_SPECIFICATION_URL_PATTERN.matchEntire((CharSequence)url2);
        return object != null && (object = object.getGroupValues()) != null ? (String)object.get(1) : null;
    }

    private SwaggerHubManager() {
    }

    static {
        SwaggerHubManager swaggerHubManager;
        INSTANCE = swaggerHubManager = new SwaggerHubManager();
        String string = "https?://.*/apis/([^/&]+)/.*";
        boolean bl = false;
        GENERIC_HUB_SPECIFICATION_URL_PATTERN = new Regex(string);
        PASSWORD_SAFE_ATTRIBUTES = new CredentialAttributes(CredentialAttributesKt.generateServiceName((String)"OpenAPI Specifications", (String)DEFAULT_SWAGGER_HUB_HOST), null, null, false, 14, null);
        mapper = new ObjectMapper();
    }

    public static final /* synthetic */ ApisJson access$tryParseResponse(SwaggerHubManager $this, HttpRequests.Request request) {
        return $this.tryParseResponse(request);
    }
}

