/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.diff;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.swagger.diff.SwDiffResult;
import com.intellij.swagger.diff.model.SwModifiedElement;
import com.intellij.swagger.diff.model.SwModifiedSpecification;
import com.intellij.swagger.model.specification.SwSpecificationFile;
import com.intellij.swagger.model.specification.SwaggerFileHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0093\u0001\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0003*\u00020\u0004\"\b\b\u0001\u0010\u0002*\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00062\u0017\u0010\b\u001a\u0013\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\t\u00a2\u0006\u0002\b\n2:\u0010\u000b\u001a6\u0012\u0013\u0012\u0011H\u0002\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u0011H\u0002\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\fH\u0000\u001a\u0086\u0001\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0003*\u00020\u0004\"\b\b\u0001\u0010\u0002*\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00020\u00122\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00020\u00122:\u0010\u000b\u001a6\u0012\u0013\u0012\u0011H\u0002\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u0011H\u0002\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\fH\u0002\u001a\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0005\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u0015H\u0000\u001aC\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00020\u0012\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00062\u0017\u0010\b\u001a\u0013\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\t\u00a2\u0006\u0002\b\nH\u0002\u00a8\u0006\u0017"}, d2={"calculateDiffBetween", "Lcom/intellij/swagger/diff/SwDiffResult;", "Element", "Identifier", "", "original", "", "modified", "identifyingFunction", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "wrappingFunction", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "elementBefore", "elementAfter", "Lcom/intellij/swagger/diff/model/SwModifiedElement;", "", "computeSwaggerDiff", "Lcom/intellij/swagger/diff/model/SwModifiedSpecification;", "Lcom/intellij/psi/PsiFile;", "mapIdentifierToSelf", "intellij.swagger"})
public final class SwDiffUtilsKt {
    @Nullable
    public static final SwModifiedSpecification computeSwaggerDiff(@NotNull PsiFile original, @NotNull PsiFile modified) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)modified, (String)"modified");
        VirtualFile virtualFile2 = original.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"original.virtualFile");
        Project project = original.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"original.project");
        SwSpecificationFile swSpecificationFile = SwaggerFileHelper.createSpecificationFile$default(SwaggerFileHelper.INSTANCE, original, virtualFile2, project, false, false, 16, null);
        if (swSpecificationFile == null) {
            return null;
        }
        SwSpecificationFile originalSpecification = swSpecificationFile;
        VirtualFile virtualFile3 = modified.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"modified.virtualFile");
        Project project2 = modified.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"modified.project");
        SwSpecificationFile swSpecificationFile2 = SwaggerFileHelper.createSpecificationFile$default(SwaggerFileHelper.INSTANCE, modified, virtualFile3, project2, false, false, 16, null);
        if (swSpecificationFile2 == null) {
            return null;
        }
        SwSpecificationFile modifiedSpecification = swSpecificationFile2;
        SwModifiedSpecification swModifiedSpecification = new SwModifiedSpecification(originalSpecification, modifiedSpecification);
        boolean bl = false;
        boolean bl2 = false;
        SwModifiedSpecification it = swModifiedSpecification;
        boolean bl3 = false;
        it.getModificationType();
        return swModifiedSpecification;
    }

    @NotNull
    public static final <Identifier, Element> SwDiffResult<Element> calculateDiffBetween(@NotNull Collection<? extends Element> original, @NotNull Collection<? extends Element> modified, @NotNull Function1<? super Element, ? extends Identifier> identifyingFunction, @NotNull Function2<? super Element, ? super Element, ? extends SwModifiedElement<?>> wrappingFunction) {
        Intrinsics.checkNotNullParameter(original, (String)"original");
        Intrinsics.checkNotNullParameter(modified, (String)"modified");
        Intrinsics.checkNotNullParameter(identifyingFunction, (String)"identifyingFunction");
        Intrinsics.checkNotNullParameter(wrappingFunction, (String)"wrappingFunction");
        return SwDiffUtilsKt.calculateDiffBetween(SwDiffUtilsKt.mapIdentifierToSelf(original, identifyingFunction), SwDiffUtilsKt.mapIdentifierToSelf(modified, identifyingFunction), wrappingFunction);
    }

    /*
     * WARNING - void declaration
     */
    private static final <Identifier, Element> SwDiffResult<Element> calculateDiffBetween(Map<Identifier, ? extends Element> original, Map<Identifier, ? extends Element> modified, Function2<? super Element, ? super Element, ? extends SwModifiedElement<?>> wrappingFunction) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        boolean bl;
        boolean bl2;
        Element itemAfter;
        Object element$iv$iv$iv2;
        void $this$mapNotNullTo$iv$iv3;
        void preservedIdentifiersAfter;
        void preservedIdentifiersBefore;
        Object it;
        Iterable $this$partition$iv = original.keySet();
        boolean $i$f$partition322 = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            it = element$iv;
            boolean bl3 = false;
            if (modified.get(it) != null) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Object object = new Pair(first$iv, second$iv);
        List list = (List)object.component1();
        List removedIdentifiers = (List)object.component2();
        Iterable $this$partition$iv22 = modified.keySet();
        boolean $i$f$partition = false;
        Iterable first$iv2 = new ArrayList();
        ArrayList second$iv2 = new ArrayList();
        it = $this$partition$iv22.iterator();
        while (it.hasNext()) {
            Object element$iv;
            Object it2 = element$iv = it.next();
            boolean bl4 = false;
            if (original.get(it2) != null) {
                first$iv2.add(element$iv);
                continue;
            }
            second$iv2.add(element$iv);
        }
        Pair $i$f$partition322 = new Pair(first$iv2, second$iv2);
        object = (List)$i$f$partition322.component1();
        List createdIdentifiers = (List)$i$f$partition322.component2();
        boolean $i$f$partition322 = preservedIdentifiersBefore.size() == preservedIdentifiersAfter.size();
        boolean $this$partition$iv22 = false;
        if (_Assertions.ENABLED && !$i$f$partition322) {
            boolean $i$a$-assert-SwDiffUtilsKt$calculateDiffBetween$42 = false;
            String $i$a$-assert-SwDiffUtilsKt$calculateDiffBetween$42 = "Different number of preserved items found: " + preservedIdentifiersBefore.size() + " from original and " + preservedIdentifiersAfter.size() + " from modified";
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-SwDiffUtilsKt$calculateDiffBetween$42));
        }
        Iterable $this$mapNotNull$iv = (Iterable)preservedIdentifiersBefore;
        boolean $i$f$mapNotNull = false;
        first$iv2 = $this$mapNotNull$iv;
        Iterable<SwModifiedElement> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv3;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv2 : $this$forEach$iv$iv$iv) {
            SwModifiedElement swModifiedElement;
            Element itemBefore;
            Object element$iv$iv = element$iv$iv$iv2;
            boolean bl5 = false;
            Object it3 = element$iv$iv;
            boolean bl6 = false;
            if ((original.get(it3) == null ? null : (modified.get(it3) == null ? null : (SwModifiedElement)wrappingFunction.invoke(itemBefore, itemAfter))) == null) continue;
            swModifiedElement = swModifiedElement;
            bl2 = false;
            boolean bl7 = false;
            SwModifiedElement it$iv$iv = swModifiedElement;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List preservedItems = (List)destination$iv$iv;
        Iterable $this$mapNotNull$iv2 = createdIdentifiers;
        boolean $i$f$mapNotNull2 = false;
        destination$iv$iv = $this$mapNotNull$iv2;
        Iterable<Element> destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach2 = false;
        element$iv$iv$iv2 = $this$forEach$iv$iv$iv2.iterator();
        while (element$iv$iv$iv2.hasNext()) {
            Object element$iv$iv$iv3;
            Object element$iv$iv = element$iv$iv$iv3 = element$iv$iv$iv2.next();
            boolean bl8 = false;
            Object it4 = element$iv$iv;
            boolean bl9 = false;
            if (modified.get(it4) == null) continue;
            boolean bl10 = false;
            bl2 = false;
            Element it$iv$iv = itemAfter;
            boolean bl11 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List createdItems = (List)destination$iv$iv2;
        Iterable $this$mapNotNull$iv3 = removedIdentifiers;
        boolean $i$f$mapNotNull3 = false;
        destination$iv$iv2 = $this$mapNotNull$iv3;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo3 = false;
        void $this$forEach$iv$iv$iv3 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach3 = false;
        Iterator iterator = $this$forEach$iv$iv$iv3.iterator();
        while (iterator.hasNext()) {
            Element Element2;
            Object element$iv$iv$iv4;
            Object element$iv$iv = element$iv$iv$iv4 = iterator.next();
            boolean bl12 = false;
            Object it5 = element$iv$iv;
            boolean bl13 = false;
            if (original.get(it5) == null) continue;
            bl2 = false;
            boolean bl14 = false;
            Element it$iv$iv = Element2;
            bl = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        List removedItems = (List)destination$iv$iv3;
        return new SwDiffResult(createdItems, removedItems, preservedItems);
    }

    /*
     * WARNING - void declaration
     */
    private static final <Element, Identifier> Map<Identifier, Element> mapIdentifierToSelf(Collection<? extends Element> $this$mapIdentifierToSelf, Function1<? super Element, ? extends Identifier> identifyingFunction) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$mapIdentifierToSelf;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)identifyingFunction.invoke((Object)it), (Object)it);
            collection.add(pair);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }
}

