/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.codegen;

import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.swagger.SwaggerBundle;
import com.intellij.swagger.codegen.SwJavaInfo;
import com.intellij.swagger.codegen.SwaggerRunConfigurationUtilsKt;
import com.intellij.util.SystemProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0000\u001a\b\u0010\u0006\u001a\u00020\u0005H\u0000\u001a\f\u0010\u0007\u001a\u00020\u0001*\u00020\u0001H\u0002\u00a8\u0006\b"}, d2={"findJdkPathByShortName", "", "name", "getAllKnownJdks", "", "Lcom/intellij/swagger/codegen/SwJavaInfo;", "getDefaultJavaDistribution", "findExecutable", "intellij.swagger"})
public final class SwJdkUtilsKt {
    @NotNull
    public static final String findJdkPathByShortName(@NotNull String name2) {
        Object object;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Iterable $this$firstOrNull$iv = SwJdkUtilsKt.getAllKnownJdks();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SwJavaInfo it = (SwJavaInfo)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name2)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((object = (SwJavaInfo)v0) == null || (object = ((SwJavaInfo)object).getExecutablePath()) == null) {
            object = name2;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<SwJavaInfo> getAllKnownJdks() {
        void $this$mapNotNullTo$iv$iv;
        SwJavaInfo defaultJava = SwJdkUtilsKt.getDefaultJavaDistribution();
        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)projectJdkTable, (String)"ProjectJdkTable.getInstance()");
        Sdk[] sdkArray = projectJdkTable.getAllJdks();
        Intrinsics.checkNotNullExpressionValue((Object)sdkArray, (String)"ProjectJdkTable.getInstance().allJdks");
        Sdk[] $this$mapNotNull$iv = sdkArray;
        boolean $i$f$mapNotNull = false;
        Sdk[] sdkArray2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var9_10 = $this$forEach$iv$iv$iv;
        int n = ((void)var9_10).length;
        for (int i = 0; i < n; ++i) {
            SwJavaInfo swJavaInfo;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = var9_10[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            void v2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
            if (v2.getHomePath() == null) {
                swJavaInfo = null;
            } else {
                String homePath;
                Intrinsics.checkNotNullExpressionValue((Object)homePath, (String)"it.homePath ?: return@mapNotNull null");
                String string = SwJdkUtilsKt.findExecutable(homePath);
                String string2 = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
                swJavaInfo = new SwJavaInfo(string, string2);
            }
            if (swJavaInfo == null) continue;
            SwJavaInfo swJavaInfo2 = swJavaInfo;
            boolean bl3 = false;
            boolean bl4 = false;
            SwJavaInfo it$iv$iv = swJavaInfo2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        SwJavaInfo[] swJavaInfoArray = thisCollection$iv.toArray(new SwJavaInfo[0]);
        if (swJavaInfoArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        SwJavaInfo[] jdkArray = swJavaInfoArray;
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)defaultJava);
        spreadBuilder.addSpread((Object)jdkArray);
        Iterable $this$distinctBy$iv = CollectionsKt.listOf((Object[])((SwJavaInfo[])spreadBuilder.toArray((Object[])new SwJavaInfo[spreadBuilder.size()])));
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            SwJavaInfo it = (SwJavaInfo)e$iv;
            boolean bl = false;
            String key$iv = it.getExecutablePath();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        return list$iv;
    }

    @NotNull
    public static final SwJavaInfo getDefaultJavaDistribution() {
        String string = SystemProperties.getJavaHome();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SystemProperties.getJavaHome()");
        return new SwJavaInfo(SwJdkUtilsKt.findExecutable(string), SwaggerBundle.message("run.configuration.default.java.executable.title", new Object[0]));
    }

    private static final String findExecutable(String $this$findExecutable) {
        String string;
        String string2 = FileUtil.toSystemIndependentName((String)$this$findExecutable);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"FileUtil.toSystemIndependentName(this)");
        String systemIndependentJavaHome = string2;
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        String systemDependentName = SystemInfo.isWindows ? "java.exe" : "java";
        $this$buildString.append("bin");
        $this$buildString.append("/");
        $this$buildString.append(systemDependentName);
        String string3 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
        String executableSuffix = string3;
        if (StringsKt.endsWith$default((String)systemIndependentJavaHome, (String)executableSuffix, (boolean)false, (int)2, null)) {
            string = systemIndependentJavaHome;
        } else {
            boolean bl6 = false;
            bl3 = false;
            StringBuilder stringBuilder2 = new StringBuilder();
            bl4 = false;
            boolean bl7 = false;
            StringBuilder $this$buildString2 = stringBuilder2;
            boolean bl8 = false;
            $this$buildString2.append(systemIndependentJavaHome);
            $this$buildString2.append("/");
            $this$buildString2.append(executableSuffix);
            String string4 = stringBuilder2.toString();
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
        }
        String javaExecutable = string;
        return SwaggerRunConfigurationUtilsKt.toSystemDependentPath(javaExecutable);
    }
}

