/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.codegen;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.swagger.codegen.CodeGeneratorType;
import com.intellij.swagger.codegen.CodegenCliBuilderKt;
import com.intellij.swagger.codegen.CodegenConfiguration;
import com.intellij.swagger.codegen.GeneratorRequestFactory;
import com.intellij.swagger.codegen.GeneratorRequestFactoryKt$WhenMappings;
import com.intellij.swagger.codegen.OpenAPIGeneratorRequestFactory;
import com.intellij.swagger.codegen.SwaggerCodegenRequestFactory;
import com.intellij.swagger.codegen.completion.JarProgramOutputParserKt;
import com.intellij.swagger.codegen.completion.ParsedResult;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001H\u0000\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0007"}, d2={"guessGeneratorType", "Lcom/intellij/swagger/codegen/CodeGeneratorType;", "codegenConfiguration", "Lcom/intellij/swagger/codegen/CodegenConfiguration;", "guessRequestFactory", "Lcom/intellij/swagger/codegen/GeneratorRequestFactory;", "generatorType", "intellij.swagger"})
public final class GeneratorRequestFactoryKt {
    @Nullable
    public static final GeneratorRequestFactory guessRequestFactory(@NotNull CodegenConfiguration codegenConfiguration) {
        Intrinsics.checkNotNullParameter((Object)codegenConfiguration, (String)"codegenConfiguration");
        CodeGeneratorType codeGeneratorType = GeneratorRequestFactoryKt.guessGeneratorType(codegenConfiguration);
        if (codeGeneratorType == null) {
            return null;
        }
        CodeGeneratorType generatorType2 = codeGeneratorType;
        return GeneratorRequestFactoryKt.guessRequestFactory(generatorType2);
    }

    @NotNull
    public static final GeneratorRequestFactory guessRequestFactory(@NotNull CodeGeneratorType generatorType2) {
        GeneratorRequestFactory generatorRequestFactory;
        Intrinsics.checkNotNullParameter((Object)((Object)generatorType2), (String)"generatorType");
        switch (GeneratorRequestFactoryKt$WhenMappings.$EnumSwitchMapping$0[generatorType2.ordinal()]) {
            case 1: 
            case 2: {
                generatorRequestFactory = SwaggerCodegenRequestFactory.INSTANCE;
                break;
            }
            case 3: 
            case 4: {
                generatorRequestFactory = OpenAPIGeneratorRequestFactory.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return generatorRequestFactory;
    }

    @Nullable
    public static final CodeGeneratorType guessGeneratorType(@NotNull CodegenConfiguration codegenConfiguration) {
        CodeGeneratorType generatorType2;
        Intrinsics.checkNotNullParameter((Object)codegenConfiguration, (String)"codegenConfiguration");
        Object object = JarProgramOutputParserKt.runCodegenWithParameters(new CodegenConfiguration(codegenConfiguration.getJavaPath(), codegenConfiguration.getCodegenPath(), null, 4, null), CodegenCliBuilderKt.buildGeneratorVersionRequest(OpenAPIGeneratorRequestFactory.INSTANCE), OpenAPIGeneratorRequestFactory.INSTANCE.versionPattern());
        String versionOrNull = object != null && (object = ((ParsedResult)object).getItems()) != null ? (String)CollectionsKt.firstOrNull((List)object) : null;
        CodeGeneratorType codeGeneratorType = versionOrNull == null ? null : (StringsKt.startsWith$default((String)versionOrNull, (String)"2", (boolean)false, (int)2, null) ? CodeGeneratorType.SWAGGER_CODEGEN_V2 : (StringsKt.startsWith$default((String)versionOrNull, (String)"3", (boolean)false, (int)2, null) ? CodeGeneratorType.SWAGGER_CODEGEN_V3 : (StringsKt.startsWith$default((String)versionOrNull, (String)"4", (boolean)false, (int)2, null) ? CodeGeneratorType.OPENAPI_GENERATOR_V4 : (generatorType2 = StringsKt.startsWith$default((String)versionOrNull, (String)"5", (boolean)false, (int)2, null) ? CodeGeneratorType.OPENAPI_GENERATOR_V5 : null))));
        if (generatorType2 == null) {
            Logger.getInstance(GeneratorRequestFactory.class).warn("Unable to determine generator version and type, output of 'version' command is: '" + versionOrNull + '\'');
        }
        return generatorType2;
    }
}

