/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.codegen;

import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.swagger.codegen.CliArgumentViewModel;
import com.intellij.swagger.codegen.CliCommand;
import com.intellij.swagger.codegen.CodeGeneratorType;
import com.intellij.swagger.codegen.CodegenCliBuilderKt$WhenMappings;
import com.intellij.swagger.codegen.GeneratorRequestFactory;
import com.intellij.swagger.codegen.GeneratorRequestFactoryKt;
import com.intellij.swagger.codegen.SwConfigurationType;
import com.intellij.swagger.codegen.SwaggerCodegenRunConfiguration;
import com.intellij.swagger.codegen.SwaggerRunConfigurationUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a#\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\u0010\u0006\u001a\u001b\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\b\u001a\u00020\u0002H\u0000\u00a2\u0006\u0002\u0010\t\u001a\u001b\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\u0010\u000b\u001a\u001b\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\u0010\u000b\u001a\u001b\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\u0010\u0010\u001a$\u0010\u0011\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\u0015"}, d2={"buildConfigHelpRequest", "", "", "language", "requestFactory", "Lcom/intellij/swagger/codegen/GeneratorRequestFactory;", "(Ljava/lang/String;Lcom/intellij/swagger/codegen/GeneratorRequestFactory;)[Ljava/lang/String;", "buildGeneratorLaunchCommand", "generatorPath", "(Ljava/lang/String;)[Ljava/lang/String;", "buildGeneratorVersionRequest", "(Lcom/intellij/swagger/codegen/GeneratorRequestFactory;)[Ljava/lang/String;", "buildLanguagesRequest", "buildParametersFromConfiguration", "configuration", "Lcom/intellij/swagger/codegen/SwaggerCodegenRunConfiguration;", "(Lcom/intellij/swagger/codegen/SwaggerCodegenRunConfiguration;)[Ljava/lang/String;", "withGenerationParameters", "Lcom/intellij/swagger/codegen/CliCommand;", "generatorType", "Lcom/intellij/swagger/codegen/CodeGeneratorType;", "intellij.swagger"})
public final class CodegenCliBuilderKt {
    @NotNull
    public static final String[] buildGeneratorLaunchCommand(@NotNull String generatorPath) {
        Intrinsics.checkNotNullParameter((Object)generatorPath, (String)"generatorPath");
        return new CliCommand().addCommonArgument("-jar", SwaggerRunConfigurationUtilsKt.toSystemDependentPath(generatorPath)).asStringArray();
    }

    @NotNull
    public static final String[] buildLanguagesRequest(@NotNull GeneratorRequestFactory requestFactory) {
        Intrinsics.checkNotNullParameter((Object)requestFactory, (String)"requestFactory");
        return new CliCommand().addSingleWordArgument(requestFactory.languagesArgument()).asStringArray();
    }

    @NotNull
    public static final String[] buildConfigHelpRequest(@NotNull String language, @NotNull GeneratorRequestFactory requestFactory) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)requestFactory, (String)"requestFactory");
        return new CliCommand().addSingleWordArgument(requestFactory.configHelpArgument()).addCommonArgument(requestFactory.languageFlag(), language).asStringArray();
    }

    @NotNull
    public static final String[] buildGeneratorVersionRequest(@NotNull GeneratorRequestFactory requestFactory) {
        Intrinsics.checkNotNullParameter((Object)requestFactory, (String)"requestFactory");
        return new CliCommand().addSingleWordArgument(requestFactory.versionArgument()).asStringArray();
    }

    @NotNull
    public static final String[] buildParametersFromConfiguration(@NotNull SwaggerCodegenRunConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Callable callable = new Callable(configuration){
            final /* synthetic */ SwaggerCodegenRunConfiguration $configuration;

            @Nullable
            public final CodeGeneratorType call() {
                return GeneratorRequestFactoryKt.guessGeneratorType(this.$configuration.getGeneratorConfiguration$intellij_swagger());
            }
            {
                this.$configuration = swaggerCodegenRunConfiguration;
            }
        };
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
        CodeGeneratorType codeGeneratorType = (CodeGeneratorType)((Object)ApplicationUtil.runWithCheckCanceled((Callable)callable, (ProgressIndicator)EmptyProgressIndicator.notNullize((ProgressIndicator)progressManager.getProgressIndicator())));
        if (codeGeneratorType == null) {
            return new String[0];
        }
        CodeGeneratorType generatorType2 = codeGeneratorType;
        GeneratorRequestFactory requestFactory = GeneratorRequestFactoryKt.guessRequestFactory(generatorType2);
        return CodegenCliBuilderKt.withGenerationParameters(new CliCommand().addCommonArgument("-jar", configuration.getLocalGeneratorPath()).addSingleWordArgument(requestFactory.generateArgument()).addCommonArgument(requestFactory.languageFlag(), configuration.getLanguage()).addCommonArgument(requestFactory.specificationFlag(), SwaggerRunConfigurationUtilsKt.toSystemDependentPath(configuration.getSpecificationPath())).addCommonArgument(requestFactory.customTemplatesPathFlag(), SwaggerRunConfigurationUtilsKt.toSystemDependentPath(configuration.getCustomTemplatesPath())).addCommonArgument(requestFactory.outputFolderFlag(), SwaggerRunConfigurationUtilsKt.toSystemDependentPath(configuration.getGenerateToPath())), configuration, generatorType2, requestFactory).asStringArray();
    }

    /*
     * WARNING - void declaration
     */
    private static final CliCommand withGenerationParameters(CliCommand $this$withGenerationParameters, SwaggerCodegenRunConfiguration configuration, CodeGeneratorType generatorType2, GeneratorRequestFactory requestFactory) {
        CliCommand cliCommand = $this$withGenerationParameters;
        boolean bl = false;
        boolean bl2 = false;
        CliCommand it = cliCommand;
        boolean bl3 = false;
        if (configuration.getConfigurationType() == SwConfigurationType.FILE) {
            $this$withGenerationParameters.addCommonArgument(requestFactory.configurationFileFlag(), configuration.getConfigurationPath());
        } else {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = configuration.getGenerationParameters();
            boolean $i$f$mapNotNull = false;
            Iterator iterator = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Pair pair;
                String value;
                String name2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl4 = false;
                CliArgumentViewModel it2 = (CliArgumentViewModel)element$iv$iv;
                boolean bl5 = false;
                if ((it2.getName() == null ? null : (it2.getValue() == null ? null : TuplesKt.to((Object)name2, (Object)value))) == null) continue;
                pair = pair;
                boolean bl6 = false;
                boolean bl7 = false;
                Pair it$iv$iv = pair;
                boolean bl8 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List namesToValues = (List)destination$iv$iv;
            switch (CodegenCliBuilderKt$WhenMappings.$EnumSwitchMapping$0[generatorType2.ordinal()]) {
                case 1: 
                case 2: {
                    $this$withGenerationParameters.addPropertiesArgument(namesToValues);
                    break;
                }
                default: {
                    Iterable $this$forEach$iv = namesToValues;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Pair it3 = (Pair)element$iv;
                        boolean bl9 = false;
                        $this$withGenerationParameters.addWrappedArgument((String)it3.getFirst(), (String)it3.getSecond());
                    }
                }
            }
        }
        return cliCommand;
    }
}

