/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.actions;

import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.swagger.SwSpecificationDetectionKt;
import com.intellij.swagger.SwaggerIcons;
import com.intellij.swagger.ui.SpecificationReferencesInlineHelper;
import com.intellij.swagger.ui.SwaggerUIManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b \u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/swagger/actions/SwGenerateSelfContainedSpecificationAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "preferJsonOverYaml", "", "text", "", "(ZLjava/lang/String;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "generateSelfContainedSpecification", "isAvailable", "saveAndOpenScratch", "content", "update", "intellij.swagger"})
public abstract class SwGenerateSelfContainedSpecificationAction
extends AnAction {
    private final boolean preferJsonOverYaml;

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        boolean bl = false;
        boolean bl2 = false;
        Presentation $this$apply = presentation;
        boolean bl3 = false;
        boolean available = this.isAvailable(e);
        $this$apply.setEnabled(available);
        $this$apply.setVisible(available);
    }

    private final boolean isAvailable(AnActionEvent e) {
        PsiFile psiFile2 = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (psiFile2 == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"e.getData(CommonDataKeys.PSI_FILE) ?: return false");
        PsiFile psiFile3 = psiFile2;
        return SwSpecificationDetectionKt.detectIsSpecificationFile(psiFile3);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String string = this.generateSelfContainedSpecification(e);
        if (string == null) {
            return;
        }
        String specification = string;
        this.saveAndOpenScratch(specification, e);
    }

    private final String generateSelfContainedSpecification(AnActionEvent e) {
        PsiFile psiFile2 = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (psiFile2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"e.getData(CommonDataKeys.PSI_FILE) ?: return null");
        PsiFile specification = psiFile2;
        String string = SwaggerUIManager.INSTANCE.prepareSpecificationText$intellij_swagger(specification);
        if (string == null) {
            SwGenerateSelfContainedSpecificationAction swGenerateSelfContainedSpecificationAction = this;
            boolean bl = false;
            boolean bl2 = false;
            SwGenerateSelfContainedSpecificationAction $this$run = swGenerateSelfContainedSpecificationAction;
            boolean bl3 = false;
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(SwGenerateSelfContainedSpecificationAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.warn("Unable to prepare self-contained specification text, abort export");
            return null;
        }
        String specificationTextJson = string;
        return this.preferJsonOverYaml ? specificationTextJson : new SpecificationReferencesInlineHelper(0, 1, null).convertJsonToYaml$intellij_swagger(specificationTextJson);
    }

    private final void saveAndOpenScratch(String content, AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.getData(CommonDataKeys.PROJECT) ?: return");
        Project project2 = project;
        PsiFile psiFile2 = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (psiFile2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"e.getData(CommonDataKeys.PSI_FILE) ?: return");
        PsiFile specification = psiFile2;
        String string = FileUtil.sanitizeFileName((String)FileUtil.getNameWithoutExtension((String)specification.getName()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.sanitizeFileNam\u2026sion(specification.name))");
        String originalSpecificationName = string;
        String extension = this.preferJsonOverYaml ? ".json" : ".yaml";
        String generatedSpecificationName = originalSpecificationName + ".self-contained" + extension;
        VirtualFile generatedFile = ScratchRootType.getInstance().findFile(project2, generatedSpecificationName, ScratchFileService.Option.create_new_always);
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable(generatedFile, content){
            final /* synthetic */ VirtualFile $generatedFile$inlined;
            final /* synthetic */ String $content$inlined;
            {
                this.$generatedFile$inlined = virtualFile2;
                this.$content$inlined = string;
            }

            public final T compute() {
                boolean bl = false;
                VfsUtil.saveText((VirtualFile)this.$generatedFile$inlined, (String)this.$content$inlined);
                return (T)Unit.INSTANCE;
            }
        });
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project2);
        boolean bl = false;
        boolean bl2 = false;
        FileEditorManager $this$run = fileEditorManager;
        boolean bl3 = false;
        if (!$this$run.isFileOpen(generatedFile)) {
            $this$run.openFile(generatedFile, true);
        }
    }

    public SwGenerateSelfContainedSpecificationAction(boolean preferJsonOverYaml, @NlsActions.ActionText @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(SwaggerIcons.Openapi);
        this.preferJsonOverYaml = preferJsonOverYaml;
    }
}

