/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.swagger.SwaggerLanguagesModificationTracker;
import com.intellij.swagger.hub.SwaggerHubManager;
import com.intellij.swagger.model.api.SwAuthority;
import com.intellij.swagger.model.api.SwModelElement;
import com.intellij.swagger.model.api.SwUrl;
import com.intellij.swagger.model.specification.SwSpecificationFile;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000j\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0000\u001a#\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0006\"\u00020\u0003H\u0000\u00a2\u0006\u0002\u0010\u0007\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0003H\u0000\u001a.\u0010\u000b\u001a\u00020\u00032\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u001a\u001e\u0010\u0018\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u00032\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0000\u001a\u0014\u0010\u001b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0003H\u0000\u001a\u001e\u0010\u001d\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u00032\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0000\u001a&\u0010\u001e\u001a\u0004\u0018\u0001H\u001f\"\u0006\b\u0000\u0010\u001f\u0018\u0001*\f\u0012\u0006\b\u0001\u0012\u00020!\u0018\u00010 H\u0080\b\u00a2\u0006\u0002\u0010\"\u001a\u0012\u0010#\u001a\b\u0012\u0004\u0012\u00020!0 *\u00020!H\u0000\u001a\u000e\u0010$\u001a\u00020%*\u0004\u0018\u00010&H\u0000\u001a\u0014\u0010'\u001a\u00020%*\u00020\u00172\u0006\u0010(\u001a\u00020)H\u0000\u001a!\u0010*\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001f*\u0004\u0018\u0001H\u001f2\u0006\u0010+\u001a\u0002H\u001fH\u0000\u00a2\u0006\u0002\u0010,\u001a\u000e\u0010-\u001a\u00020\u0003*\u0004\u0018\u00010\u0003H\u0000\u001a9\u0010.\u001a\b\u0012\u0004\u0012\u0002H\u001f0\u000e\"\u0004\b\u0000\u0010\u001f*\n\u0012\u0004\u0012\u0002H\u001f\u0018\u00010\u000e2\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u001f0\u0006\"\u0002H\u001fH\u0000\u00a2\u0006\u0002\u00100\u001a \u00101\u001a\b\u0012\u0004\u0012\u0002H\u001f0\u000e\"\u0004\b\u0000\u0010\u001f*\n\u0012\u0004\u0012\u0002H\u001f\u0018\u000102H\u0000\u001a\f\u00103\u001a\u00020\u0003*\u00020\u0003H\u0000\u001a\f\u00104\u001a\u00020\u0003*\u00020\u0003H\u0000\u00a8\u00065"}, d2={"buildUrlFrom", "Lorg/apache/http/client/utils/URIBuilder;", "url", "", "buildUrlFromSegments", "segments", "", "([Ljava/lang/String;)Ljava/lang/String;", "getBundledResource", "Lcom/intellij/openapi/vfs/VirtualFile;", "resourceName", "getEndpointLocation", "authority", "basePaths", "", "Lcom/intellij/swagger/model/api/SwUrl;", "endpointUrl", "getYamlJsonModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "project", "Lcom/intellij/openapi/project/Project;", "suggestRemoteSpecificationUrl", "specification", "Lcom/intellij/swagger/model/specification/SwSpecificationFile;", "addParameterIfNotNull", "name", "value", "addPathSegment", "segment", "addQueryParameter", "castOrNull", "T", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/SmartPsiElementPointer;)Ljava/lang/Object;", "createPointer", "isElementValid", "", "Lcom/intellij/swagger/model/api/SwModelElement;", "isLocatedInScope", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "or", "default", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "orDefaultPath", "orDefaultValues", "defaultValues", "(Ljava/util/List;[Ljava/lang/Object;)Ljava/util/List;", "toListOrEmpty", "Lkotlin/sequences/Sequence;", "withEndingSlash", "withLeadingSlash", "intellij.swagger"})
public final class SwaggerUtilsKt {
    @NotNull
    public static final String orDefaultPath(@Nullable String $this$orDefaultPath) {
        String string = $this$orDefaultPath;
        if (string == null) {
            string = "/";
        }
        return string;
    }

    @NotNull
    public static final SmartPsiElementPointer<PsiElement> createPointer(@NotNull PsiElement $this$createPointer) {
        Intrinsics.checkNotNullParameter((Object)$this$createPointer, (String)"$this$createPointer");
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)$this$createPointer);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"SmartPointerManager.createPointer(this)");
        return smartPsiElementPointer;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ <T> T castOrNull(SmartPsiElementPointer<? extends PsiElement> $this$castOrNull) {
        PsiElement psiElement;
        PsiElement element;
        int $i$f$castOrNull = 0;
        SmartPsiElementPointer<? extends PsiElement> smartPsiElementPointer = $this$castOrNull;
        Object object = element = smartPsiElementPointer != null ? smartPsiElementPointer.getElement() : null;
        if (element != null) {
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (element instanceof Object && element.isValid()) {
                psiElement = element;
                return (T)psiElement;
            }
        }
        psiElement = null;
        return (T)psiElement;
    }

    @Nullable
    public static final String buildUrlFromSegments(String ... segments) {
        Intrinsics.checkNotNullParameter((Object)segments, (String)"segments");
        StringBuilder stringBuilder = new StringBuilder();
        for (String segment : segments) {
            if (StringsKt.endsWith$default((CharSequence)stringBuilder, (CharSequence)"/", (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)segment, (String)"/", (boolean)false, (int)2, null)) {
                stringBuilder.append(StringsKt.drop((String)segment, (int)1));
                continue;
            }
            stringBuilder.append(segment);
        }
        CharSequence charSequence = stringBuilder;
        int n = 0;
        return charSequence.length() == 0 ? null : stringBuilder.toString();
    }

    public static final boolean isElementValid(@Nullable SwModelElement $this$isElementValid) {
        SwModelElement swModelElement = $this$isElementValid;
        return swModelElement != null && (swModelElement = swModelElement.getSourcePsi()) != null ? swModelElement.isValid() : false;
    }

    @NotNull
    public static final ModificationTracker getYamlJsonModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = project.getService(SwaggerLanguagesModificationTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.getService(Swagg\u2026ationTracker::class.java)");
        return (ModificationTracker)object;
    }

    @NotNull
    public static final String withLeadingSlash(@NotNull String $this$withLeadingSlash) {
        Intrinsics.checkNotNullParameter((Object)$this$withLeadingSlash, (String)"$this$withLeadingSlash");
        return StringsKt.startsWith$default((String)$this$withLeadingSlash, (String)"/", (boolean)false, (int)2, null) ? $this$withLeadingSlash : '/' + $this$withLeadingSlash;
    }

    @NotNull
    public static final String withEndingSlash(@NotNull String $this$withEndingSlash) {
        Intrinsics.checkNotNullParameter((Object)$this$withEndingSlash, (String)"$this$withEndingSlash");
        return StringsKt.endsWith$default((String)$this$withEndingSlash, (String)"://", (boolean)false, (int)2, null) ? $this$withEndingSlash : $this$withEndingSlash + "://";
    }

    public static final boolean isLocatedInScope(@NotNull SwSpecificationFile $this$isLocatedInScope, @NotNull GlobalSearchScope scope) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isLocatedInScope, (String)"$this$isLocatedInScope");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        PsiFile psiFile2 = $this$isLocatedInScope.getSourcePsi();
        if (psiFile2 != null && (psiFile2 = psiFile2.getVirtualFile()) != null) {
            PsiFile psiFile3 = psiFile2;
            boolean bl2 = false;
            boolean bl3 = false;
            PsiFile it = psiFile3;
            boolean bl4 = false;
            bl = scope.contains((VirtualFile)it);
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final <T> List<T> orDefaultValues(@Nullable List<? extends T> $this$orDefaultValues, T ... defaultValues) {
        Intrinsics.checkNotNullParameter(defaultValues, (String)"defaultValues");
        Collection collection = $this$orDefaultValues;
        boolean bl = false;
        boolean bl2 = false;
        return collection == null || collection.isEmpty() ? ArraysKt.asList((Object[])defaultValues) : $this$orDefaultValues;
    }

    public static final <T> T or(@Nullable T $this$or, T t) {
        T t2 = $this$or;
        if (t2 == null) {
            t2 = t;
        }
        return t2;
    }

    @NotNull
    public static final <T> List<T> toListOrEmpty(@Nullable Sequence<? extends T> $this$toListOrEmpty) {
        Sequence<? extends T> sequence = $this$toListOrEmpty;
        List list = sequence != null ? SequencesKt.toList(sequence) : null;
        boolean bl = false;
        List list2 = list;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final VirtualFile getBundledResource(@NotNull String resourceName) {
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        PluginId pluginId = PluginId.findId((String)"com.intellij.swagger");
        Object object = pluginId;
        if (pluginId == null) return null;
        PluginId pluginId2 = object;
        boolean bl = false;
        boolean bl2 = false;
        Object it = pluginId2;
        boolean bl3 = false;
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)it);
        object = ideaPluginDescriptor;
        if (ideaPluginDescriptor == null) return null;
        ClassLoader classLoader = object.getPluginClassLoader();
        object = classLoader;
        if (classLoader == null) return null;
        URL uRL = ((ClassLoader)object).getResource(resourceName);
        object = uRL;
        if (uRL == null) return null;
        Object object2 = object;
        bl = false;
        bl2 = false;
        it = object2;
        boolean bl4 = false;
        VirtualFile virtualFile2 = VfsUtil.findFileByURL((URL)it);
        return virtualFile2;
    }

    @Nullable
    public static final String suggestRemoteSpecificationUrl(@NotNull SwSpecificationFile specification) {
        String string;
        Intrinsics.checkNotNullParameter((Object)specification, (String)"specification");
        if (specification.isRemote()) {
            String location;
            SwModelElement swModelElement = specification;
            String authority = swModelElement != null && (swModelElement = swModelElement.getAuthorities()) != null && (swModelElement = (SwAuthority)CollectionsKt.firstOrNull((List)((Object)swModelElement))) != null && (swModelElement = ((SwAuthority)swModelElement).getAuthorityValue()) != null ? swModelElement.getValue() : null;
            String string2 = location = SwaggerUtilsKt.getEndpointLocation$default(authority, specification.getBasePaths(), null, 4, null);
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            CharSequence charSequence = it;
            boolean bl4 = false;
            string = charSequence.length() > 0 ? string2 : null;
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public static final URIBuilder buildUrlFrom(@Nullable String url2) {
        CharSequence charSequence = url2;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        try {
            URIBuilder builder = new URIBuilder(url2);
            charSequence = builder.getHost() == null ? null : charSequence;
        }
        catch (URISyntaxException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(SwaggerHubManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.warn("Unable to parse URL: " + url2);
            charSequence = null;
        }
        return charSequence;
    }

    @NotNull
    public static final URIBuilder addPathSegment(@NotNull URIBuilder $this$addPathSegment, @NotNull String segment) {
        Intrinsics.checkNotNullParameter((Object)$this$addPathSegment, (String)"$this$addPathSegment");
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        List list = $this$addPathSegment.getPathSegments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"this.pathSegments");
        $this$addPathSegment.setPathSegments(CollectionsKt.plus((Collection)list, (Object)segment));
        return $this$addPathSegment;
    }

    @NotNull
    public static final URIBuilder addQueryParameter(@NotNull URIBuilder $this$addQueryParameter, @NotNull String name2, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)$this$addQueryParameter, (String)"$this$addQueryParameter");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        $this$addQueryParameter.setParameter(name2, value);
        return $this$addQueryParameter;
    }

    @NotNull
    public static final URIBuilder addParameterIfNotNull(@NotNull URIBuilder $this$addParameterIfNotNull, @NotNull String name2, @Nullable String value) {
        String string;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$addParameterIfNotNull, (String)"$this$addParameterIfNotNull");
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                string = value;
                if (string == null) break block2;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                string = SwaggerUtilsKt.addQueryParameter($this$addParameterIfNotNull, name2, it);
                if (string != null) break block3;
            }
            string = $this$addParameterIfNotNull;
        }
        return string;
    }

    @NotNull
    public static final String getEndpointLocation(@Nullable String authority, @NotNull List<? extends SwUrl> basePaths2, @Nullable String endpointUrl) {
        Intrinsics.checkNotNullParameter(basePaths2, (String)"basePaths");
        StringBuilder stringBuilder = new StringBuilder();
        SwUrl swUrl = (SwUrl)CollectionsKt.firstOrNull(basePaths2);
        String string = swUrl != null ? swUrl.getUrlString() : null;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(StringsKt.removeSuffix((String)string2, (CharSequence)"/"));
        string = endpointUrl;
        bl = false;
        String string3 = string;
        if (string3 == null) {
            string3 = "";
        }
        String presentablePath = stringBuilder2.append(string3).toString();
        return authority != null ? StringsKt.removeSuffix((String)authority, (CharSequence)"/") + presentablePath : presentablePath;
    }

    public static /* synthetic */ String getEndpointLocation$default(String string, List list, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        return SwaggerUtilsKt.getEndpointLocation(string, list, string2);
    }
}

