/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.swagger.SpecificationType;
import com.intellij.swagger.model.specification.SwaggerFileHelper;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\n"}, d2={"detectIsSpecificationFile", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "detectSpecificationType", "Lcom/intellij/swagger/SpecificationType;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.swagger"})
public final class SwSpecificationDetectionKt {
    public static final boolean detectIsSpecificationFile(@NotNull PsiFile psiFile2) {
        Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
        SpecificationType type2 = SwSpecificationDetectionKt.detectSpecificationType(psiFile2);
        return type2 == SpecificationType.SWAGGER_2 || type2 == SpecificationType.OPENAPI_3;
    }

    @NotNull
    public static final SpecificationType detectSpecificationType(@NotNull PsiFile psiFile2) {
        Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
        PsiFile psiFile3 = psiFile2.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile3, (String)"psiFile.originalFile");
        VirtualFile virtualFile2 = psiFile3.getVirtualFile();
        if (virtualFile2 == null) {
            return SpecificationType.NONE;
        }
        VirtualFile virtualFile3 = virtualFile2;
        return SwSpecificationDetectionKt.detectSpecificationType(virtualFile3, psiFile2);
    }

    @NotNull
    public static final SpecificationType detectSpecificationType(@NotNull VirtualFile virtualFile2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiFile psiFile2 = (PsiFile)ReadAction.nonBlocking((Callable)new Callable(project, virtualFile2){
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $virtualFile;

            @Nullable
            public final PsiFile call() {
                return PsiManager.getInstance((Project)this.$project).findFile(this.$virtualFile);
            }
            {
                this.$project = project;
                this.$virtualFile = virtualFile2;
            }
        }).executeSynchronously();
        if (psiFile2 == null) {
            return SpecificationType.NONE;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"ReadAction.nonBlocking(\n\u2026rn SpecificationType.NONE");
        PsiFile psiFile3 = psiFile2;
        return SwSpecificationDetectionKt.detectSpecificationType(virtualFile2, psiFile3);
    }

    @NotNull
    public static final SpecificationType detectSpecificationType(@NotNull VirtualFile virtualFile2, @NotNull PsiFile psiFile2) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
        return SwaggerFileHelper.INSTANCE.getOrComputeSpecificationKind$intellij_swagger(virtualFile2, psiFile2);
    }
}

