/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.impl.FinishEventImpl;
import com.intellij.build.events.impl.ProgressBuildEventImpl;
import com.intellij.build.events.impl.SkippedResultImpl;
import com.intellij.build.events.impl.StartEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.build.issue.BuildIssue;
import com.intellij.execution.target.HostPort;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentsManager;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.issue.BuildIssueException;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskState;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemBuildEvent;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkException;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.TargetEnvironmentConfigurationProvider;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemResolveProjectTask;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.SdkLookupProvider;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.PathMapper;
import java.io.File;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.plugins.gradle.issue.IncorrectGradleJdkIssue;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.execution.BuildLayoutParameters;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionAware;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfiguration;
import org.jetbrains.plugins.gradle.service.execution.GradleServerConfigurationProvider;
import org.jetbrains.plugins.gradle.service.execution.LocalBuildLayoutParameters;
import org.jetbrains.plugins.gradle.service.execution.LocalGradleExecutionAware;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleEnvironment;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionUtil;
import org.jetbrains.plugins.gradle.util.GradleJvmUtil;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 :2\u00020\u0001:\u0002:;B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J!\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0010\u0010\u0012\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0018\u00010\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\"\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010#\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010$\u001a\u00020%2\b\b\u0001\u0010&\u001a\u00020\u0006H\u0002J\n\u0010'\u001a\u0004\u0018\u00010\u001cH\u0002J0\u0010(\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J*\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J/\u0010+\u001a\u0002H,\"\u0004\b\u0000\u0010,2\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u0002H,0.H\u0002\u00a2\u0006\u0002\u0010/J\u001a\u00100\u001a\u00020\u0004*\u00020\t2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u000402H\u0002J\u001c\u00103\u001a\u00020\u0004*\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u00104\u001a\u00020\u000bH\u0002J\u001c\u00105\u001a\u00020\u0004*\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u00104\u001a\u00020\u000bH\u0002J\u001c\u00106\u001a\u00020\u0004*\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u00104\u001a\u00020\u000bH\u0002J\u001e\u00107\u001a\u0004\u0018\u000108*\u0002092\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006<"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/LocalGradleExecutionAware;", "Lorg/jetbrains/plugins/gradle/service/execution/GradleExecutionAware;", "()V", "checkForWslJdkOnWindows", "", "homePath", "", "externalProjectPath", "task", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTask;", "createProgressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "taskId", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "taskNotificationListener", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListener;", "findGradleJar", "Ljava/io/File;", "files", "", "([Ljava/io/File;)Ljava/io/File;", "getBuildLayoutParameters", "Lorg/jetbrains/plugins/gradle/service/execution/BuildLayoutParameters;", "project", "Lcom/intellij/openapi/project/Project;", "projectPath", "getDefaultBuildLayoutParameters", "getEnvironmentConfiguration", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "runConfiguration", "Lcom/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration;", "getEnvironmentConfigurationProvider", "Lcom/intellij/openapi/externalSystem/service/execution/TargetEnvironmentConfigurationProvider;", "isPreviewMode", "", "isGradleInstallationHomeDir", "jdkConfigurationException", "Lcom/intellij/openapi/externalSystem/service/execution/ExternalSystemJdkException;", "key", "localEnvironment", "prepareExecution", "prepareJvmForExecution", "Lcom/intellij/openapi/roots/ui/configuration/SdkLookupProvider$SdkInfo;", "use", "R", "action", "Lkotlin/Function1;", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "onCancel", "callback", "Lkotlin/Function0;", "submitProgressFinished", "progressIndicator", "submitProgressStarted", "submitProgressStatus", "waitForGradleJvmResolving", "Lcom/intellij/openapi/projectRoots/Sdk;", "Lcom/intellij/openapi/roots/ui/configuration/SdkLookupProvider;", "Companion", "GradleEnvironmentConfigurationProvider", "intellij.gradle.common"})
@ApiStatus.Internal
public final class LocalGradleExecutionAware
implements GradleExecutionAware {
    private static final Logger log;
    @NotNull
    public static final String LOCAL_TARGET_TYPE_ID = "local";
    @NotNull
    public static final Companion Companion;

    public void prepareExecution(@NotNull ExternalSystemTask task2, @NotNull String externalProjectPath, boolean isPreviewMode, @NotNull ExternalSystemTaskNotificationListener taskNotificationListener, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
        Intrinsics.checkNotNullParameter((Object)taskNotificationListener, (String)"taskNotificationListener");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!isPreviewMode) {
            this.prepareJvmForExecution(task2, externalProjectPath, taskNotificationListener, project);
        }
    }

    @Nullable
    public TargetEnvironmentConfigurationProvider getEnvironmentConfigurationProvider(@NotNull ExternalSystemRunConfiguration runConfiguration, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        TargetEnvironmentConfiguration targetEnvironmentConfiguration = this.getEnvironmentConfiguration(runConfiguration, project);
        if (targetEnvironmentConfiguration == null) {
            return null;
        }
        TargetEnvironmentConfiguration targetEnvironmentConfiguration2 = targetEnvironmentConfiguration;
        return new GradleEnvironmentConfigurationProvider(targetEnvironmentConfiguration2);
    }

    @Nullable
    public TargetEnvironmentConfigurationProvider getEnvironmentConfigurationProvider(@NotNull String projectPath, boolean isPreviewMode, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        TargetEnvironmentConfiguration targetEnvironmentConfiguration = this.localEnvironment();
        if (targetEnvironmentConfiguration == null) {
            return null;
        }
        TargetEnvironmentConfiguration targetEnvironmentConfiguration2 = targetEnvironmentConfiguration;
        return new GradleEnvironmentConfigurationProvider(targetEnvironmentConfiguration2);
    }

    @Override
    @NotNull
    public BuildLayoutParameters getDefaultBuildLayoutParameters(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new LocalBuildLayoutParameters(project, null);
    }

    @Override
    @NotNull
    public BuildLayoutParameters getBuildLayoutParameters(@NotNull Project project, @NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        return new LocalBuildLayoutParameters(project, projectPath);
    }

    @Override
    public boolean isGradleInstallationHomeDir(@NotNull Project project, @NotNull String homePath) {
        boolean found;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)homePath, (String)"homePath");
        File libs = new File(homePath, "lib");
        if (!libs.isDirectory()) {
            if (GradleEnvironment.DEBUG_GRADLE_HOME_PROCESSING) {
                log.info("Gradle sdk check failed for the path '" + homePath + "'. Reason: it doesn't have a child directory named 'lib'");
            }
            return false;
        }
        boolean bl = found = this.findGradleJar(libs.listFiles()) != null;
        if (GradleEnvironment.DEBUG_GRADLE_HOME_PROCESSING) {
            log.info("Gradle home check " + (found ? "passed" : "failed") + " for the path '" + homePath + '\'');
        }
        return found;
    }

    @ApiStatus.Internal
    @Nullable
    public final SdkLookupProvider.SdkInfo prepareJvmForExecution(@NotNull ExternalSystemTask task2, @NotNull String externalProjectPath, @NotNull ExternalSystemTaskNotificationListener taskNotificationListener, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
        Intrinsics.checkNotNullParameter((Object)taskNotificationListener, (String)"taskNotificationListener");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object r = this.use(project, prepareJvmForExecution.settings.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(r, (String)"use(project) { GradleSettings.getInstance(it) }");
        GradleSettings settings2 = (GradleSettings)((Object)r);
        GradleProjectSettings gradleProjectSettings = (GradleProjectSettings)settings2.getLinkedProjectSettings(externalProjectPath);
        if (gradleProjectSettings == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleProjectSettings), (String)"settings.getLinkedProjec\u2026ojectPath) ?: return null");
        GradleProjectSettings projectSettings = gradleProjectSettings;
        String gradleJvm = projectSettings.getGradleJvm();
        SdkLookupProvider provider2 = (SdkLookupProvider)this.use(project, (Function1)new Function1<Project, SdkLookupProvider>(projectSettings){
            final /* synthetic */ GradleProjectSettings $projectSettings;

            @NotNull
            public final SdkLookupProvider invoke(@NotNull Project it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return GradleJvmResolutionUtil.getGradleJvmLookupProvider(it, this.$projectSettings);
            }
            {
                this.$projectSettings = gradleProjectSettings;
                super(1);
            }
        });
        SdkLookupProvider.SdkInfo sdkInfo2 = (SdkLookupProvider.SdkInfo)this.use(project, (Function1)new Function1<Project, SdkLookupProvider.SdkInfo>(provider2, externalProjectPath, gradleJvm){
            final /* synthetic */ SdkLookupProvider $provider;
            final /* synthetic */ String $externalProjectPath;
            final /* synthetic */ String $gradleJvm;

            @NotNull
            public final SdkLookupProvider.SdkInfo invoke(@NotNull Project it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return GradleJvmUtil.nonblockingResolveGradleJvmInfo(this.$provider, it, this.$externalProjectPath, this.$gradleJvm);
            }
            {
                this.$provider = sdkLookupProvider;
                this.$externalProjectPath = string2;
                this.$gradleJvm = string3;
                super(1);
            }
        });
        if (sdkInfo2 instanceof SdkLookupProvider.SdkInfo.Unresolved || sdkInfo2 instanceof SdkLookupProvider.SdkInfo.Resolving) {
            this.waitForGradleJvmResolving(provider2, task2, taskNotificationListener);
            sdkInfo2 = (SdkLookupProvider.SdkInfo)this.use(project, (Function1)new Function1<Project, SdkLookupProvider.SdkInfo>(provider2, externalProjectPath, gradleJvm){
                final /* synthetic */ SdkLookupProvider $provider;
                final /* synthetic */ String $externalProjectPath;
                final /* synthetic */ String $gradleJvm;

                @NotNull
                public final SdkLookupProvider.SdkInfo invoke(@NotNull Project it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return GradleJvmUtil.nonblockingResolveGradleJvmInfo(this.$provider, it, this.$externalProjectPath, this.$gradleJvm);
                }
                {
                    this.$provider = sdkLookupProvider;
                    this.$externalProjectPath = string2;
                    this.$gradleJvm = string3;
                    super(1);
                }
            });
        }
        if (!(sdkInfo2 instanceof SdkLookupProvider.SdkInfo.Resolved)) {
            throw (Throwable)this.jdkConfigurationException("gradle.jvm.is.invalid");
        }
        String string2 = ((SdkLookupProvider.SdkInfo.Resolved)sdkInfo2).getHomePath();
        if (string2 == null) {
            throw (Throwable)this.jdkConfigurationException("gradle.jvm.is.invalid");
        }
        String homePath = string2;
        this.checkForWslJdkOnWindows(homePath, externalProjectPath, task2);
        if (!JdkUtil.checkForJdk((String)homePath)) {
            if (JdkUtil.checkForJre((String)homePath)) {
                throw (Throwable)this.jdkConfigurationException("gradle.jvm.is.jre");
            }
            throw (Throwable)this.jdkConfigurationException("gradle.jvm.is.invalid");
        }
        return sdkInfo2;
    }

    private final void checkForWslJdkOnWindows(String homePath, String externalProjectPath, ExternalSystemTask task2) {
        if (WSLUtil.isSystemCompatible() && WslDistributionManager.isWslPath((String)homePath) && !WslDistributionManager.isWslPath((String)externalProjectPath)) {
            String message;
            boolean isResolveProjectTask = task2 instanceof ExternalSystemResolveProjectTask;
            String string2 = message = GradleBundle.message("gradle.incorrect.jvm.wslJdk.on.win.issue.description", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message");
            throw (Throwable)new BuildIssueException((BuildIssue)new IncorrectGradleJdkIssue(externalProjectPath, homePath, string2, isResolveProjectTask));
        }
    }

    private final TargetEnvironmentConfiguration getEnvironmentConfiguration(ExternalSystemRunConfiguration runConfiguration, Project project) {
        ExternalSystemRunConfiguration externalSystemRunConfiguration = runConfiguration;
        if (!(externalSystemRunConfiguration instanceof GradleRunConfiguration)) {
            externalSystemRunConfiguration = null;
        }
        GradleRunConfiguration gradleRunConfiguration = (GradleRunConfiguration)externalSystemRunConfiguration;
        if (gradleRunConfiguration == null) {
            return null;
        }
        GradleRunConfiguration gradleRunConfiguration2 = gradleRunConfiguration;
        String string2 = gradleRunConfiguration2.getOptions().getRemoteTarget();
        if (string2 == null) {
            return this.localEnvironment();
        }
        String targetName = string2;
        TargetEnvironmentConfiguration targetEnvironmentConfiguration = (TargetEnvironmentConfiguration)TargetEnvironmentsManager.Companion.getInstance(project).getTargets().findByName(targetName);
        if (targetEnvironmentConfiguration == null) {
            return this.localEnvironment();
        }
        return targetEnvironmentConfiguration;
    }

    private final TargetEnvironmentConfiguration localEnvironment() {
        return Registry.is((String)"gradle.tooling.use.external.process", (boolean)false) ? (TargetEnvironmentConfiguration)new TargetEnvironmentConfiguration(LOCAL_TARGET_TYPE_ID){
            @NotNull
            private String projectRootOnTarget;

            @NotNull
            public String getProjectRootOnTarget() {
                return this.projectRootOnTarget;
            }

            public void setProjectRootOnTarget(@NotNull String string2) {
                Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
                this.projectRootOnTarget = string2;
            }
            {
                this.projectRootOnTarget = "";
            }
        } : null;
    }

    private final <R> R use(Project project, Function1<? super Project, ? extends R> action2) {
        return (R)ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)new Function0<R>(project, action2){
            final /* synthetic */ Project $project;
            final /* synthetic */ Function1 $action;

            public final R invoke() {
                boolean $i$f$runWriteAction = false;
                return (R)ApplicationManager.getApplication().runWriteAction(new Computable(this){
                    final /* synthetic */ use.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final T compute() {
                        boolean bl = false;
                        boolean bl2 = this.this$0.$project.isDisposed();
                        if (bl2) {
                            throw (Throwable)new ProcessCanceledException();
                        }
                        return (T)this.this$0.$action.invoke((Object)this.this$0.$project);
                    }
                });
            }
            {
                this.$project = project;
                this.$action = function1;
                super(0);
            }
        }, (int)1, null);
    }

    private final ExternalSystemJdkException jdkConfigurationException(@PropertyKey(resourceBundle="messages.GradleBundle") String key) {
        String errorMessage = GradleBundle.message(key, new Object[0]);
        String openSettingsMessage = GradleBundle.message("gradle.open.gradle.settings", new Object[0]);
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string2 = errorMessage + " <a href='%s'>" + openSettingsMessage + "</a> \n";
        Object[] objectArray = new Object[]{"#open_external_system_settings"};
        boolean bl = false;
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
        String exceptionMessage = string3;
        return new ExternalSystemJdkException(exceptionMessage, null, new String[]{"#open_external_system_settings"});
    }

    private final Sdk waitForGradleJvmResolving(SdkLookupProvider $this$waitForGradleJvmResolving, ExternalSystemTask task2, ExternalSystemTaskNotificationListener taskNotificationListener) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isDispatchThread()) {
            log.error("Do not perform synchronous wait for sdk downloading in EDT - causes deadlock.");
            throw (Throwable)this.jdkConfigurationException("gradle.jvm.is.being.resolved.error");
        }
        ExternalSystemTaskId externalSystemTaskId = task2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)externalSystemTaskId, (String)"task.id");
        ProgressIndicator progressIndicator = this.createProgressIndicator(externalSystemTaskId, taskNotificationListener);
        ExternalSystemTaskId externalSystemTaskId2 = task2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)externalSystemTaskId2, (String)"task.id");
        this.submitProgressStarted(taskNotificationListener, externalSystemTaskId2, progressIndicator);
        $this$waitForGradleJvmResolving.onProgress(progressIndicator);
        this.onCancel(task2, (Function0<Unit>)((Function0)new Function0<Unit>(progressIndicator){
            final /* synthetic */ ProgressIndicator $progressIndicator;

            public final void invoke() {
                this.$progressIndicator.cancel();
            }
            {
                this.$progressIndicator = progressIndicator;
                super(0);
            }
        }));
        Sdk result = $this$waitForGradleJvmResolving.blockingGetSdk();
        ExternalSystemTaskId externalSystemTaskId3 = task2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)externalSystemTaskId3, (String)"task.id");
        this.submitProgressFinished(taskNotificationListener, externalSystemTaskId3, progressIndicator);
        return result;
    }

    private final void onCancel(ExternalSystemTask $this$onCancel, Function0<Unit> callback) {
        Object object = callback;
        if (object != null) {
            Function0<Unit> function0 = object;
            object = new Runnable(function0){
                private final /* synthetic */ Function0 function;
                {
                    this.function = function0;
                }

                public final /* synthetic */ void run() {
                    Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
                }
            };
        }
        Runnable runnable = ConcurrencyUtil.once((Runnable)((Runnable)object));
        Intrinsics.checkNotNullExpressionValue((Object)runnable, (String)"ConcurrencyUtil.once(callback)");
        Runnable wrappedCallback = runnable;
        ExternalSystemProgressNotificationManager progressManager = ExternalSystemProgressNotificationManager.getInstance();
        ExternalSystemTaskNotificationListenerAdapter notificationListener2 = new ExternalSystemTaskNotificationListenerAdapter(wrappedCallback, progressManager){
            final /* synthetic */ Runnable $wrappedCallback;
            final /* synthetic */ ExternalSystemProgressNotificationManager $progressManager;

            public void onCancel(@NotNull ExternalSystemTaskId id) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                this.$wrappedCallback.run();
                this.$progressManager.removeNotificationListener((ExternalSystemTaskNotificationListener)this);
            }
            {
                this.$wrappedCallback = $captured_local_variable$0;
                this.$progressManager = $captured_local_variable$1;
            }
        };
        progressManager.addNotificationListener($this$onCancel.getId(), (ExternalSystemTaskNotificationListener)notificationListener2);
        if ($this$onCancel.getState() == ExternalSystemTaskState.CANCELED || $this$onCancel.getState() == ExternalSystemTaskState.CANCELING) {
            wrappedCallback.run();
        }
    }

    private final ProgressIndicator createProgressIndicator(ExternalSystemTaskId taskId, ExternalSystemTaskNotificationListener taskNotificationListener) {
        return (ProgressIndicator)new AbstractProgressIndicatorExBase(this, taskNotificationListener, taskId){
            final /* synthetic */ LocalGradleExecutionAware this$0;
            final /* synthetic */ ExternalSystemTaskNotificationListener $taskNotificationListener;
            final /* synthetic */ ExternalSystemTaskId $taskId;

            public void setFraction(double fraction) {
                super.setFraction(fraction);
                LocalGradleExecutionAware.access$submitProgressStatus(this.this$0, this.$taskNotificationListener, this.$taskId, (ProgressIndicator)this);
            }
            {
                this.this$0 = this$0;
                this.$taskNotificationListener = $captured_local_variable$1;
                this.$taskId = $captured_local_variable$2;
            }
        };
    }

    private final void submitProgressStarted(ExternalSystemTaskNotificationListener $this$submitProgressStarted, ExternalSystemTaskId taskId, ProgressIndicator progressIndicator) {
        String string2 = progressIndicator.getText();
        if (string2 == null) {
            string2 = GradleBundle.message("gradle.jvm.is.being.resolved", new Object[0]);
        }
        String message = string2;
        StartEventImpl buildEvent = new StartEventImpl((Object)progressIndicator, (Object)taskId, System.currentTimeMillis(), message);
        ExternalSystemBuildEvent notificationEvent = new ExternalSystemBuildEvent(taskId, (BuildEvent)buildEvent);
        $this$submitProgressStarted.onStatusChange((ExternalSystemTaskNotificationEvent)notificationEvent);
    }

    private final void submitProgressFinished(ExternalSystemTaskNotificationListener $this$submitProgressFinished, ExternalSystemTaskId taskId, ProgressIndicator progressIndicator) {
        EventResult result = progressIndicator.isCanceled() ? (EventResult)new SkippedResultImpl() : (EventResult)new SuccessResultImpl();
        String string2 = progressIndicator.getText();
        if (string2 == null) {
            string2 = GradleBundle.message("gradle.jvm.has.been.resolved", new Object[0]);
        }
        String message = string2;
        FinishEventImpl buildEvent = new FinishEventImpl((Object)progressIndicator, (Object)taskId, System.currentTimeMillis(), message, result);
        ExternalSystemBuildEvent notificationEvent = new ExternalSystemBuildEvent(taskId, (BuildEvent)buildEvent);
        $this$submitProgressFinished.onStatusChange((ExternalSystemTaskNotificationEvent)notificationEvent);
    }

    private final void submitProgressStatus(ExternalSystemTaskNotificationListener $this$submitProgressStatus, ExternalSystemTaskId taskId, ProgressIndicator progressIndicator) {
        long progress = (long)(progressIndicator.getFraction() * (double)100);
        String string2 = progressIndicator.getText();
        if (string2 == null) {
            string2 = GradleBundle.message("gradle.jvm.is.being.resolved", new Object[0]);
        }
        String message = string2;
        ProgressBuildEventImpl buildEvent = new ProgressBuildEventImpl((Object)progressIndicator, (Object)taskId, System.currentTimeMillis(), message, 100L, progress, "%");
        ExternalSystemBuildEvent notificationEvent = new ExternalSystemBuildEvent(taskId, (BuildEvent)buildEvent);
        $this$submitProgressStatus.onStatusChange((ExternalSystemTaskNotificationEvent)notificationEvent);
    }

    private final File findGradleJar(File[] files) {
        if (files == null) {
            return null;
        }
        File[] fileArray = files;
        int n = fileArray.length;
        for (int j = 0; j < n; ++j) {
            File file;
            File file2 = file = fileArray[j];
            Intrinsics.checkNotNull((Object)file2);
            if (!GradleInstallationManager.GRADLE_JAR_FILE_PATTERN.matcher(file2.getName()).matches()) continue;
            return file;
        }
        if (GradleEnvironment.DEBUG_GRADLE_HOME_PROCESSING) {
            int n2;
            StringBuilder filesInfo = new StringBuilder();
            File[] fileArray2 = files;
            int n3 = fileArray2.length;
            for (n2 = 0; n2 < n3; ++n2) {
                File file;
                File file3 = file = fileArray2[n2];
                Intrinsics.checkNotNull((Object)file3);
                filesInfo.append(file3.getAbsolutePath()).append(';');
            }
            CharSequence charSequence = filesInfo;
            n2 = 0;
            if (charSequence.length() > 0) {
                filesInfo.setLength(filesInfo.length() - 1);
            }
            log.info("Gradle sdk check fails. " + "Reason: no one of the given files matches gradle JAR pattern (" + GradleInstallationManager.GRADLE_JAR_FILE_PATTERN + "). " + "Files: " + filesInfo);
        }
        return null;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LocalGradleExecutionAware.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        log = logger;
    }

    public static final /* synthetic */ void access$submitProgressStatus(LocalGradleExecutionAware $this, ExternalSystemTaskNotificationListener $this$access_u24submitProgressStatus, ExternalSystemTaskId taskId, ProgressIndicator progressIndicator) {
        $this.submitProgressStatus($this$access_u24submitProgressStatus, taskId, progressIndicator);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/LocalGradleExecutionAware$GradleEnvironmentConfigurationProvider;", "Lorg/jetbrains/plugins/gradle/service/execution/GradleServerConfigurationProvider;", "targetEnvironmentConfiguration", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "(Lcom/intellij/execution/target/TargetEnvironmentConfiguration;)V", "environmentConfiguration", "getEnvironmentConfiguration", "()Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "pathMapper", "Lcom/intellij/util/PathMapper;", "getPathMapper", "()Lcom/intellij/util/PathMapper;", "intellij.gradle.common"})
    private static final class GradleEnvironmentConfigurationProvider
    implements GradleServerConfigurationProvider {
        @NotNull
        private final TargetEnvironmentConfiguration environmentConfiguration;
        @Nullable
        private final PathMapper pathMapper;

        @NotNull
        public TargetEnvironmentConfiguration getEnvironmentConfiguration() {
            return this.environmentConfiguration;
        }

        @Nullable
        public PathMapper getPathMapper() {
            return this.pathMapper;
        }

        public GradleEnvironmentConfigurationProvider(@NotNull TargetEnvironmentConfiguration targetEnvironmentConfiguration) {
            Intrinsics.checkNotNullParameter((Object)targetEnvironmentConfiguration, (String)"targetEnvironmentConfiguration");
            this.environmentConfiguration = targetEnvironmentConfiguration;
        }

        @Override
        @Nullable
        public HostPort getServerBindingAddress(@NotNull TargetEnvironmentConfiguration targetEnvironmentConfiguration) {
            Intrinsics.checkNotNullParameter((Object)targetEnvironmentConfiguration, (String)"targetEnvironmentConfiguration");
            return GradleServerConfigurationProvider.DefaultImpls.getServerBindingAddress(this, targetEnvironmentConfiguration);
        }

        @Override
        @Nullable
        public HostPort getClientCommunicationAddress(@NotNull TargetEnvironmentConfiguration targetEnvironmentConfiguration, @NotNull HostPort gradleServerHostPort) {
            Intrinsics.checkNotNullParameter((Object)targetEnvironmentConfiguration, (String)"targetEnvironmentConfiguration");
            Intrinsics.checkNotNullParameter((Object)gradleServerHostPort, (String)"gradleServerHostPort");
            return GradleServerConfigurationProvider.DefaultImpls.getClientCommunicationAddress(this, targetEnvironmentConfiguration, gradleServerHostPort);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/LocalGradleExecutionAware$Companion;", "", "()V", "LOCAL_TARGET_TYPE_ID", "", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.gradle.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

