/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue;

import com.intellij.build.issue.BuildIssue;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\u00032\b\u0010\t\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/gradle/issue/UnresolvedDependencyIssue;", "Lcom/intellij/build/issue/BuildIssue;", "dependencyName", "", "(Ljava/lang/String;)V", "title", "getTitle", "()Ljava/lang/String;", "buildDescription", "failureMessage", "isOfflineMode", "", "offlineModeQuickFixText", "getNavigatable", "Lcom/intellij/pom/Navigatable;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.gradle.common"})
@ApiStatus.Internal
public abstract class UnresolvedDependencyIssue
implements BuildIssue {
    @NotNull
    private final String title;
    @NotNull
    public static final String offlineQuickFixId = "disable_offline_mode";
    private static final String declaringRepositoriesLink = "https://docs.gradle.org/current/userguide/declaring_repositories.html";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getTitle() {
        return this.title;
    }

    @Nullable
    public Navigatable getNavigatable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return null;
    }

    @NotNull
    public final String buildDescription(@Nullable String failureMessage, boolean isOfflineMode, @NotNull String offlineModeQuickFixText) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)offlineModeQuickFixText, (String)"offlineModeQuickFixText");
        String string3 = failureMessage;
        if (string3 != null) {
            String string4 = string3;
            boolean bl = false;
            String string5 = string4;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string2 = ((Object)StringsKt.trim((CharSequence)string5)).toString();
        } else {
            string2 = null;
        }
        StringBuilder issueDescription = new StringBuilder(string2);
        String string6 = failureMessage;
        boolean noRepositoriesDefined = string6 != null ? StringsKt.contains$default((CharSequence)string6, (CharSequence)"no repositories are defined", (boolean)false, (int)2, null) : false;
        issueDescription.append("\n\nPossible solution:\n");
        if (isOfflineMode && !noRepositoriesDefined) {
            issueDescription.append(" - <a href=\"disable_offline_mode\">" + offlineModeQuickFixText + "</a>\n");
        } else {
            issueDescription.append(" - Declare repository providing the artifact, see the documentation at https://docs.gradle.org/current/userguide/declaring_repositories.html\n");
        }
        String string7 = issueDescription.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"issueDescription.toString()");
        return string7;
    }

    public UnresolvedDependencyIssue(@NotNull String dependencyName) {
        Intrinsics.checkNotNullParameter((Object)dependencyName, (String)"dependencyName");
        this.title = "Could not resolve " + dependencyName;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/gradle/issue/UnresolvedDependencyIssue$Companion;", "", "()V", "declaringRepositoriesLink", "", "offlineQuickFixId", "intellij.gradle.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

