/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.javaee.DeploymentDescriptorsConstants;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.testFramework.IdeaTestUtil;
import com.intellij.testFramework.builders.WebModuleFixtureBuilder;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import com.intellij.testFramework.fixtures.WebModuleTestFixture;
import com.intellij.testFramework.fixtures.impl.JavaModuleFixtureBuilderImpl;
import com.intellij.testFramework.fixtures.impl.ModuleFixtureBuilderImpl;
import com.intellij.testFramework.fixtures.impl.WebModuleTestFixtureImpl;
import com.intellij.util.descriptors.ConfigFileInfoSet;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WebModuleFixtureBuilderImpl
extends JavaModuleFixtureBuilderImpl<WebModuleTestFixture>
implements WebModuleFixtureBuilder {
    private final List<Pair<String, String>> myWebRoots = new ArrayList<Pair<String, String>>();
    private String myWebXml;

    public WebModuleFixtureBuilderImpl(TestFixtureBuilder<? extends IdeaProjectTestFixture> fixtureBuilder) {
        super(StdModuleTypes.JAVA, fixtureBuilder);
    }

    @NotNull
    protected Module createModule() {
        Module module = super.createModule();
        FacetUtil.addFacet((Module)module, (FacetType)FacetTypeRegistry.getInstance().findFacetType(WebFacet.ID));
        Module module2 = module;
        if (module2 == null) {
            WebModuleFixtureBuilderImpl.$$$reportNull$$$0(0);
        }
        return module2;
    }

    @NotNull
    protected WebModuleTestFixture instantiateFixture() {
        return new WebModuleTestFixtureImpl((ModuleFixtureBuilderImpl)this);
    }

    @Override
    @NotNull
    public WebModuleFixtureBuilder addWebRoot(@NotNull String rootPath, @NotNull String relativePath) {
        if (rootPath == null) {
            WebModuleFixtureBuilderImpl.$$$reportNull$$$0(1);
        }
        if (relativePath == null) {
            WebModuleFixtureBuilderImpl.$$$reportNull$$$0(2);
        }
        this.myWebRoots.add((Pair<String, String>)Pair.create((Object)rootPath, (Object)relativePath));
        WebModuleFixtureBuilderImpl webModuleFixtureBuilderImpl = this;
        if (webModuleFixtureBuilderImpl == null) {
            WebModuleFixtureBuilderImpl.$$$reportNull$$$0(3);
        }
        return webModuleFixtureBuilderImpl;
    }

    @Override
    @NotNull
    public WebModuleFixtureBuilder setWebXml(@NotNull String path) {
        if (path == null) {
            WebModuleFixtureBuilderImpl.$$$reportNull$$$0(4);
        }
        if (this.myWebXml != null) {
            throw new IllegalStateException("Web xml is already set up to: " + this.myWebXml);
        }
        this.myWebXml = path;
        WebModuleFixtureBuilderImpl webModuleFixtureBuilderImpl = this;
        if (webModuleFixtureBuilderImpl == null) {
            WebModuleFixtureBuilderImpl.$$$reportNull$$$0(5);
        }
        return webModuleFixtureBuilderImpl;
    }

    protected void libraryCreated(Library library, Module module) {
        super.libraryCreated(library, module);
        WebFacet webFacet = WebFacet.getInstances(module).iterator().next();
        JavaeeArtifactUtil.getInstance().addLibraryToAllArtifactsContainingFacet(library, webFacet);
    }

    protected void initModule(Module module) {
        super.initModule(module);
        WebFacet webFacet = WebFacet.getInstances(module).iterator().next();
        if (this.myWebXml != null) {
            ConfigFileInfoSet descriptors = webFacet.getDescriptorsContainer().getConfiguration();
            descriptors.addConfigFile(DeploymentDescriptorsConstants.WEB_XML_META_DATA, "file://" + this.myWebXml);
        }
        for (String url : ModuleRootManager.getInstance((Module)module).getSourceRootUrls()) {
            webFacet.addWebSourceRoot(url);
        }
        for (Pair pair : this.myWebRoots) {
            String path = VfsUtilCore.pathToUrl((String)((String)pair.first));
            String relativePath = (String)pair.second;
            webFacet.addWebRoot(path, relativePath);
        }
        IdeaTestUtil.addWebJarsToModule((Module)module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/fixtures/impl/WebModuleFixtureBuilderImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createModule";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/fixtures/impl/WebModuleFixtureBuilderImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "addWebRoot";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "setWebXml";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addWebRoot";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setWebXml";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

