/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.frameworks.data.util.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.jpa.frameworks.data.util.parser.Part;
import com.intellij.jpa.frameworks.data.util.parser.PartTree;
import com.intellij.jpa.frameworks.data.util.parser.PartTreeParserContext;
import com.intellij.jpa.frameworks.data.util.parser.PartTreeParserUtil;
import com.intellij.jpa.frameworks.data.util.parser.domain.PropertyPath;
import com.intellij.jpa.frameworks.data.util.parser.domain.Sort;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnchorOwner;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public abstract class PartTreeCompletionContributor
extends CompletionContributor {
    public PartTreeCompletionContributor() {
        PsiJavaElementPattern.Capture javaFieldCapture = (PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement(PsiIdentifier.class).withParent(PsiField.class)).with((PatternCondition)new PatternCondition<PsiElement>("PartTreeCompletionContributor"){

            public boolean accepts(@NotNull PsiElement psiElement, ProcessingContext context) {
                PsiClass psiClass;
                if (psiElement == null) {
                    1.$$$reportNull$$$0(0);
                }
                return (psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class)) != null && PartTreeCompletionContributor.this.isDataRepository(psiClass);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/jpa/frameworks/data/util/completion/PartTreeCompletionContributor$1", "accepts"));
            }
        });
        PsiElementPattern.Capture<PsiElement> uastMethodCapture = new PsiElementPattern.Capture<PsiElement>(PsiElement.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                if (!(o instanceof PsiElement)) {
                    return false;
                }
                PsiElement element = (PsiElement)o;
                if (!PartTreeCompletionContributor.this.hasDataSupported(element)) {
                    return false;
                }
                UIdentifier uIdentifier = (UIdentifier)UastContextKt.toUElement((PsiElement)element, UIdentifier.class);
                if (uIdentifier == null) {
                    return false;
                }
                UElement intermediateParent = UastUtils.skipParentOfType((UElement)uIdentifier, (boolean)true, (Class[])new Class[]{UReferenceExpression.class, UTypeReferenceExpression.class});
                if (!(intermediateParent instanceof UMethod)) {
                    return false;
                }
                UTypeReferenceExpression returnTypeReference = ((UMethod)intermediateParent).getReturnTypeReference();
                if (returnTypeReference != null && UastUtils.isPsiAncestor((UElement)returnTypeReference, (UElement)uIdentifier)) {
                    return false;
                }
                PsiFile file = element.getContainingFile();
                if (file != null && file.getLanguage().is((Language)JavaLanguage.INSTANCE)) {
                    return false;
                }
                UClass uClass = (UClass)UastUtils.getParentOfType((UElement)intermediateParent, UClass.class);
                return uClass != null && PartTreeCompletionContributor.this.isDataRepository(uClass.getJavaPsi());
            }
        };
        ElementPattern psiIdentifierCapture = StandardPatterns.or((ElementPattern[])new ElementPattern[]{javaFieldCapture, uastMethodCapture});
        this.extend(CompletionType.BASIC, psiIdentifierCapture, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                Pair<PsiClass, ? extends PsiType> repositoryTypes;
                if (parameters == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    3.$$$reportNull$$$0(2);
                }
                if ((repositoryTypes = PartTreeCompletionContributor.this.getRepositoryTypes(parameters)) != null) {
                    result.addAllElements(PartTreeCompletionContributor.this.getCompletionVariants(repositoryTypes, PartTreeCompletionContributor.getPsiMemberName(parameters), result.getPrefixMatcher()));
                    result.stopHere();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/jpa/frameworks/data/util/completion/PartTreeCompletionContributor$3";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    protected abstract boolean hasDataSupported(@NotNull PsiElement var1);

    protected abstract boolean isDataRepository(@NotNull PsiClass var1);

    protected abstract Set<String> getDomainClassProperties(PsiClass var1);

    protected abstract Pair<PsiClass, ? extends PsiType> substituteRepositoryTypes(PsiClass var1);

    protected abstract Icon getLookupElementIcon();

    protected abstract PartTreeParserContext getPartTreeParserContext();

    @NotNull
    private Set<LookupElement> getCompletionVariants(@NotNull Pair<PsiClass, ? extends PsiType> typesPair, @Nullable String methodName, @NotNull PrefixMatcher matcher) {
        if (typesPair == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(0);
        }
        if (matcher == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(1);
        }
        if (methodName == null) {
            Set<LookupElement> set = Collections.emptySet();
            if (set == null) {
                PartTreeCompletionContributor.$$$reportNull$$$0(2);
            }
            return set;
        }
        String prefix = matcher.getPrefix();
        PsiClass domainClass = (PsiClass)typesPair.getFirst();
        if (domainClass == null) {
            Set<LookupElement> set = Collections.emptySet();
            if (set == null) {
                PartTreeCompletionContributor.$$$reportNull$$$0(3);
            }
            return set;
        }
        PartTree partTree = new PartTree(methodName, domainClass, this.getPartTreeParserContext());
        int offset = prefix.length();
        Position[] ranges = PartTreeCompletionContributor.getPartTreeTextRanges(partTree).toArray(new Position[1]);
        if (ranges.length == 1 && ranges[0] instanceof PartPosition) {
            return this.getSubjectVariants(domainClass, "");
        }
        for (int i = 0; i < ranges.length; ++i) {
            Position nextPosition;
            Position currentPosition = ranges[i];
            Position position = nextPosition = i + 1 < ranges.length ? ranges[i + 1] : null;
            if (currentPosition.getRange().contains(offset)) {
                return this.getPositionVariants(methodName, domainClass, currentPosition);
            }
            if (currentPosition.getRange().getEndOffset() == offset) {
                return this.getPositionEndOffsetVariants(methodName, domainClass, currentPosition, nextPosition, offset);
            }
            if (PartTreeCompletionContributor.isOffsetBetweenKnownPositions(offset, currentPosition, nextPosition)) {
                if (!(nextPosition instanceof PartPosition)) continue;
                return this.getBetweenPartCompletionVariantsElements(domainClass, PartTreeCompletionContributor.getPrefix(methodName, currentPosition.getRange().getEndOffset()), PartTreeCompletionContributor.getSuffix(methodName, nextPosition.getRange()));
            }
            if (nextPosition != null || !PartTreeCompletionContributor.isIncompleteOrderByKeyword(partTree)) continue;
            Set<LookupElement> set = this.getEmptyOrderByVariants(domainClass, PartTreeCompletionContributor.getPrefix(methodName, methodName.indexOf("OrderBy")), "");
            if (set == null) {
                PartTreeCompletionContributor.$$$reportNull$$$0(4);
            }
            return set;
        }
        Set<LookupElement> set = Collections.emptySet();
        if (set == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(5);
        }
        return set;
    }

    private static boolean isIncompleteOrderByKeyword(PartTree partTree) {
        return partTree.getOrderBySource() != null && partTree.getOrderBySource().getOrders().size() == 0;
    }

    private static boolean isOffsetBetweenKnownPositions(int offset, @NotNull Position currentPosition, @Nullable Position nextPosition) {
        if (currentPosition == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(6);
        }
        return nextPosition != null && currentPosition.getRange().getEndOffset() < offset && nextPosition.getRange().getStartOffset() > offset;
    }

    @NotNull
    private Set<LookupElement> getPositionEndOffsetVariants(@NotNull String methodName, @NotNull PsiClass domainClass, @NotNull Position currentPosition, @Nullable Position nextPosition, int offset) {
        if (methodName == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(7);
        }
        if (domainClass == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(8);
        }
        if (currentPosition == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(9);
        }
        TextRange textRange = currentPosition.getRange();
        if (currentPosition instanceof SubjectPosition) {
            if (nextPosition == null) {
                Set<LookupElement> set = this.getPropertyWithKeywordVariants(domainClass, PartTreeCompletionContributor.getPrefix(methodName, textRange.getEndOffset()), "");
                if (set == null) {
                    PartTreeCompletionContributor.$$$reportNull$$$0(10);
                }
                return set;
            }
            return this.getPositionVariants(methodName, domainClass, nextPosition);
        }
        if (currentPosition instanceof PartPosition) {
            HashSet<LookupElement> variants = new HashSet<LookupElement>();
            Set<String> propertiesWithKeywords = this.getLastPartPositionVariantsStrings(methodName, domainClass, (PartPosition)currentPosition, offset);
            variants.addAll(this.getCompletionVariants(propertiesWithKeywords, PartTreeCompletionContributor.getPrefix(methodName, textRange.getStartOffset()), PartTreeCompletionContributor.getSuffix(methodName, textRange)));
            variants.addAll(this.getOperationVariants(domainClass, PartTreeCompletionContributor.getPrefix(methodName, textRange.getEndOffset()), PartTreeCompletionContributor.getSuffix(methodName, textRange)));
            if (nextPosition == null) {
                variants.addAll(this.getEmptyOrderByVariants(domainClass, PartTreeCompletionContributor.getPrefix(methodName, textRange.getEndOffset()), PartTreeCompletionContributor.getSuffix(methodName, textRange)));
            }
            variants.addAll(this.getPropertyChainVariants((PartPosition)currentPosition, PartTreeCompletionContributor.getPrefix(methodName, textRange.getStartOffset()), PartTreeCompletionContributor.getSuffix(methodName, textRange)));
            HashSet<LookupElement> hashSet = variants;
            if (hashSet == null) {
                PartTreeCompletionContributor.$$$reportNull$$$0(11);
            }
            return hashSet;
        }
        if (currentPosition instanceof SortPosition && nextPosition == null) {
            HashSet<LookupElement> variants = new HashSet<LookupElement>();
            Sort.Order order = ((SortPosition)currentPosition).getOrder();
            if (PartTreeCompletionContributor.isSortPropertyResolved(order)) {
                variants.addAll(this.getSortVariants(domainClass, PartTreeCompletionContributor.getPrefix(methodName, textRange.getEndOffset()), ""));
            }
            variants.addAll(this.getSortVariants(domainClass, PartTreeCompletionContributor.getPrefix(methodName, textRange.getStartOffset()), ""));
            HashSet<LookupElement> hashSet = variants;
            if (hashSet == null) {
                PartTreeCompletionContributor.$$$reportNull$$$0(12);
            }
            return hashSet;
        }
        Set<LookupElement> set = Collections.emptySet();
        if (set == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(13);
        }
        return set;
    }

    @NotNull
    private Set<String> getLastPartPositionVariantsStrings(@NotNull String methodName, @NotNull PsiClass domainClass, @NotNull PartPosition currentPosition, int offset) {
        if (methodName == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(14);
        }
        if (domainClass == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(15);
        }
        if (currentPosition == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(16);
        }
        Set<String> propertiesWithKeywords = this.getAllPropertiesWithKeywords(this.getDomainClassProperties(domainClass));
        propertiesWithKeywords.remove(currentPosition.getPart().getSource());
        if (methodName.length() == offset) {
            if (methodName.endsWith("And")) {
                propertiesWithKeywords.remove("And");
            }
            if (methodName.endsWith("Or")) {
                propertiesWithKeywords.remove("Or");
            }
        }
        Set<String> set = propertiesWithKeywords;
        if (set == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(17);
        }
        return set;
    }

    private static boolean isSortPropertyResolved(Sort.Order order) {
        return order.getPropertyPath().getLeafProperty().getType() != null;
    }

    @NotNull
    private Set<LookupElement> getBetweenPartCompletionVariantsElements(@NotNull PsiClass domainClass, String prefix, String suffix) {
        if (domainClass == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(18);
        }
        return this.getCompletionVariants(PartTreeCompletionContributor.mergeTails(PartTreeCompletionContributor.getOperations(), this.getAllPropertiesWithKeywords(this.getDomainClassProperties(domainClass))), prefix, suffix);
    }

    private Set<LookupElement> getEmptyOrderByVariants(PsiClass domainClass, String prefixExpression, String suffixExpression) {
        return this.getCompletionVariants(PartTreeCompletionContributor.mergeTails(Collections.singleton("OrderBy"), this.getCapitalizedProperties(domainClass)), prefixExpression, suffixExpression);
    }

    @NotNull
    private Set<LookupElement> getCompletionVariants(@NotNull Set<String> strings, @NotNull String prefixExpression, @Nullable String suffixExpression) {
        if (strings == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(19);
        }
        if (prefixExpression == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(20);
        }
        @NotNull HashSet<LookupElement> set = new HashSet<LookupElement>();
        for (String s : strings) {
            if (StringUtil.isEmptyOrSpaces((String)s)) continue;
            set.add((LookupElement)this.createLookupElement(prefixExpression, s, ""));
            if (StringUtil.isEmptyOrSpaces((String)suffixExpression)) continue;
            set.add((LookupElement)this.createLookupElement(prefixExpression, s, suffixExpression));
        }
        HashSet<LookupElement> hashSet = set;
        if (hashSet == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(21);
        }
        return hashSet;
    }

    private Set<LookupElement> getSortVariants(PsiClass domainClass, String prefixExpression, String suffixExpression) {
        return this.getCompletionVariants(PartTreeCompletionContributor.mergeTails(this.getCapitalizedProperties(domainClass), "Asc", "Desc"), prefixExpression, suffixExpression);
    }

    @NotNull
    private Set<LookupElement> getPositionVariants(@NotNull String methodName, @NotNull PsiClass domainClass, @NotNull Position position) {
        if (methodName == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(22);
        }
        if (domainClass == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(23);
        }
        if (position == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(24);
        }
        TextRange textRange = position.getRange();
        String prefixExpression = PartTreeCompletionContributor.getPrefix(methodName, textRange.getStartOffset());
        String suffixExpression = PartTreeCompletionContributor.getSuffix(methodName, textRange);
        if (position instanceof SubjectPosition) {
            return this.getSubjectVariants(domainClass, suffixExpression);
        }
        if (position instanceof PartPosition) {
            HashSet<LookupElement> variants = new HashSet<LookupElement>();
            variants.addAll(this.getPropertyChainVariants((PartPosition)position, prefixExpression, suffixExpression));
            variants.addAll(this.getPropertyWithKeywordVariants(domainClass, prefixExpression, suffixExpression));
            HashSet<LookupElement> hashSet = variants;
            if (hashSet == null) {
                PartTreeCompletionContributor.$$$reportNull$$$0(25);
            }
            return hashSet;
        }
        if (position instanceof SortPosition) {
            Set<LookupElement> set = this.getSortVariants(domainClass, prefixExpression, suffixExpression);
            if (set == null) {
                PartTreeCompletionContributor.$$$reportNull$$$0(26);
            }
            return set;
        }
        Set<LookupElement> set = Collections.emptySet();
        if (set == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(27);
        }
        return set;
    }

    @NotNull
    private Set<LookupElement> getPropertyChainVariants(@NotNull PartPosition position, @NotNull String prefixExpression, @NotNull String suffixExpression) {
        PsiClass psiClass;
        Part part;
        PropertyPath leafProperty;
        PsiType propertyType;
        if (position == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(28);
        }
        if (prefixExpression == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(29);
        }
        if (suffixExpression == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(30);
        }
        if ((propertyType = (leafProperty = (part = position.getPart()).getProperty().getLeafProperty()).getType()) instanceof PsiClassType && (psiClass = ((PsiClassType)propertyType).resolve()) != null) {
            HashSet<String> propertyChains = new HashSet<String>();
            Set<String> capitalizedProperties = this.getCapitalizedProperties(psiClass);
            String segment = StringUtil.capitalize((String)leafProperty.getSegment());
            String propertyPrefix = StringUtil.substringBefore((String)position.getPart().getSource(), (String)segment);
            String propertySuffix = StringUtil.substringAfter((String)position.getPart().getSource(), (String)segment);
            if (propertyPrefix == null || propertySuffix == null) {
                Set<LookupElement> set = Collections.emptySet();
                if (set == null) {
                    PartTreeCompletionContributor.$$$reportNull$$$0(31);
                }
                return set;
            }
            if (propertySuffix.startsWith("_")) {
                propertySuffix = StringUtil.substringAfter((String)propertySuffix, (String)"_");
            }
            for (String s : capitalizedProperties) {
                propertyChains.add(segment + s);
                propertyChains.add(segment + "_" + s);
            }
            return this.getCompletionVariants(propertyChains, prefixExpression + propertyPrefix, propertySuffix + suffixExpression);
        }
        Set<LookupElement> set = Collections.emptySet();
        if (set == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(32);
        }
        return set;
    }

    private Set<LookupElement> getPropertyWithKeywordVariants(@NotNull PsiClass domainClass, String prefixExpression, String suffixExpression) {
        if (domainClass == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(33);
        }
        return this.getCompletionVariants(this.getAllPropertiesWithKeywords(this.getDomainClassProperties(domainClass)), prefixExpression, suffixExpression);
    }

    private Set<LookupElement> getOperationVariants(PsiClass domainClass, String prefixExpression, String suffixExpression) {
        return this.getCompletionVariants(PartTreeCompletionContributor.mergeTails(PartTreeCompletionContributor.getOperations(), this.getCapitalizedProperties(domainClass)), prefixExpression, suffixExpression);
    }

    private static String getSuffix(@NotNull String methodName, TextRange textRange) {
        if (methodName == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(34);
        }
        return methodName.substring(textRange.getEndOffset());
    }

    @NotNull
    private Set<LookupElement> getSubjectVariants(@NotNull PsiClass domainClass, @NotNull String suffixExpression) {
        if (domainClass == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(35);
        }
        if (suffixExpression == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(36);
        }
        return this.getCompletionVariants(this.getSubjectVariants(domainClass), "", suffixExpression);
    }

    @Nullable
    private Pair<PsiClass, ? extends PsiType> getRepositoryTypes(@NotNull CompletionParameters parameters) {
        UClass aClass;
        if (parameters == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(37);
        }
        if ((aClass = (UClass)UastUtils.findContaining((PsiElement)parameters.getPosition(), UClass.class)) == null) {
            return null;
        }
        return this.substituteRepositoryTypes(aClass.getJavaPsi());
    }

    @Nullable
    private static String getPsiMemberName(@NotNull CompletionParameters parameters) {
        UDeclaration declaration;
        if (parameters == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(38);
        }
        if ((declaration = (UDeclaration)UastUtils.findContaining((PsiElement)parameters.getPosition(), UDeclaration.class)) != null && "org.jetbrains.uast.kotlin.KotlinReceiverUParameter".equals(declaration.getClass().getCanonicalName())) {
            declaration = (UDeclaration)ObjectUtils.tryCast((Object)declaration.getUastParent(), UDeclaration.class);
        }
        if (declaration == null || !(declaration.getUastParent() instanceof UClass)) {
            return null;
        }
        PsiElement sourceElement = declaration.getSourcePsi();
        if (sourceElement == null) {
            return null;
        }
        PsiElement originalElement = PsiUtilCore.getOriginalElement((PsiElement)sourceElement, PsiElement.class);
        if (originalElement == null) {
            return null;
        }
        UDeclaration originalUDeclaration = (UDeclaration)UastUtils.findContaining((PsiElement)originalElement, UDeclaration.class);
        if (!(originalUDeclaration instanceof UAnchorOwner)) {
            return null;
        }
        UIdentifier identifier = ((UAnchorOwner)originalUDeclaration).getUastAnchor();
        if (identifier == null) {
            return null;
        }
        return identifier.getName();
    }

    @NotNull
    private Set<String> getAllPropertiesWithKeywords(@NotNull Set<String> properties) {
        if (properties == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(39);
        }
        HashSet<String> all = new HashSet<String>();
        for (String property : properties) {
            PartTreeCompletionContributor.addTails(all, StringUtil.capitalize((String)property), this.getPartTreeParserContext().types().getKeywords());
        }
        HashSet<String> hashSet = all;
        if (hashSet == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(40);
        }
        return hashSet;
    }

    private LookupElementBuilder createLookupElement(@NotNull String prefixExpression, @NotNull String property, @NotNull String suffixExpression) {
        if (prefixExpression == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(41);
        }
        if (property == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(42);
        }
        if (suffixExpression == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(43);
        }
        String lookupText = prefixExpression + property + suffixExpression;
        return LookupElementBuilder.create((String)lookupText).withPresentableText(property).bold().withTailText(StringUtil.isEmptyOrSpaces((String)suffixExpression) ? "" : suffixExpression, true).withIcon(this.getLookupElementIcon()).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                if (context == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    4.$$$reportNull$$$0(1);
                }
                AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(context.getEditor());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "item";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/jpa/frameworks/data/util/completion/PartTreeCompletionContributor$4";
                objectArray[2] = "handleInsert";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private Set<String> getSubjectVariants(@NotNull PsiClass domainClassName) {
        if (domainClassName == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(44);
        }
        HashSet<String> strings = new HashSet<String>();
        this.getPartTreeParserContext().queryPattern();
        String[] selectQuery = this.getSelectQueryPredicates();
        String[] query = this.getQueryPredicates();
        for (String s2 : selectQuery) {
            this.addSubjectSimpleTails(strings, s2, domainClassName);
            this.addSimpleTails(strings, s2);
        }
        for (String s2 : query) {
            this.addSubjectSimpleTails(strings, s2, domainClassName);
        }
        return strings.stream().map(s -> s + "By").collect(Collectors.toSet());
    }

    protected abstract String[] getSelectQueryPredicates();

    protected abstract String[] getQueryPredicates();

    protected abstract void addSubjectSimpleTails(Set<String> var1, String var2, @NotNull PsiClass var3);

    protected void addSimpleTails(Set<String> strings, String s) {
    }

    protected static void addTails(@NotNull Collection<String> strings, @NotNull String base, String ... tails) {
        if (strings == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(45);
        }
        if (base == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(46);
        }
        strings.add(base);
        for (String tail : tails) {
            strings.add(base + tail);
        }
    }

    private static void addTails(@NotNull Collection<String> strings, @NotNull String base, Collection<String> tails) {
        if (strings == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(47);
        }
        if (base == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(48);
        }
        strings.add(base);
        for (String tail : tails) {
            strings.add(base + tail);
        }
    }

    private Set<String> getCapitalizedProperties(@NotNull PsiClass domainClass) {
        if (domainClass == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(49);
        }
        return this.getDomainClassProperties(domainClass).stream().map(s -> StringUtil.capitalize((String)s)).collect(Collectors.toSet());
    }

    private static List<String> getOperations() {
        return Arrays.asList("And", "Or");
    }

    @NotNull
    public static List<Position> getPartTreeTextRanges(@NotNull PartTree partTree) {
        if (partTree == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(50);
        }
        LinkedList<Position> textRanges = new LinkedList<Position>();
        Pair<PartTree.Subject, TextRange> subject = PartTreeCompletionContributor.getSubject(partTree);
        if (subject != null) {
            textRanges.add(new SubjectPosition((TextRange)subject.getSecond()));
        }
        for (Map.Entry<Part, TextRange> entry : PartTreeParserUtil.getPartTextRanges(partTree).entrySet()) {
            textRanges.add(new PartPosition(entry.getValue(), entry.getKey()));
        }
        for (Map.Entry<Object, TextRange> entry : PartTreeParserUtil.getSortTextRanges(partTree).entrySet()) {
            textRanges.add(new SortPosition(entry.getValue(), (Sort.Order)entry.getKey()));
        }
        List<Position> list = textRanges.stream().sorted((o1, o2) -> Segment.BY_START_OFFSET_THEN_END_OFFSET.compare(o1.getRange(), o2.getRange())).collect(Collectors.toList());
        if (list == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(51);
        }
        return list;
    }

    @Nullable
    private static Pair<PartTree.Subject, TextRange> getSubject(PartTree partTree) {
        PartTree.Subject subject = partTree.getSubject();
        if (subject == null || StringUtil.isEmptyOrSpaces((String)subject.getExpression())) {
            return null;
        }
        return Pair.create((Object)subject, (Object)TextRange.create((int)0, (int)subject.getExpression().length()));
    }

    private static String getPrefix(String methodName, int offset) {
        return methodName.substring(0, offset);
    }

    @NotNull
    private static Set<String> mergeTails(Collection<String> base, Collection<String> tails) {
        return PartTreeCompletionContributor.mergeTails(base, ArrayUtilRt.toStringArray(tails));
    }

    @NotNull
    private static Set<String> mergeTails(Collection<String> base, String ... tails) {
        HashSet<String> strings = new HashSet<String>();
        for (String property : base) {
            PartTreeCompletionContributor.addTails(strings, property, tails);
        }
        HashSet<String> hashSet = strings;
        if (hashSet == null) {
            PartTreeCompletionContributor.$$$reportNull$$$0(52);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 40: 
            case 51: 
            case 52: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 40: 
            case 51: 
            case 52: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typesPair";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 40: 
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/frameworks/data/util/completion/PartTreeCompletionContributor";
                break;
            }
            case 6: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentPosition";
                break;
            }
            case 7: 
            case 14: 
            case 22: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 8: 
            case 15: 
            case 18: 
            case 23: 
            case 33: 
            case 35: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domainClass";
                break;
            }
            case 19: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 20: 
            case 29: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixExpression";
                break;
            }
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 30: 
            case 36: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffixExpression";
                break;
            }
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domainClassName";
                break;
            }
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/frameworks/data/util/completion/PartTreeCompletionContributor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionVariants";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPositionEndOffsetVariants";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastPartPositionVariantsStrings";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getPositionVariants";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyChainVariants";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPropertiesWithKeywords";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getPartTreeTextRanges";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeTails";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionVariants";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 40: 
            case 51: 
            case 52: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isOffsetBetweenKnownPositions";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPositionEndOffsetVariants";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLastPartPositionVariantsStrings";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getBetweenPartCompletionVariantsElements";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getPositionVariants";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyChainVariants";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyWithKeywordVariants";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getSuffix";
                break;
            }
            case 35: 
            case 36: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getSubjectVariants";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryTypes";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getPsiMemberName";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getAllPropertiesWithKeywords";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElement";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "addTails";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getCapitalizedProperties";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getPartTreeTextRanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 40: 
            case 51: 
            case 52: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class SortPosition
    extends Position {
        private final Sort.Order myOrder;

        public Sort.Order getOrder() {
            return this.myOrder;
        }

        private SortPosition(@NotNull TextRange range, Sort.Order key) {
            if (range == null) {
                SortPosition.$$$reportNull$$$0(0);
            }
            super(range);
            this.myOrder = key;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/jpa/frameworks/data/util/completion/PartTreeCompletionContributor$SortPosition", "<init>"));
        }
    }

    private static final class PartPosition
    extends Position {
        private final Part myPart;

        private PartPosition(@NotNull TextRange range, @NotNull Part part) {
            if (range == null) {
                PartPosition.$$$reportNull$$$0(0);
            }
            if (part == null) {
                PartPosition.$$$reportNull$$$0(1);
            }
            super(range);
            this.myPart = part;
        }

        public Part getPart() {
            return this.myPart;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "range";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "part";
                    break;
                }
            }
            objectArray[1] = "com/intellij/jpa/frameworks/data/util/completion/PartTreeCompletionContributor$PartPosition";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class SubjectPosition
    extends Position {
        private SubjectPosition(@NotNull TextRange range) {
            if (range == null) {
                SubjectPosition.$$$reportNull$$$0(0);
            }
            super(range);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/jpa/frameworks/data/util/completion/PartTreeCompletionContributor$SubjectPosition", "<init>"));
        }
    }

    private static class Position {
        private final TextRange myRange;

        private Position(@NotNull TextRange range) {
            if (range == null) {
                Position.$$$reportNull$$$0(0);
            }
            this.myRange = range;
        }

        public TextRange getRange() {
            return this.myRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/jpa/frameworks/data/util/completion/PartTreeCompletionContributor$Position", "<init>"));
        }
    }
}

