/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import java.util.Objects;

public final class JpaLibraryCoordinates {
    private final String groupId;
    private final String artifactId;

    public JpaLibraryCoordinates(String groupId, String artifactId) {
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getExternalSystemPrefix() {
        return JpaLibraryCoordinates.toExternalSystemPrefix(this.groupId, this.artifactId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JpaLibraryCoordinates that = (JpaLibraryCoordinates)o;
        return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId);
    }

    public static String toExternalSystemPrefix(String groupId, String artifactId) {
        return groupId + ":" + artifactId + ":";
    }
}

