/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebRoot
implements Disposable {
    private final String myRelativePath;
    private final VirtualFilePointer myVirtualFilePointer;

    public WebRoot(@NotNull String url, String relativePath) {
        if (url == null) {
            WebRoot.$$$reportNull$$$0(0);
        }
        this.myRelativePath = WebRoot.normalize(relativePath);
        this.myVirtualFilePointer = VirtualFilePointerManager.getInstance().create(url, (Disposable)this, null);
    }

    public String getRelativePath() {
        return this.myRelativePath;
    }

    public String getDirectoryUrl() {
        return this.myVirtualFilePointer.getUrl();
    }

    @NlsSafe
    public String getPresentableUrl() {
        return this.myVirtualFilePointer.getPresentableUrl();
    }

    public void dispose() {
    }

    @Nullable
    public VirtualFile getFile() {
        return (VirtualFile)ReadAction.compute(() -> ((VirtualFilePointer)this.myVirtualFilePointer).getFile());
    }

    public String getURI() {
        return this.myRelativePath;
    }

    @NotNull
    private static String normalize(String relativePath) {
        if ((relativePath = FileUtil.toCanonicalPath((String)relativePath)) == null) {
            relativePath = "";
        }
        while (StringUtil.endsWithChar((CharSequence)relativePath, (char)'/')) {
            relativePath = ((String)relativePath).substring(0, ((String)relativePath).length() - 1);
        }
        if (!StringUtil.startsWithChar((CharSequence)relativePath, (char)'/')) {
            relativePath = "/" + (String)relativePath;
        }
        String string = relativePath;
        if (string == null) {
            WebRoot.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WebRoot)) {
            return false;
        }
        WebRoot webRoot = (WebRoot)o;
        if (!Comparing.equal((Object)this.getFile(), (Object)webRoot.getFile())) {
            return false;
        }
        return Objects.equals(this.myRelativePath, webRoot.myRelativePath);
    }

    public int hashCode() {
        VirtualFile myFile = this.getFile();
        int result = myFile != null ? myFile.hashCode() : 0;
        result = 29 * result + (this.myRelativePath != null ? this.myRelativePath.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "WebRoot: ('" + (this.myVirtualFilePointer == null ? "" : this.myVirtualFilePointer.getPresentableUrl()) + "' -> '" + this.myRelativePath + "')";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/web/WebRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/web/WebRoot";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "normalize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

