/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.utils.highlighting;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.javaee.J2EEBundle;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiUtil;

public final class JavaeeHighlightingUtil {
    public static void checkClassIsInterface(ProblemsHolder holder, PsiClass aClass, boolean shouldBe) {
        if (shouldBe != aClass.isInterface()) {
            holder.registerProblem((PsiElement)aClass, JavaeeHighlightingUtil.getClassDeclarationRange(aClass), J2EEBundle.message(shouldBe ? "should.be.interface" : "should.not.be.interface", aClass.getName()), new LocalQuickFix[]{QuickFixFactory.getInstance().createMakeClassInterfaceFix(aClass, shouldBe)});
        }
    }

    public static TextRange getClassDeclarationRange(PsiClass aClass) {
        return HighlightNamesUtil.getClassDeclarationTextRange((PsiClass)aClass).shiftRight(-aClass.getTextRange().getStartOffset());
    }

    public static void checkClassModifier(ProblemsHolder holder, PsiClass aClass, @PsiModifier.ModifierConstant String modifier, boolean shouldHave) {
        PsiModifierList modifierList = aClass.getModifierList();
        if (modifierList != null && modifierList.hasModifierProperty(modifier) != shouldHave) {
            PsiElement keyword = PsiUtil.findModifierInList((PsiModifierList)modifierList, (String)modifier);
            if (keyword != null) {
                holder.registerProblem(keyword, JavaeeHighlightingUtil.getClassShouldMessage(aClass.isInterface(), shouldHave, aClass.getName(), modifier), new LocalQuickFix[]{QuickFixFactory.getInstance().createModifierListFix((PsiModifierListOwner)aClass, modifier, shouldHave, false)});
            } else {
                holder.registerProblem((PsiElement)aClass, JavaeeHighlightingUtil.getClassDeclarationRange(aClass), JavaeeHighlightingUtil.getClassShouldMessage(aClass.isInterface(), shouldHave, aClass.getName(), modifier), new LocalQuickFix[]{QuickFixFactory.getInstance().createModifierListFix((PsiModifierListOwner)aClass, modifier, shouldHave, false)});
            }
        }
    }

    @InspectionMessage
    private static String getClassShouldMessage(boolean anInterface, boolean shouldHave, String className, String modifier) {
        if (anInterface) {
            return J2EEBundle.message(shouldHave ? "interface.should.have.modifier" : "interface.should.not.have.modifier", className, modifier);
        }
        return J2EEBundle.message(shouldHave ? "class.should.have.modifier" : "class.should.not.have.modifier", className, modifier);
    }
}

