/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.utils;

import com.intellij.jam.JavaLibraryUtils;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModulePackageIndex;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public enum JavaeeType {
    JAKARTA("jakarta"),
    JAVAX("javax");

    public final String pkg;

    private JavaeeType(String pkg) {
        this.pkg = pkg;
    }

    @NotNull
    public static JavaeeType discover(@NotNull Project project) {
        if (project == null) {
            JavaeeType.$$$reportNull$$$0(0);
        }
        JavaeeType javaeeType = (JavaeeType)((Object)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            if (DumbService.isDumb((Project)project)) {
                return CachedValueProvider.Result.createSingleDependency((Object)((Object)JAVAX), (Object)DumbService.getInstance((Project)project).getModificationTracker());
            }
            return CachedValueProvider.Result.create((Object)((Object)(JavaeeType.hasJakartaPackages(project) ? JAKARTA : JAVAX)), (Object[])new Object[]{ProjectRootManager.getInstance((Project)project), DumbService.getInstance((Project)project).getModificationTracker()});
        }));
        if (javaeeType == null) {
            JavaeeType.$$$reportNull$$$0(1);
        }
        return javaeeType;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public static JavaeeType discover(@NotNull Module module) {
        if (module == null) {
            JavaeeType.$$$reportNull$$$0(2);
        }
        JavaeeType javaeeType = (JavaeeType)((Object)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            Project project = module.getProject();
            if (DumbService.isDumb((Project)project)) {
                return CachedValueProvider.Result.createSingleDependency((Object)((Object)JAVAX), (Object)DumbService.getInstance((Project)project).getModificationTracker());
            }
            return CachedValueProvider.Result.create((Object)((Object)(JavaeeType.hasJakartaPackages(module) ? JAKARTA : JAVAX)), (Object[])new Object[]{ProjectRootManager.getInstance((Project)project), DumbService.getInstance((Project)project).getModificationTracker()});
        }));
        if (javaeeType == null) {
            JavaeeType.$$$reportNull$$$0(3);
        }
        return javaeeType;
    }

    @NotNull
    public static JavaeeType discover(@NotNull Module module, @NotNull JavaeeClass hint) {
        if (module == null) {
            JavaeeType.$$$reportNull$$$0(4);
        }
        if (hint == null) {
            JavaeeType.$$$reportNull$$$0(5);
        }
        JavaeeType javaeeType = JavaLibraryUtils.hasLibraryClass((Module)module, (String)hint.jakarta()) ? JAKARTA : JAVAX;
        if (javaeeType == null) {
            JavaeeType.$$$reportNull$$$0(6);
        }
        return javaeeType;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public static JavaeeType discover(@NotNull PsiElement context) {
        if (context == null) {
            JavaeeType.$$$reportNull$$$0(7);
        }
        Project project = context.getProject();
        if (!context.isValid() || project.isDisposed() || DumbService.isDumb((Project)project)) {
            JavaeeType javaeeType = JAVAX;
            if (javaeeType == null) {
                JavaeeType.$$$reportNull$$$0(8);
            }
            return javaeeType;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        return module != null ? JavaeeType.discover(module) : JavaeeType.discover(project);
    }

    @NotNull
    public static JavaeeType discover(@NotNull PsiElement context, JavaeeClass hint) {
        if (context == null) {
            JavaeeType.$$$reportNull$$$0(9);
        }
        Project project = context.getProject();
        if (!context.isValid() || project.isDisposed() || DumbService.isDumb((Project)project)) {
            JavaeeType javaeeType = JAVAX;
            if (javaeeType == null) {
                JavaeeType.$$$reportNull$$$0(10);
            }
            return javaeeType;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        if (module != null) {
            return JavaeeType.discover(module, hint);
        }
        JavaeeType javaeeType = JavaLibraryUtils.hasLibraryClass((Project)project, (String)hint.jakarta()) ? JAKARTA : JAVAX;
        if (javaeeType == null) {
            JavaeeType.$$$reportNull$$$0(11);
        }
        return javaeeType;
    }

    private static boolean hasJakartaPackages(@NotNull Project project) {
        VirtualFile jakartaPackage;
        if (project == null) {
            JavaeeType.$$$reportNull$$$0(12);
        }
        return (jakartaPackage = (VirtualFile)PackageIndex.getInstance((Project)project).getDirsByPackageName(JavaeeType.JAKARTA.pkg, true).findFirst()) != null && JavaeeType.isInLibrary(project, jakartaPackage);
    }

    private static boolean hasJakartaPackages(@NotNull Module module) {
        VirtualFile jakartaPackage;
        if (module == null) {
            JavaeeType.$$$reportNull$$$0(13);
        }
        return (jakartaPackage = (VirtualFile)ModulePackageIndex.getInstance((Module)module).getDirsByPackageName(JavaeeType.JAKARTA.pkg, true).findFirst()) != null && JavaeeType.isInLibrary(module.getProject(), jakartaPackage);
    }

    private static boolean isInLibrary(@NotNull Project project, VirtualFile first) {
        if (project == null) {
            JavaeeType.$$$reportNull$$$0(14);
        }
        return ProjectRootManager.getInstance((Project)project).getFileIndex().isInLibrary(first);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/utils/JavaeeType";
                break;
            }
            case 2: 
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/utils/JavaeeType";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "discover";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "discover";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hasJakartaPackages";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isInLibrary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

