/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ui;

import com.intellij.icons.AllIcons;
import com.intellij.jam.JavaJamBundle;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.ui.DisposableComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.xml.ui.CommittablePanel;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public abstract class TableWithCRUDButtons
extends DisposableComponent
implements CommittablePanel {
    protected JTable myTable;
    private final JPanel myPanel;
    protected final Project myProject;

    protected TableWithCRUDButtons(Project project, boolean showNewButton, boolean showEditButton) {
        this.myProject = project;
        this.myTable = new JBTable();
        this.myPanel = ToolbarDecorator.createDecorator((JTable)this.myTable).setAddAction(showNewButton ? new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TableWithCRUDButtons.this.doNew();
            }
        } : null).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                if (TableWithCRUDButtons.this.isRemoveOk()) {
                    TableWithCRUDButtons.this.doRemove();
                }
            }
        }).setEditAction(showEditButton ? new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TableWithCRUDButtons.this.doEdit();
            }
        } : null).addExtraAction(new AnActionButton(J2EEBundle.messagePointer("action.AnActionButton.text.help", new Object[0]), AllIcons.Actions.Help){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                HelpManager.getInstance().invokeHelp(TableWithCRUDButtons.this.getHelpID());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javaee/ui/TableWithCRUDButtons$1", "actionPerformed"));
            }
        }).disableUpDownActions().createPanel();
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                TableWithCRUDButtons.this.doEdit();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javaee/ui/TableWithCRUDButtons$5", "onDoubleClick"));
            }
        }.installOn((Component)this.myTable);
        this.myTable.getSelectionModel().setSelectionMode(0);
    }

    protected boolean isRemoveOk() {
        Object o = this.getSelectedValue();
        String name = String.valueOf(o);
        return Messages.showYesNoDialog((Project)this.myProject, (String)JavaJamBundle.message((String)"confirmation.text.delete.element", (Object[])new Object[]{name}), (String)J2EEBundle.message("action.name.delete", new Object[0]), null) == 0;
    }

    public void commit() {
    }

    public final void reset() {
        this.refreshModel();
    }

    protected abstract void refreshModelImpl();

    protected void refreshModel() {
        Object selectedValue = this.getSelectedValue();
        this.refreshModelImpl();
        this.setSelection(selectedValue);
    }

    protected void setSelection(Object selectedValue) {
        int index;
        if (selectedValue != null && (index = this.indexOf(selectedValue)) >= 0) {
            this.myTable.getSelectionModel().setSelectionInterval(index, index);
        }
    }

    private int indexOf(Object selectedValue) {
        TableModel model = this.myTable.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            if (model.getValueAt(i, 0) != selectedValue) continue;
            return i;
        }
        return -1;
    }

    protected abstract void doEdit();

    protected abstract void doRemove();

    protected abstract void doNew();

    protected Object getSelectedValue() {
        int selectedRow = this.myTable.getSelectedRow();
        if (selectedRow == -1) {
            return null;
        }
        return this.myTable.getModel().getValueAt(selectedRow, 0);
    }

    @Override
    public JComponent getComponent() {
        return this.myPanel;
    }

    protected abstract String getHelpID();
}

