/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model.converters;

import com.intellij.javaee.model.xml.ResAuth;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResAuthConverter
extends ResolvingConverter<ResAuth> {
    @NonNls
    private static final String SERVLET = "SERVLET";
    @NonNls
    private static final String CONTAINER = "CONTAINER";

    private static boolean is23(ConvertContext context) {
        DomElement element = DomUtil.getFileElement((DomElement)context.getInvocationElement()).getRootElement();
        XmlTag tag = element.getXmlTag();
        if (tag != null && "web-app".equals(element.getXmlElementName()) && tag.getAttribute("version") == null) {
            String uri;
            XmlDoctype doctype;
            XmlDocument document = (XmlDocument)tag.getParent();
            XmlProlog prolog = document.getProlog();
            return prolog != null && (doctype = prolog.getDoctype()) != null && (uri = doctype.getDtdUri()) != null && uri.contains("2_3");
        }
        return true;
    }

    @NotNull
    public Collection<? extends ResAuth> getVariants(ConvertContext context) {
        List<ResAuth> list = Arrays.asList((ResAuth[])ResAuth.class.getEnumConstants());
        if (list == null) {
            ResAuthConverter.$$$reportNull$$$0(0);
        }
        return list;
    }

    public ResAuth fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (ResAuthConverter.is23(context)) {
            return ResAuth.APPLICATION.getValue().equals(s) ? ResAuth.APPLICATION : (ResAuth.CONTAINER.getValue().equals(s) ? ResAuth.CONTAINER : null);
        }
        return SERVLET.equals(s) ? ResAuth.APPLICATION : (CONTAINER.equals(s) ? ResAuth.CONTAINER : null);
    }

    public String toString(@Nullable ResAuth resAuth, ConvertContext context) {
        if (resAuth == null) {
            return null;
        }
        return ResAuthConverter.is23(context) ? resAuth.getValue() : (resAuth == ResAuth.APPLICATION ? SERVLET : CONTAINER);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/converters/ResAuthConverter", "getVariants"));
    }
}

