/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.model;

import com.intellij.javaee.constants.JavaeeAnnotationConstants;
import com.intellij.javaee.ejb.model.EjbAnnotationConstants;
import com.intellij.javaee.utils.JavaeeType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class InterceptorMethodType
extends Enum<InterceptorMethodType> {
    public static final /* enum */ InterceptorMethodType AROUND_INVOKE = new InterceptorMethodType("AroundInvoke");
    public static final /* enum */ InterceptorMethodType POST_CONSTRUCT = new InterceptorMethodType("PostConstruct");
    public static final /* enum */ InterceptorMethodType PRE_DESTROY = new InterceptorMethodType("PreDestroy");
    public static final /* enum */ InterceptorMethodType PRE_PASSIVATE = new InterceptorMethodType("PrePassivate");
    public static final /* enum */ InterceptorMethodType POST_ACTIVATE = new InterceptorMethodType("PostActivate");
    @NotNull
    private final String typeName;
    private static final /* synthetic */ InterceptorMethodType[] $VALUES;

    public static InterceptorMethodType[] values() {
        return (InterceptorMethodType[])$VALUES.clone();
    }

    public static InterceptorMethodType valueOf(String name) {
        return Enum.valueOf(InterceptorMethodType.class, name);
    }

    private InterceptorMethodType(String typeName) {
        if (typeName == null) {
            InterceptorMethodType.$$$reportNull$$$0(0);
        }
        this.typeName = typeName;
    }

    @NotNull
    public String getTypeName() {
        String string = this.typeName;
        if (string == null) {
            InterceptorMethodType.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NonNls
    public String getMethodStandardName() {
        switch (this) {
            case AROUND_INVOKE: {
                return "aroundInvoke";
            }
            case POST_ACTIVATE: {
                return "ejbActivate";
            }
            case POST_CONSTRUCT: {
                return "ejbCreate";
            }
            case PRE_DESTROY: {
                return "ejbRemove";
            }
            case PRE_PASSIVATE: {
                return "ejbPassivate";
            }
        }
        assert (false);
        return null;
    }

    @NonNls
    public String getMethodAnnotation(@NotNull JavaeeType javaeeType) {
        if (javaeeType == null) {
            InterceptorMethodType.$$$reportNull$$$0(2);
        }
        switch (this) {
            case AROUND_INVOKE: {
                return JavaeeAnnotationConstants.AROUND_INVOKE_ANNO.fqn(javaeeType);
            }
            case POST_ACTIVATE: {
                return EjbAnnotationConstants.POST_ACTIVATE_ANNO.fqn(javaeeType);
            }
            case POST_CONSTRUCT: {
                return JavaeeAnnotationConstants.POST_CONSTRUCT_ANNO.fqn(javaeeType);
            }
            case PRE_DESTROY: {
                return JavaeeAnnotationConstants.PRE_DESTROY_ANNO.fqn(javaeeType);
            }
            case PRE_PASSIVATE: {
                return EjbAnnotationConstants.PRE_PASSIVATE_ANNO.fqn(javaeeType);
            }
        }
        assert (false);
        return null;
    }

    static {
        $VALUES = new InterceptorMethodType[]{AROUND_INVOKE, POST_CONSTRUCT, PRE_DESTROY, PRE_PASSIVATE, POST_ACTIVATE};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ejb/model/InterceptorMethodType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaeeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ejb/model/InterceptorMethodType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMethodAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

