/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.deployment;

import com.intellij.javaee.appServers.run.configuration.ServerModel;
import com.intellij.javaee.deployment.ArtifactDeploymentSource;
import com.intellij.javaee.deployment.DeploymentMethod;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.javaee.deployment.JavaeeDeploymentUtil;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeploymentModel
implements JDOMExternalizable,
Cloneable {
    @NonNls
    private static final String DEPLOYMENT_METHOD_NAME = "DEPLOYMENT_METHOD";
    @NonNls
    public static final String DEPLOYMENT_SOURCE_NAME = "DEPLOYMENT_SOURCE_NAME";
    private DeploymentMethod myDeploymentMethod;
    private final CommonModel myParentConfiguration;
    private final DeploymentMethod[] myDeploymentMethods;
    private final DeploymentSource myDeploymentSource;

    protected DeploymentModel(@NotNull CommonModel parentConfiguration, ArtifactPointer artifactPointer) {
        if (parentConfiguration == null) {
            DeploymentModel.$$$reportNull$$$0(0);
        }
        this(parentConfiguration, JavaeeDeploymentUtil.getInstance().createArtifactDeploymentSource(artifactPointer));
    }

    protected DeploymentModel(CommonModel parentConfiguration, DeploymentSource deploymentSource) {
        DeploymentMethod[] availableMethods;
        this.myDeploymentMethod = null;
        this.myParentConfiguration = parentConfiguration;
        DeploymentMethod[] deploymentMethods = DeploymentMethod.EMPTY_ARRAY;
        DeploymentProvider deploymentProvider = this.myParentConfiguration.getIntegration().getDeploymentProvider(parentConfiguration.isLocal());
        if (deploymentProvider == null) {
            deploymentProvider = this.myParentConfiguration.getServerModel().getDeploymentProvider();
        }
        if (deploymentProvider != null && (availableMethods = deploymentProvider.getAvailableMethods()) != null) {
            deploymentMethods = availableMethods;
        }
        this.myDeploymentMethods = deploymentMethods;
        this.myDeploymentSource = deploymentSource;
    }

    public final DeploymentMethod @NotNull [] getAvailableMethods() {
        if (this.myDeploymentMethods == null) {
            DeploymentModel.$$$reportNull$$$0(1);
        }
        return this.myDeploymentMethods;
    }

    @Nullable
    public Artifact getArtifact() {
        return this.myDeploymentSource instanceof ArtifactDeploymentSource ? ((ArtifactDeploymentSource)this.myDeploymentSource).getArtifact() : null;
    }

    @Nullable
    public ArtifactPointer getArtifactPointer() {
        return this.myDeploymentSource instanceof ArtifactDeploymentSource ? ((ArtifactDeploymentSource)this.myDeploymentSource).getArtifactPointer() : null;
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        String methodName = element.getAttributeValue(DEPLOYMENT_METHOD_NAME);
        if (methodName != null) {
            this.setDeploymentMethod(this.findMethodByName(methodName));
        }
    }

    @Nullable
    private DeploymentMethod findMethodByName(String deplMethodName) {
        DeploymentMethod found = null;
        for (DeploymentMethod availableMethod : this.myDeploymentMethods) {
            if (!Objects.equals(availableMethod.getName(), deplMethodName)) continue;
            found = availableMethod;
        }
        return found;
    }

    public boolean shouldRedeployOnDeploymentSourceContentChange() {
        return false;
    }

    public boolean isValid() {
        return this.myDeploymentSource.isValid();
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        DeploymentMethod deploymentMethod = this.getDeploymentMethod();
        if (deploymentMethod != null) {
            element.setAttribute(DEPLOYMENT_METHOD_NAME, deploymentMethod.getName());
        }
    }

    @Nullable
    public DeploymentMethod getDeploymentMethod() {
        if (this.myDeploymentMethod == null) {
            for (DeploymentMethod method : this.myDeploymentMethods) {
                if (!method.isApplicable(this.myParentConfiguration)) continue;
                this.myDeploymentMethod = method;
                break;
            }
        }
        return this.myDeploymentMethod;
    }

    public void setDeploymentMethod(DeploymentMethod deploymentMethod) {
        this.myDeploymentMethod = deploymentMethod;
    }

    @NotNull
    public DeploymentSource getDeploymentSource() {
        DeploymentSource deploymentSource = this.myDeploymentSource;
        if (deploymentSource == null) {
            DeploymentModel.$$$reportNull$$$0(2);
        }
        return deploymentSource;
    }

    public CommonModel getCommonModel() {
        return this.myParentConfiguration;
    }

    public ServerModel getServerModel() {
        return this.myParentConfiguration.getServerModel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentConfiguration";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/deployment/DeploymentModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/deployment/DeploymentModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableMethods";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

