/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.recommenders.util;

import com.google.common.cache.CacheLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.recommenders.java.util.ArtifactRevisionId;
import com.intellij.recommenders.java.util.IModelRevisionId;
import com.intellij.recommenders.java.util.ZipFileCacheService;
import com.intellij.recommenders.models.ModelsIndex;
import com.intellij.recommenders.util.AbstractUniformPoolingModelProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObjectInfo;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 ,*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u00020\u0004:\u0002,-B)\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\u0015\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0016\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u0019H\u0016J\u0018\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 0\u001eJ(\u0010\"\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0006\u0010#\u001a\u00020\u001fJ\u0015\u0010$\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010\u001bJ\u0006\u0010%\u001a\u00020\u0019J\u001f\u0010&\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010'\u001a\u00020(H&\u00a2\u0006\u0002\u0010)J\u0015\u0010*\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010+\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010\u001bR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00000\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006."}, d2={"Lcom/intellij/recommenders/util/AbstractUniformPoolingModelProvider;", "K", "Lcom/intellij/recommenders/java/util/IModelRevisionId;", "M", "", "index", "Lcom/intellij/recommenders/models/ModelsIndex;", "zips", "Lcom/intellij/recommenders/java/util/ZipFileCacheService;", "inMaxTotal", "", "inMaxTotalPerKey", "(Lcom/intellij/recommenders/models/ModelsIndex;Lcom/intellij/recommenders/java/util/ZipFileCacheService;II)V", "borrowedModels", "Ljava/util/IdentityHashMap;", "getIndex", "()Lcom/intellij/recommenders/models/ModelsIndex;", "pool", "Lorg/apache/commons/pool2/impl/GenericKeyedObjectPool;", "getZips", "()Lcom/intellij/recommenders/java/util/ZipFileCacheService;", "acquireModel", "key", "(Lcom/intellij/recommenders/java/util/IModelRevisionId;)Ljava/lang/Object;", "activateModel", "", "model", "(Ljava/lang/Object;)V", "close", "content", "", "", "", "Lorg/apache/commons/pool2/impl/DefaultPooledObjectInfo;", "createModelsPool", "debugCacheContent", "destroyModel", "healthCheck", "loadModel", "zip", "Ljava/util/zip/ZipFile;", "(Lcom/intellij/recommenders/java/util/IModelRevisionId;Ljava/util/zip/ZipFile;)Ljava/lang/Object;", "passivateModel", "releaseModel", "Companion", "ModelsPoolFactoryMediator", "intellij.recommenders"})
public abstract class AbstractUniformPoolingModelProvider<K extends IModelRevisionId, M> {
    private final IdentityHashMap<M, K> borrowedModels;
    private final GenericKeyedObjectPool<K, M> pool;
    @NotNull
    private final ModelsIndex index;
    @NotNull
    private final ZipFileCacheService zips;
    private static final Logger log;
    @NotNull
    public static final Companion Companion;

    private final GenericKeyedObjectPool<K, M> createModelsPool(int inMaxTotal, int inMaxTotalPerKey) {
        GenericKeyedObjectPool genericKeyedObjectPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new ModelsPoolFactoryMediator());
        boolean bl = false;
        boolean bl2 = false;
        GenericKeyedObjectPool $this$apply = genericKeyedObjectPool;
        boolean bl3 = false;
        $this$apply.setMaxTotal(inMaxTotal);
        $this$apply.setMaxIdlePerKey(1);
        $this$apply.setMaxTotalPerKey(inMaxTotalPerKey);
        $this$apply.setBlockWhenExhausted(false);
        $this$apply.setTimeBetweenEvictionRunsMillis(TimeUnit.MINUTES.toMillis(5L));
        $this$apply.setMinEvictableIdleTimeMillis(TimeUnit.MINUTES.toMillis(3L));
        return genericKeyedObjectPool;
    }

    @Nullable
    public final M acquireModel(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Object object = Result.Companion;
        boolean bl = false;
        try {
            Object model;
            Result.Companion companion = Result.Companion;
            Result.Companion $this$runCatching = object;
            boolean bl2 = false;
            Object object2 = model = this.pool.borrowObject(key);
            if (object2 != null) {
                Object object3 = object2;
                boolean bl3 = false;
                boolean bl4 = false;
                Object it = object3;
                boolean bl5 = false;
                ((Map)this.borrowedModels).put(it, key);
            }
            return (M)model;
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl6 = false;
            Object object4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            object = object4;
            bl = false;
            boolean bl7 = false;
            Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                boolean bl8 = false;
                boolean bl9 = false;
                Throwable throwable4 = throwable3;
                boolean bl10 = false;
                Throwable it = throwable4;
                boolean bl11 = false;
                Throwable throwable5 = it;
                if (throwable5 instanceof CancellationException) {
                    log.debug("Loading of model for '" + key + "' canceled", it);
                } else if (throwable5 instanceof CacheLoader.InvalidCacheLoadException) {
                    log.debug("Failed to load model for '" + key + '\'', it);
                } else if (throwable5 instanceof NoSuchElementException) {
                    log.error("Could not load model for '" + key + "': Pool exhausted (unexpected). Please submit this error to ml completion team along with the following details:\n" + this.debugCacheContent(), it);
                } else {
                    log.error("Failed to load model for '" + key + '\'', it);
                }
            }
            bl = false;
            return (M)(Result.isFailure-impl((Object)object) ? null : object);
        }
    }

    @NotNull
    public final Map<String, List<DefaultPooledObjectInfo>> content() {
        Map map = this.pool.listAllObjects();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"pool.listAllObjects()");
        return MapsKt.toMap((Map)map);
    }

    /*
     * WARNING - void declaration
     */
    public final void healthCheck() {
        block2: {
            void $this$filterTo$iv$iv;
            Iterable $this$mapValuesTo$iv$iv;
            int max = this.pool.getMaxTotalPerKey();
            Map map = this.pool.listAllObjects();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"pool.listAllObjects()");
            Map $this$mapValues$iv = map;
            boolean $i$f$mapValues = false;
            Map map2 = $this$mapValues$iv;
            Object destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void $dstr$key$info;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl = false;
                Object k = it$iv$iv.getKey();
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k2 = k;
                Map map4 = map3;
                boolean bl2 = false;
                void var17_20 = $dstr$key$info;
                boolean bl3 = false;
                String string2 = (String)var17_20.getKey();
                var17_20 = $dstr$key$info;
                bl3 = false;
                List info = (List)var17_20.getValue();
                Integer n = info.size();
                map4.put(k2, n);
            }
            Iterable $this$filter$iv = destination$iv$iv.entrySet();
            boolean $i$f$filter = false;
            $this$mapValuesTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl = false;
                if (!(((Number)it.getValue()).intValue() == max)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Map.Entry entry = (Map.Entry)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (entry == null) break block2;
            Map.Entry entry3 = entry;
            boolean bl = false;
            boolean bl4 = false;
            Map.Entry it = entry3;
            boolean bl5 = false;
            log.error("Suspicious pool state detected. Found 1+ key reaching maxTotalPerKey=" + max + " limit. Please submit this to the ml completion team for further inspection:\n\n " + this.debugCacheContent());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String debugCacheContent() {
        void $this$mapIndexedTo$iv$iv;
        String string2;
        Object objects2;
        Object $this$mapIndexedTo$iv$iv2;
        List info;
        Collection collection;
        void $this$mapTo$iv$iv22;
        Map map = this.pool.listAllObjects();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"pool.listAllObjects()");
        Map $this$map$iv = map;
        boolean $i$f$map22 = false;
        Map map2 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo22 = false;
        CharSequence charSequence = $this$mapTo$iv$iv22;
        boolean bl = false;
        Iterator iterator = charSequence.entrySet().iterator();
        while (iterator.hasNext()) {
            void key;
            void $dstr$key$info;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl2 = false;
            void var13_21 = $dstr$key$info;
            boolean bl3 = false;
            String string3 = (String)var13_21.getKey();
            var13_21 = $dstr$key$info;
            bl3 = false;
            List list = info = (List)var13_21.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"info");
            Iterable $this$mapIndexed$iv2 = list;
            boolean $i$f$mapIndexed2 = false;
            Iterable iterable = $this$mapIndexed$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv2, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv2) {
                void info2;
                void index;
                int n = index$iv$iv++;
                boolean bl4 = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                DefaultPooledObjectInfo defaultPooledObjectInfo = (DefaultPooledObjectInfo)item$iv$iv2;
                int n2 = n;
                Collection collection2 = destination$iv$iv2;
                boolean bl5 = false;
                StringBuilder stringBuilder = new StringBuilder().append("\n                  object-").append((int)index).append(": ");
                void v3 = info2;
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"info");
                String string4 = StringsKt.trimIndent((String)stringBuilder.append(v3.getPooledObjectToString()).append("\n                  create-time: ").append(info2.getCreateTimeFormatted()).append("\n                  borrowed-count: ").append(info2.getBorrowedCount()).append("\n                  last-borrow-time: ").append(info2.getLastBorrowTimeFormatted()).append("\n                  last-return-time: ").append(info2.getLastReturnTimeFormatted()).append("\n                  last-return-time: ").append(info2.getPooledObjectToString()).append("\n                  last-borrow-trace: ").append(info2.getLastBorrowTrace()).append("\n        ").toString());
                collection2.add(string4);
            }
            objects2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)"\n---\n", null, null, (int)0, null, (Function1)debugCacheContent.pool.1.objects.2.INSTANCE, (int)30, null);
            string2 = (String)key + " @ " + System.identityHashCode(key) + " (" + info.size() + " objects): \n\n" + (String)objects2;
            collection.add(string2);
        }
        Iterable iterable = (List)destination$iv$iv;
        $this$map$iv = debugCacheContent.pool.2.INSTANCE;
        CharSequence $i$f$map22 = null;
        int $this$mapTo$iv$iv22 = 0;
        destination$iv$iv = null;
        CharSequence $i$f$mapTo22 = "\n\n";
        charSequence = "Cache content:\n";
        String pool2 = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)$i$f$mapTo22, (CharSequence)charSequence, (CharSequence)((Object)destination$iv$iv), (int)$this$mapTo$iv$iv22, $i$f$map22, (Function1)$this$map$iv, (int)28, null);
        Set<Map.Entry<M, K>> set = this.borrowedModels.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"borrowedModels.entries");
        Iterable $this$mapIndexed$iv = CollectionsKt.toList((Iterable)set);
        boolean $i$f$mapIndexed = false;
        destination$iv$iv = $this$mapIndexed$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Map.Entry item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void model;
            void index;
            void $dstr$model$key;
            int n = index$iv$iv++;
            boolean bl6 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            objects2 = item$iv$iv;
            int $this$mapIndexed$iv2 = n;
            collection = destination$iv$iv3;
            boolean bl7 = false;
            info = $dstr$model$key;
            boolean $i$f$mapIndexed2 = false;
            $this$mapIndexedTo$iv$iv2 = info.getKey();
            info = $dstr$model$key;
            $i$f$mapIndexed2 = false;
            IModelRevisionId key = (IModelRevisionId)info.getValue();
            String model_ = (int)index + ": " + model + " @" + System.identityHashCode(model);
            String key_ = key + " @" + System.identityHashCode(key);
            string2 = TuplesKt.to((Object)model_, (Object)key_);
            collection.add(string2);
        }
        Function1 function1 = debugCacheContent.tracking.2.INSTANCE;
        CharSequence charSequence2 = null;
        int n = 0;
        CharSequence charSequence3 = null;
        CharSequence charSequence4 = "\n";
        CharSequence charSequence5 = "model-2-key tracker:\n";
        String tracking2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv3), (CharSequence)charSequence4, (CharSequence)charSequence5, charSequence3, (int)n, charSequence2, (Function1)function1, (int)28, null);
        return pool2 + "\n\n" + tracking2;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final void releaseModel(@Nullable M model) {
        block4: {
            var2_2 = Result.Companion;
            var3_3 = false;
            try {
                var4_4 /* !! */  = Result.Companion;
                $this$runCatching = var2_2;
                $i$a$-runCatching-AbstractUniformPoolingModelProvider$releaseModel$1 = false;
                v0 /* !! */  = model;
                if (v0 /* !! */  == null) ** GOTO lbl-1000
                var7_13 = v0 /* !! */ ;
                var8_16 = false;
                var9_17 = false;
                it = var7_13;
                $i$a$-let-AbstractUniformPoolingModelProvider$releaseModel$1$1 = false;
                v0 /* !! */  = (IModelRevisionId)this.borrowedModels.remove(it);
                if (v0 /* !! */  != null) {
                    var7_13 = v0 /* !! */ ;
                    var8_16 = false;
                    var9_17 = false;
                    it = var7_13;
                    $i$a$-let-AbstractUniformPoolingModelProvider$releaseModel$1$2 = false;
                    this.pool.returnObject(it, model);
                    v1 = Unit.INSTANCE;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = null;
                }
                var5_7 = v1;
                var6_10 = false;
                var4_4 /* !! */  = Result.constructor-impl(var5_7);
            }
            catch (Throwable var5_8) {
                var6_11 = Result.Companion;
                var7_14 = false;
                var4_4 /* !! */  = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var5_8));
            }
            var2_2 = var4_4 /* !! */ ;
            var3_3 = false;
            var4_5 = false;
            v2 = Result.exceptionOrNull-impl((Object)var2_2);
            if (v2 == null) break block4;
            var4_6 = v2;
            var5_9 = false;
            var6_12 = false;
            var7_15 = var4_6;
            var8_16 = false;
            it = var7_15;
            $i$a$-onFailure-AbstractUniformPoolingModelProvider$releaseModel$2 = false;
            AbstractUniformPoolingModelProvider.log.error("Failed to return model to pool: '" + model + '\'', it);
        }
    }

    public void close() {
        block2: {
            Object object;
            Result.Companion companion = Result.Companion;
            boolean bl = false;
            try {
                object = Result.Companion;
                Result.Companion $this$runCatching = companion;
                boolean bl2 = false;
                this.pool.close();
                Unit unit = Unit.INSTANCE;
                boolean bl3 = false;
                object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable) {
                Result.Companion companion2 = Result.Companion;
                boolean bl4 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            companion = object;
            bl = false;
            boolean bl5 = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)companion);
            if (throwable == null) break block2;
            Throwable throwable2 = throwable;
            boolean bl6 = false;
            boolean bl7 = false;
            Throwable throwable3 = throwable2;
            boolean bl8 = false;
            Throwable it = throwable3;
            boolean bl9 = false;
            log.error("Failed to close model provider " + this.getClass(), it);
        }
    }

    @Nullable
    public abstract M loadModel(@NotNull K var1, @NotNull ZipFile var2) throws CancellationException;

    protected void activateModel(M model) {
    }

    protected void passivateModel(M model) {
    }

    protected void destroyModel(M model) {
    }

    @NotNull
    public final ModelsIndex getIndex() {
        return this.index;
    }

    @NotNull
    public final ZipFileCacheService getZips() {
        return this.zips;
    }

    public AbstractUniformPoolingModelProvider(@NotNull ModelsIndex index, @NotNull ZipFileCacheService zips, int inMaxTotal, int inMaxTotalPerKey) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Intrinsics.checkNotNullParameter((Object)zips, (String)"zips");
        this.index = index;
        this.zips = zips;
        this.borrowedModels = new IdentityHashMap();
        this.pool = this.createModelsPool(inMaxTotal, inMaxTotalPerKey);
    }

    public /* synthetic */ AbstractUniformPoolingModelProvider(ModelsIndex modelsIndex, ZipFileCacheService zipFileCacheService, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n = 30;
        }
        if ((n3 & 8) != 0) {
            n2 = 3;
        }
        this(modelsIndex, zipFileCacheService, n, n2);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AbstractUniformPoolingModelProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        log = logger;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00028\u00002\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010\bJ#\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00028\u00002\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010\bJ\u001b\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u00072\u0006\u0010\u0005\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000bJ#\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00028\u00002\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010\bJ#\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00028\u00002\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/recommenders/util/AbstractUniformPoolingModelProvider$ModelsPoolFactoryMediator;", "Lorg/apache/commons/pool2/KeyedPooledObjectFactory;", "(Lcom/intellij/recommenders/util/AbstractUniformPoolingModelProvider;)V", "activateObject", "", "key", "p", "Lorg/apache/commons/pool2/PooledObject;", "(Lcom/intellij/recommenders/java/util/IModelRevisionId;Lorg/apache/commons/pool2/PooledObject;)V", "destroyObject", "makeObject", "(Lcom/intellij/recommenders/java/util/IModelRevisionId;)Lorg/apache/commons/pool2/PooledObject;", "passivateObject", "validateObject", "", "(Lcom/intellij/recommenders/java/util/IModelRevisionId;Lorg/apache/commons/pool2/PooledObject;)Z", "intellij.recommenders"})
    private final class ModelsPoolFactoryMediator
    implements KeyedPooledObjectFactory<K, M> {
        @NotNull
        public PooledObject<M> makeObject(@NotNull K key) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            ArtifactRevisionId artifactRevisionId = AbstractUniformPoolingModelProvider.this.getIndex().findOne((IModelRevisionId)key);
            if (artifactRevisionId == null) {
                throw (Throwable)new CancellationException("No model archive found in index that matches '" + key + '\'');
            }
            ArtifactRevisionId modelArchiveCoordinate = artifactRevisionId;
            ZipFile zipFile = AbstractUniformPoolingModelProvider.this.getZips().get(modelArchiveCoordinate);
            if (zipFile == null) {
                throw (Throwable)new CancellationException("Could not load zip file for '" + modelArchiveCoordinate + '\'');
            }
            ZipFile modelArchiveZipFile = zipFile;
            Object m = AbstractUniformPoolingModelProvider.this.loadModel(key, modelArchiveZipFile);
            if (m == null) {
                throw (Throwable)new CancellationException("Failed to load model '" + key + "' from " + modelArchiveZipFile.getName());
            }
            Object model = m;
            DefaultPooledObject obj = new DefaultPooledObject(model);
            obj.setRequireFullStackTrace(true);
            obj.setLogAbandoned(true);
            return (PooledObject)obj;
        }

        public void destroyObject(@NotNull K key, @NotNull PooledObject<M> p) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            Intrinsics.checkNotNullParameter(p, (String)"p");
            AbstractUniformPoolingModelProvider.this.destroyModel(p.getObject());
        }

        public boolean validateObject(@NotNull K key, @NotNull PooledObject<M> p) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            Intrinsics.checkNotNullParameter(p, (String)"p");
            return true;
        }

        public void activateObject(@NotNull K key, @NotNull PooledObject<M> p) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            Intrinsics.checkNotNullParameter(p, (String)"p");
            AbstractUniformPoolingModelProvider.this.activateModel(p.getObject());
        }

        public void passivateObject(@NotNull K key, @NotNull PooledObject<M> p) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            Intrinsics.checkNotNullParameter(p, (String)"p");
            AbstractUniformPoolingModelProvider.this.passivateModel(p.getObject());
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/recommenders/util/AbstractUniformPoolingModelProvider$Companion;", "", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.recommenders"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

