/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.recommenders.python.models;

import com.intellij.recommenders.java.util.ZipFileCacheService;
import com.intellij.recommenders.models.ModelsIndex;
import com.intellij.recommenders.models.NeuralBaseModel;
import com.intellij.recommenders.python.models.PyModelCoordinate;
import com.intellij.recommenders.python.models.PyRecommenderServices;
import com.intellij.recommenders.util.AbstractUniformPoolingModelProvider;
import com.intellij.serviceContainer.NonInjectable;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/recommenders/python/models/PyModelProvider;", "Lcom/intellij/recommenders/util/AbstractUniformPoolingModelProvider;", "Lcom/intellij/recommenders/python/models/PyModelCoordinate;", "Lcom/intellij/recommenders/models/NeuralBaseModel;", "()V", "modelIndex", "Lcom/intellij/recommenders/models/ModelsIndex;", "cache", "Lcom/intellij/recommenders/java/util/ZipFileCacheService;", "(Lcom/intellij/recommenders/models/ModelsIndex;Lcom/intellij/recommenders/java/util/ZipFileCacheService;)V", "loadModel", "key", "zip", "Ljava/util/zip/ZipFile;", "intellij.recommenders.python"})
public final class PyModelProvider
extends AbstractUniformPoolingModelProvider<PyModelCoordinate, NeuralBaseModel> {
    @Override
    @Nullable
    public NeuralBaseModel loadModel(@NotNull PyModelCoordinate key, @NotNull ZipFile zip) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)zip, (String)"zip");
        String basePath = StringsKt.replace$default((String)key.getName(), (char)'.', (char)'/', (boolean)false, (int)4, null);
        ZipEntry zipEntry = zip.getEntry(basePath + "_metadata.json");
        if (zipEntry == null) {
            return null;
        }
        ZipEntry metadata = zipEntry;
        ZipEntry zipEntry2 = zip.getEntry(basePath + ".onnx");
        if (zipEntry2 == null) {
            return null;
        }
        ZipEntry onnx = zipEntry2;
        InputStream inputStream = zip.getInputStream(onnx);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"zip.getInputStream(onnx)");
        InputStream inputStream2 = zip.getInputStream(metadata);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"zip.getInputStream(metadata)");
        return NeuralBaseModel.Companion.load(inputStream, inputStream2);
    }

    @NonInjectable
    public PyModelProvider(@NotNull ModelsIndex modelIndex, @NotNull ZipFileCacheService cache) {
        Intrinsics.checkNotNullParameter((Object)modelIndex, (String)"modelIndex");
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        super(modelIndex, cache, 0, 0, 12, null);
    }

    public PyModelProvider() {
        this(PyRecommenderServices.INSTANCE.getModelsIndex(), PyRecommenderServices.INSTANCE.getZipCache());
    }
}

