/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.recommenders.python.models;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.QualifiedName;
import com.intellij.recommenders.python.models.ModelResolutionContext;
import com.intellij.recommenders.python.models.PyModelCoordinate;
import com.intellij.recommenders.python.models.PyPackageIndex;
import com.intellij.recommenders.python.models.PyPackageInfo;
import com.jetbrains.extensions.PsiFileSystemItemExtKt;
import com.jetbrains.python.codeInsight.stdlib.PyStdlibUtil;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007J*\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\u000e\u001a\u00020\u000b*\u0004\u0018\u00010\u000fH\u0002J \u0010\u0010\u001a\u0016\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0011*\u00020\u0012H\u0002J \u0010\u0010\u001a\u0016\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0011*\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/recommenders/python/models/PyModelCoordinateResolver;", "", "()V", "template", "Lcom/intellij/recommenders/python/models/PyModelCoordinate;", "resolve", "context", "Lcom/intellij/recommenders/python/models/ModelResolutionContext;", "type", "Lcom/jetbrains/python/psi/types/PyType;", "fqTypeName", "", "topLevelName", "resolveTypeName", "guessVersion", "Lcom/intellij/openapi/projectRoots/Sdk;", "parseName", "Lkotlin/Triple;", "Lcom/jetbrains/python/psi/types/PyClassType;", "Lcom/jetbrains/python/psi/types/PyModuleType;", "intellij.recommenders.python"})
public final class PyModelCoordinateResolver {
    private final PyModelCoordinate template = new PyModelCoordinate("none", "universal", "0.0.0", null, 8, null);

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final PyModelCoordinate resolve(@NotNull ModelResolutionContext context) {
        PyModelCoordinate pyModelCoordinate;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PyType type = context.get(ModelResolutionContext.Companion.getPY_TYPE());
        if (type instanceof PyClassType) {
            void typeName;
            Triple<PyClassType, String, String> triple = this.parseName((PyClassType)type);
            if (triple == null) {
                return null;
            }
            Triple<PyClassType, String, String> triple2 = triple;
            String string2 = (String)triple2.component2();
            String packageName = (String)triple2.component3();
            pyModelCoordinate = this.resolve(type, (String)typeName, packageName, context);
        } else if (type instanceof PyModuleType) {
            Triple<PyModuleType, String, String> triple = this.parseName((PyModuleType)type);
            if (triple == null) {
                return null;
            }
            Triple<PyModuleType, String, String> triple3 = triple;
            String typeName = (String)triple3.component2();
            String packageName = (String)triple3.component3();
            PyClassTypeImpl pyClassTypeImpl = PyClassTypeImpl.createTypeByQName((PsiElement)((PsiElement)((PyModuleType)type).getModule()), (String)"types.ModuleType", (boolean)false);
            pyModelCoordinate = this.resolve(pyClassTypeImpl != null ? (PyType)pyClassTypeImpl : type, typeName, packageName, context);
        } else if (type instanceof PyUnionType) {
            void typeName;
            void innerType;
            void $this$mapNotNullTo$iv$iv;
            Collection collection = ((PyUnionType)type).getMembers();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"type.members");
            Iterable $this$mapNotNull$iv = collection;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Triple<PyClassType, String, String> triple;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                PyType it = (PyType)element$iv$iv;
                boolean bl2 = false;
                PyType pyType = it;
                if ((pyType instanceof PyClassType ? this.parseName((PyClassType)it) : (pyType instanceof PyModuleType ? this.parseName((PyModuleType)it) : null)) == null) continue;
                triple = triple;
                boolean bl3 = false;
                boolean bl4 = false;
                Triple<PyClassType, String, String> it$iv$iv = triple;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Triple triple = (Triple)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (triple == null) {
                return null;
            }
            Triple triple4 = triple;
            PyType typeName2 = (PyType)triple4.component1();
            String packageName = (String)triple4.component2();
            String packageName2 = (String)triple4.component3();
            pyModelCoordinate = this.resolve((PyType)innerType, (String)typeName, packageName2, context);
        } else {
            pyModelCoordinate = type == null ? null : PyModelCoordinate.copy$default(this.template, null, null, this.resolveTypeName(type), null, 11, null);
        }
        return pyModelCoordinate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final PyModelCoordinate resolve(PyType type, String fqTypeName, String topLevelName, ModelResolutionContext context) {
        PyModelCoordinate pyModelCoordinate;
        if (type instanceof PyClassType && ((PyClassType)type).isBuiltin()) {
            pyModelCoordinate = new PyModelCoordinate(fqTypeName, "builtins", null, this.guessVersion(context.get(ModelResolutionContext.Companion.getPY_SDK())), 4, null);
            return pyModelCoordinate;
        }
        Collection collection = PyStdlibUtil.getPackages();
        if (collection != null) {
            if (collection.contains(topLevelName)) {
                pyModelCoordinate = new PyModelCoordinate(fqTypeName, "stdlib", null, this.guessVersion(context.get(ModelResolutionContext.Companion.getPY_SDK())), 4, null);
                return pyModelCoordinate;
            }
        }
        Object object = topLevelName;
        boolean bl = false;
        if (object.length() == 0) {
            pyModelCoordinate = new PyModelCoordinate(fqTypeName, "local", null, "0.0", 4, null);
            return pyModelCoordinate;
        } else {
            PyPackageIndex pyPackageIndex = context.get(ModelResolutionContext.Companion.getPY_PKG_INDEX());
            Object object2 = pyPackageIndex;
            if (pyPackageIndex == null) return null;
            Set<PyPackageInfo> set = object2.findByTopLevel(topLevelName);
            object2 = set;
            if (set == null) return null;
            PyPackageInfo pyPackageInfo = (PyPackageInfo)CollectionsKt.firstOrNull((Iterable)((Iterable)object2));
            object2 = pyPackageInfo;
            if (pyPackageInfo == null) return null;
            object = object2;
            bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            pyModelCoordinate = new PyModelCoordinate(fqTypeName, ((PyPackageInfo)it).getName(), ((PyPackageInfo)it).getVersion(), null, 8, null);
        }
        return pyModelCoordinate;
    }

    private final String guessVersion(Sdk $this$guessVersion) {
        String string2 = PythonSdkType.getLanguageLevelForSdk((Sdk)$this$guessVersion).toPythonVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"PythonSdkType.getLanguag\u2026k(this).toPythonVersion()");
        return string2;
    }

    private final Triple<PyModuleType, String, String> parseName(PyModuleType $this$parseName) {
        Triple triple;
        PyFile pyFile = $this$parseName.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)pyFile, (String)"module");
        QualifiedName qualifiedName = PsiFileSystemItemExtKt.getQName((PsiFileSystemItem)((PsiFileSystemItem)pyFile));
        boolean bl = false;
        boolean bl2 = false;
        QualifiedName it = qualifiedName;
        boolean bl3 = false;
        if (it == null) {
            triple = null;
        } else {
            String fqTypeName = it.join(".");
            String string2 = it.getFirstComponent();
            if (string2 == null) {
                string2 = "";
            }
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.firstComponent ?: \"\"");
            String topLevelName = string2;
            triple = new Triple((Object)$this$parseName, (Object)fqTypeName, (Object)topLevelName);
        }
        return triple;
    }

    private final Triple<PyClassType, String, String> parseName(PyClassType $this$parseName) {
        String string2 = $this$parseName.getClassQName();
        if (string2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"classQName ?: return null");
        String fqTypeName = string2;
        String topLevelName = StringsKt.contains$default((CharSequence)fqTypeName, (char)'.', (boolean)false, (int)2, null) ? StringsKt.substringBefore$default((String)fqTypeName, (String)".", null, (int)2, null) : "";
        return new Triple((Object)$this$parseName, (Object)fqTypeName, (Object)topLevelName);
    }

    /*
     * WARNING - void declaration
     */
    private final String resolveTypeName(PyType type) {
        String string2;
        PyType pyType = type;
        if (pyType instanceof PyClassType) {
            String string3 = ((PyClassType)type).getName();
            if (string3 == null) {
                string3 = "unnamed";
            }
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"type.name ?: \"unnamed\"");
        } else if (pyType instanceof PyUnionType) {
            void $this$mapTo$iv$iv;
            Collection collection = ((PyUnionType)type).getMembers();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"type.members");
            Iterable $this$map$iv = CollectionsKt.filterNotNull((Iterable)collection);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PyType pyType2 = (PyType)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                String string4 = this.resolveTypeName((PyType)it);
                collection2.add(string4);
            }
            string2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)), (CharSequence)"|", null, null, (int)0, null, null, (int)62, null);
        } else if (pyType instanceof PyModuleType) {
            string2 = String.valueOf(QualifiedNameFinder.findCanonicalImportPath((PsiElement)((PsiElement)((PyModuleType)type).getModule()), null));
        } else {
            String string5 = type.getClass().getSimpleName();
            string2 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"type.javaClass.simpleName");
        }
        return string2;
    }
}

