/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.recommenders.python.models;

import com.intellij.openapi.application.PathManager;
import com.intellij.recommenders.python.models.PersistentPyPackageIndexService;
import com.intellij.recommenders.python.models.PyPackageIndex;
import com.intellij.recommenders.python.models.PyPackageIndexService;
import com.intellij.recommenders.python.models.PyPackageInfo;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.io.PathKt;
import com.jetbrains.python.packaging.PyPackage;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0001\u001eB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u000f\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0002J\b\u0010\u0014\u001a\u00020\u0012H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0018\u001a\u00020\tH\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u00162\u0006\u0010\u001a\u001a\u00020\tH\u0016J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/recommenders/python/models/PersistentPyPackageIndexService;", "Lcom/intellij/recommenders/python/models/PyPackageIndex;", "Lcom/intellij/recommenders/python/models/PyPackageIndexService;", "()V", "location", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "byPackageNameIndex", "", "", "Lcom/intellij/recommenders/python/models/PyPackageInfo;", "byTopLevelIndex", "", "modified", "", "packageInfos", "", "addToIndices", "", "info", "dispose", "findAll", "", "findByPackageName", "packageName", "findByTopLevel", "topLevel", "register", "aPackage", "Lcom/jetbrains/python/packaging/PyPackage;", "Companion", "intellij.recommenders.python"})
public final class PersistentPyPackageIndexService
implements PyPackageIndex,
PyPackageIndexService {
    private final List<PyPackageInfo> packageInfos;
    private final Map<String, Set<PyPackageInfo>> byTopLevelIndex;
    private final Map<String, PyPackageInfo> byPackageNameIndex;
    private boolean modified;
    private final Path location;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final void addToIndices(PyPackageInfo info) {
        this.byPackageNameIndex.put(info.getName(), info);
        Iterable $this$forEach$iv = info.getTopLevels();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String topLevel = (String)element$iv;
            boolean bl = false;
            this.byTopLevelIndex.computeIfAbsent(topLevel, addToIndices.1.1.INSTANCE).add(info);
        }
    }

    @Override
    @NotNull
    public Set<PyPackageInfo> findAll() {
        return CollectionsKt.toSet((Iterable)this.packageInfos);
    }

    @Override
    @NotNull
    public Set<PyPackageInfo> findByTopLevel(@NotNull String topLevel) {
        Intrinsics.checkNotNullParameter((Object)topLevel, (String)"topLevel");
        Set set = this.byTopLevelIndex.get(topLevel);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    @Override
    @Nullable
    public PyPackageInfo findByPackageName(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return this.byPackageNameIndex.get(packageName);
    }

    /*
     * WARNING - void declaration
     */
    public void dispose() {
        if (this.modified) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Path path = this.location;
            Object[] objectArray = new LinkOption[]{};
            boolean bl = false;
            if (!Files.exists(path, Arrays.copyOf(objectArray, objectArray.length))) {
                Path path2 = this.location.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"location.parent");
                path = path2;
                objectArray = new FileAttribute[]{};
                bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path, (FileAttribute[])Arrays.copyOf(objectArray, objectArray.length)), (String)"Files.createDirectories(this, *attributes)");
            }
            Iterable $this$sortedBy$iv = this.packageInfos;
            boolean $i$f$sortedBy = false;
            bl = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    PyPackageInfo it = (PyPackageInfo)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (PyPackageInfo)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string2 = it.getName();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string2)));
                }
            });
            Path path3 = this.location;
            boolean $i$f$map = false;
            void var3_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PyPackageInfo pyPackageInfo = (PyPackageInfo)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                StringFormat $this$encodeToString$iv = (StringFormat)Json.Default;
                boolean $i$f$encodeToString = false;
                SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
                boolean $i$f$serializer = false;
                KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(PyPackageInfo.class));
                boolean $i$f$cast = false;
                KSerializer kSerializer = $this$cast$iv$iv$iv;
                if (kSerializer == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlinx.serialization.KSerializer<T>");
                }
                String string2 = $this$encodeToString$iv.encodeToString((SerializationStrategy)kSerializer, (Object)it);
                collection.add(string2);
            }
            collection = (List)destination$iv$iv;
            Files.write(path3, (Iterable<? extends CharSequence>)collection, StandardOpenOption.CREATE);
        }
    }

    @Override
    @NotNull
    public PyPackageInfo register(@NotNull PyPackage aPackage) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)aPackage, (String)"aPackage");
        PyPackageInfo pyPackageInfo = this.byPackageNameIndex.get(aPackage.getName());
        if (pyPackageInfo != null) {
            PyPackageInfo pyPackageInfo2 = pyPackageInfo;
            boolean bl = false;
            boolean bl2 = false;
            PyPackageInfo it = pyPackageInfo2;
            boolean bl3 = false;
            return it;
        }
        String string2 = aPackage.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"aPackage.name");
        String packageNameOnDisk = StringsKt.replace$default((String)string2, (char)'-', (char)'_', (boolean)false, (int)4, null);
        Path distInfoTopLevelFile = Path.of(aPackage.getLocation(), packageNameOnDisk + '-' + aPackage.getVersion() + ".dist-info", "top_level.txt");
        Path eggInfoTopLevelFile = Path.of(aPackage.getLocation(), packageNameOnDisk + '-' + aPackage.getVersion() + ".egg-info", "top_level.txt");
        Path path = distInfoTopLevelFile;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"distInfoTopLevelFile");
        Object object = path;
        Object object2 = new LinkOption[]{};
        boolean bl = false;
        if (Files.exists((Path)object, Arrays.copyOf(object2, ((LinkOption[])object2).length))) {
            object = distInfoTopLevelFile;
            object2 = Charsets.UTF_8;
            bl = false;
            List<String> list = Files.readAllLines((Path)object, (Charset)object2);
            Intrinsics.checkNotNullExpressionValue(list, (String)"Files.readAllLines(this, charset)");
            set = CollectionsKt.toSet((Iterable)list);
        } else {
            Path path2 = eggInfoTopLevelFile;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"eggInfoTopLevelFile");
            object = path2;
            object2 = new LinkOption[]{};
            bl = false;
            if (Files.exists((Path)object, Arrays.copyOf(object2, ((LinkOption[])object2).length))) {
                object = eggInfoTopLevelFile;
                object2 = Charsets.UTF_8;
                bl = false;
                List<String> list = Files.readAllLines((Path)object, (Charset)object2);
                Intrinsics.checkNotNullExpressionValue(list, (String)"Files.readAllLines(this, charset)");
                set = CollectionsKt.toSet((Iterable)list);
            } else {
                set = SetsKt.setOf((Object)StringsKt.substringBefore$default((String)packageNameOnDisk, (char)'.', null, (int)2, null));
            }
        }
        Set topLevels = set;
        String string3 = aPackage.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"aPackage.name");
        String string4 = aPackage.getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"aPackage.version");
        object = topLevels;
        object2 = string4;
        object = new PyPackageInfo(string3, (Set<String>)object, (String)object2);
        boolean bl4 = false;
        bl = false;
        Object $this$apply = object;
        boolean bl5 = false;
        this.modified = true;
        this.packageInfos.add((PyPackageInfo)$this$apply);
        this.addToIndices((PyPackageInfo)$this$apply);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NonInjectable
    public PersistentPyPackageIndexService(@NotNull Path location2) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        this.location = location2;
        boolean bl = false;
        this.packageInfos = new ArrayList();
        bl = false;
        this.byTopLevelIndex = new LinkedHashMap();
        bl = false;
        this.byPackageNameIndex = new LinkedHashMap();
        if (PathKt.isFile((Path)this.location)) {
            void $this$forEach$iv;
            Iterable $this$mapTo$iv;
            Json json2 = JsonKt.Json$default(null, (Function1)json.1.INSTANCE, (int)1, null);
            Iterable<Path> iterable = this.location;
            Object object = Charsets.UTF_8;
            boolean bl2 = false;
            List<String> list = Files.readAllLines(iterable, (Charset)object);
            Intrinsics.checkNotNullExpressionValue(list, (String)"Files.readAllLines(this, charset)");
            iterable = list;
            Collection destination$iv = this.packageInfos;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                String string2 = (String)item$iv;
                Collection collection = destination$iv;
                boolean bl3 = false;
                StringFormat $this$decodeFromString$iv = (StringFormat)json2;
                boolean $i$f$decodeFromString = false;
                SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
                boolean $i$f$serializer = false;
                KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(PyPackageInfo.class));
                boolean $i$f$cast = false;
                KSerializer kSerializer = $this$cast$iv$iv$iv;
                if (kSerializer == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlinx.serialization.KSerializer<T>");
                }
                PyPackageInfo pyPackageInfo = (PyPackageInfo)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)kSerializer, (String)it);
                collection.add(pyPackageInfo);
            }
            $this$mapTo$iv = destination$iv;
            object = this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PyPackageInfo p1 = (PyPackageInfo)element$iv;
                boolean bl4 = false;
                ((PersistentPyPackageIndexService)object).addToIndices(p1);
            }
        }
    }

    public PersistentPyPackageIndexService() {
        Path path = PersistentPyPackageIndexService.Companion.defaultIndexFile();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"defaultIndexFile()");
        this(path);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004H\u0002\u00a8\u0006\u0006"}, d2={"Lcom/intellij/recommenders/python/models/PersistentPyPackageIndexService$Companion;", "", "()V", "defaultIndexFile", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "intellij.recommenders.python"})
    public static final class Companion {
        private final Path defaultIndexFile() {
            return Path.of(PathManager.getSystemPath(), "recommenders-python", "packages.json.txt");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

