/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.recommenders.models;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.intellij.recommenders.java.util.ArtifactRevisionId;
import com.intellij.recommenders.java.util.IModelRevisionId;
import com.intellij.recommenders.java.util.IModuleRevisionId;
import com.intellij.recommenders.java.util.ModelRevisionId;
import com.intellij.recommenders.models.ModelProvider;
import com.intellij.recommenders.models.ModelsIndex;
import com.intellij.recommenders.models.ModelsRepository;
import com.intellij.recommenders.models.ZipBasedModelProvider;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u0000 \u001c*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004:\u0001\u001cB\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0017\u0010\u0013\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u001f\u0010\u0018\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u0010H$\u00a2\u0006\u0002\u0010\u001aJ\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u000eH\u0002RQ\u0010\f\u001aB\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00100\u0010 \u000f* \u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00100\u0010\u0018\u00010\r0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/recommenders/models/ZipBasedModelProvider;", "K", "Lcom/intellij/recommenders/java/util/IModuleRevisionId;", "M", "Lcom/intellij/recommenders/models/ModelProvider;", "repository", "Lcom/intellij/recommenders/models/ModelsRepository;", "modelsIndex", "Lcom/intellij/recommenders/models/ModelsIndex;", "modelType", "", "(Lcom/intellij/recommenders/models/ModelsRepository;Lcom/intellij/recommenders/models/ModelsIndex;Ljava/lang/String;)V", "fileSystemCache", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "Lcom/intellij/recommenders/java/util/ArtifactRevisionId;", "kotlin.jvm.PlatformType", "Ljava/nio/file/FileSystem;", "getFileSystemCache", "()Lcom/github/benmanes/caffeine/cache/LoadingCache;", "acquireModel", "key", "(Lcom/intellij/recommenders/java/util/IModuleRevisionId;)Ljava/lang/Object;", "close", "", "loadModel", "fileSystem", "(Lcom/intellij/recommenders/java/util/IModuleRevisionId;Ljava/nio/file/FileSystem;)Ljava/lang/Object;", "openZipFile", "Companion", "intellij.recommenders"})
public abstract class ZipBasedModelProvider<K extends IModuleRevisionId, M>
implements ModelProvider<K, M> {
    private final LoadingCache<ArtifactRevisionId, FileSystem> fileSystemCache;
    private final ModelsRepository repository;
    private final ModelsIndex modelsIndex;
    private final String modelType;
    private static final Logger log;
    private static final int CACHE_SIZE = 10;
    @NotNull
    public static final Companion Companion;

    public final LoadingCache<ArtifactRevisionId, FileSystem> getFileSystemCache() {
        return this.fileSystemCache;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final FileSystem openZipFile(ArtifactRevisionId key) {
        void location2;
        Pair<Path, Promise<Path>> pair = this.repository.getAndRefresh(key);
        Path path = (Path)pair.component1();
        Promise promise = (Promise)pair.component2();
        promise.onSuccess(new Consumer(this, (Path)location2, key){
            final /* synthetic */ ZipBasedModelProvider this$0;
            final /* synthetic */ Path $location;
            final /* synthetic */ ArtifactRevisionId $key;

            public final void accept(@Nullable Path newLocation) {
                if (Intrinsics.areEqual((Object)newLocation, (Object)this.$location) ^ true) {
                    this.this$0.getFileSystemCache().invalidate((Object)this.$key);
                }
            }
            {
                this.this$0 = zipBasedModelProvider;
                this.$location = path;
                this.$key = artifactRevisionId;
            }
        });
        void v0 = location2;
        URI uRI = v0;
        if (v0 == null) return null;
        void var4_3 = uRI;
        boolean bl = false;
        boolean bl2 = false;
        URI it = var4_3;
        boolean bl3 = false;
        URI uRI2 = URI.create("jar:" + it.toUri());
        uRI = uRI2;
        if (uRI2 == null) return null;
        URI uRI3 = uRI;
        bl = false;
        bl2 = false;
        it = uRI3;
        boolean bl4 = false;
        boolean bl5 = false;
        FileSystem fileSystem = FileSystems.newFileSystem(it, MapsKt.emptyMap());
        return fileSystem;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public M acquireModel(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        boolean bl = !StringsKt.endsWith$default((String)key.getRevision(), (String)"-SNAPSHOT", (boolean)false, (int)2, null);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "revision " + key.getRevision() + " must not end with -SNAPSHOT.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        Object object = Result.Companion;
        bl2 = false;
        try {
            M m;
            Result.Companion companion = Result.Companion;
            Result.Companion $this$runCatching = object;
            boolean bl5 = false;
            Object object2 = ModelRevisionId.Companion.of(key.getGroup(), key.getModule(), this.modelType, key.getRevision());
            boolean bl6 = false;
            boolean bl7 = false;
            Object it = object2;
            boolean bl8 = false;
            Object object3 = this.modelsIndex.findOne((IModelRevisionId)it);
            if (object3 != null) {
                object2 = object3;
                bl6 = false;
                bl7 = false;
                it = object2;
                boolean bl9 = false;
                object3 = (FileSystem)this.fileSystemCache.get(it);
                if (object3 != null) {
                    object2 = object3;
                    bl6 = false;
                    bl7 = false;
                    it = object2;
                    boolean bl10 = false;
                    Object object4 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"it");
                    m = this.loadModel(key, (FileSystem)object4);
                    return m;
                }
            }
            m = null;
            return m;
        }
        catch (Throwable throwable) {
            Object object5;
            Result.Companion companion = Result.Companion;
            boolean bl11 = false;
            Object object6 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            object = object6;
            bl2 = false;
            boolean bl12 = false;
            Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                boolean bl13 = false;
                boolean bl14 = false;
                Throwable throwable4 = throwable3;
                boolean bl15 = false;
                Throwable it = throwable4;
                boolean bl16 = false;
                if (it instanceof UncheckedExecutionException && it.getCause() instanceof IllegalStateException) {
                    log.debug("Unchecked exception during load model " + key, it);
                } else {
                    log.error("Failed to load model " + key, it);
                }
            }
            bl2 = false;
            if (Result.isFailure-impl((Object)object)) {
                object5 = null;
                return (M)object5;
            }
            object5 = object;
            return (M)object5;
        }
    }

    @Nullable
    protected abstract M loadModel(@NotNull K var1, @NotNull FileSystem var2);

    @Override
    public void close() {
        this.fileSystemCache.invalidateAll();
        this.fileSystemCache.cleanUp();
    }

    public ZipBasedModelProvider(@NotNull ModelsRepository repository, @NotNull ModelsIndex modelsIndex, @NotNull String modelType) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)modelsIndex, (String)"modelsIndex");
        Intrinsics.checkNotNullParameter((Object)modelType, (String)"modelType");
        this.repository = repository;
        this.modelsIndex = modelsIndex;
        this.modelType = modelType;
        Function1 function1 = (Function1)new Function1<ArtifactRevisionId, FileSystem>(this){

            @Nullable
            public final FileSystem invoke(@NotNull ArtifactRevisionId p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ZipBasedModelProvider.access$openZipFile((ZipBasedModelProvider)this.receiver, p1);
            }
        };
        this.fileSystemCache = Caffeine.newBuilder().maximumSize((long)10).expireAfterAccess(1L, TimeUnit.MINUTES).removalListener((RemovalListener)fileSystemCache.1.INSTANCE).build(new CacheLoader(function1){
            private final /* synthetic */ Function1 function;
            {
                this.function = function1;
            }

            public final /* synthetic */ Object load(Object p0) {
                return this.function.invoke(p0);
            }
        });
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(ZipBasedModelProvider.class);
    }

    public static final /* synthetic */ FileSystem access$openZipFile(ZipBasedModelProvider $this, ArtifactRevisionId key) {
        return $this.openZipFile(key);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/recommenders/models/ZipBasedModelProvider$Companion;", "", "()V", "CACHE_SIZE", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "intellij.recommenders"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

