/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.recommenders.models;

import com.intellij.recommenders.java.util.ArtifactRevisionId;
import com.intellij.recommenders.models.AetherUtils;
import com.intellij.recommenders.models.DownloadCallback;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.impl.RepositoryConnectorProvider;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.ResolutionErrorPolicy;
import org.eclipse.aether.resolution.VersionRequest;
import org.eclipse.aether.resolution.VersionResult;
import org.eclipse.aether.spi.connector.ArtifactDownload;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.spi.log.LoggerFactory;
import org.eclipse.aether.spi.log.NullLoggerFactory;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.SimpleArtifactDescriptorPolicy;
import org.eclipse.aether.util.repository.SimpleResolutionErrorPolicy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AetherClient {
    private static final Logger LOG = org.slf4j.LoggerFactory.getLogger(AetherClient.class);
    private final RepositorySystem system;
    private final RepositorySystemSession defaultSession;
    private final RemoteRepository defaultRemoteRepo;
    private final Map<ArtifactRevisionId, Optional<File>> inProgressResolutions = new HashMap<ArtifactRevisionId, Optional<File>>();
    private Authentication authentication;
    private Proxy proxy;
    @Nullable
    private RepositoryConnectorProvider repositoryConnectorProvider;

    public AetherClient(File basedir, String remoteUrl) {
        this.system = this.createRepositorySystem();
        this.defaultSession = this.createDefaultSession(basedir);
        this.defaultRemoteRepo = AetherUtils.createRemoteRepository("models", remoteUrl);
    }

    private RepositorySystemSession createDefaultSession(File basedir) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository(basedir);
        session.setLocalRepositoryManager(this.system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        session.setArtifactDescriptorPolicy((ArtifactDescriptorPolicy)new SimpleArtifactDescriptorPolicy(1));
        session.setChecksumPolicy("fail");
        session.setConfigProperty("aether.connector.persistedChecksums", (Object)false);
        session.setConfigProperty("aether.connector.requestTimeout", (Object)TimeUnit.MILLISECONDS.convert(45L, TimeUnit.SECONDS));
        session.setConfigProperty("aether.artifactResolver.snapshotNormalization", (Object)false);
        session.setConfigProperty("aether.versionResolver.noCache", (Object)true);
        session.setConfigProperty("aether.updateCheckManager.sessionState", (Object)"bypass");
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<File> getLocation(ArtifactRevisionId mc) {
        Map<ArtifactRevisionId, Optional<File>> map = this.inProgressResolutions;
        synchronized (map) {
            if (this.inProgressResolutions.containsKey(mc)) {
                return this.inProgressResolutions.get(mc);
            }
            RepositorySystemSession offlineSession = this.newOfflineSession();
            return this.resolveInternal(mc, offlineSession);
        }
    }

    public Optional<File> resolve(ArtifactRevisionId mc, boolean force) {
        return this.resolve(mc, force, DownloadCallback.NULL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<File> resolve(ArtifactRevisionId mc, boolean force, DownloadCallback callback) {
        Object object = this.inProgressResolutions;
        synchronized (object) {
            RepositorySystemSession offlineSession = this.newOfflineSession();
            Optional<File> previousFile = this.resolveInternal(mc, offlineSession);
            this.inProgressResolutions.put(mc, previousFile);
        }
        try {
            object = this;
            synchronized (object) {
                DefaultRepositorySystemSession onlineSession = this.newOnlineSession(callback, force);
                Optional<File> optional = this.resolveInternal(mc, (RepositorySystemSession)onlineSession);
                return optional;
            }
        }
        finally {
            Map<ArtifactRevisionId, Optional<File>> map = this.inProgressResolutions;
            synchronized (map) {
                this.inProgressResolutions.remove(mc);
            }
        }
    }

    private Optional<File> resolveInternal(ArtifactRevisionId mc, RepositorySystemSession session) {
        Artifact coord = AetherClient.toSnapshotArtifact(mc);
        RemoteRepository.Builder remoteRepoBuilder = new RemoteRepository.Builder(this.defaultRemoteRepo).setProxy(this.proxy);
        if (this.authentication != null) {
            remoteRepoBuilder.setAuthentication(this.authentication);
        }
        RemoteRepository remoteRepo = remoteRepoBuilder.build();
        try {
            ArtifactRequest request = new ArtifactRequest(coord, Collections.singletonList(remoteRepo), null);
            ArtifactResult result = this.system.resolveArtifact(session, request);
            return Optional.of(result.getArtifact().getFile());
        }
        catch (ArtifactResolutionException e) {
            if (!session.isOffline()) {
                LOG.warn("Failed to download '" + mc + "' from " + remoteRepo, (Throwable)e);
            }
            return Optional.empty();
        }
    }

    private RepositorySystemSession newOfflineSession() {
        DefaultRepositorySystemSession offlineSession = new DefaultRepositorySystemSession(this.defaultSession);
        offlineSession.setOffline(true);
        return offlineSession;
    }

    private DefaultRepositorySystemSession newOnlineSession(final DownloadCallback callback, boolean forceDownloads) {
        DefaultRepositorySystemSession onlineSession = new DefaultRepositorySystemSession(this.defaultSession);
        if (forceDownloads) {
            onlineSession.setUpdatePolicy("always");
            onlineSession.setResolutionErrorPolicy((ResolutionErrorPolicy)new SimpleResolutionErrorPolicy(0));
        } else {
            onlineSession.setUpdatePolicy("interval:" + TimeUnit.HOURS.toMinutes(1L));
            onlineSession.setResolutionErrorPolicy((ResolutionErrorPolicy)new SimpleResolutionErrorPolicy(3));
        }
        onlineSession.setTransferListener(new TransferListener(){

            public void transferInitiated(TransferEvent e) {
                callback.downloadInitiated(e.getResource().getResourceName());
            }

            public void transferStarted(TransferEvent e) {
                callback.downloadStarted(e.getResource().getResourceName());
            }

            public void transferProgressed(TransferEvent e) {
                callback.downloadProgressed(e.getResource().getResourceName(), e.getTransferredBytes(), e.getResource().getContentLength());
            }

            public void transferSucceeded(TransferEvent e) {
                callback.downloadSucceeded(e.getResource().getResourceName());
            }

            public void transferFailed(TransferEvent e) {
                callback.downloadFailed(e.getResource().getResourceName());
            }

            public void transferCorrupted(TransferEvent e) {
                callback.downloadCorrupted(e.getResource().getResourceName());
            }
        });
        return onlineSession;
    }

    public void setProxy(String type, String host, int port, String user, String pass) {
        Authentication proxyAuthentication = new AuthenticationBuilder().addUsername(user).addPassword(pass).build();
        this.proxy = type == null ? null : new Proxy(type, host, port, proxyAuthentication);
    }

    public void unsetProxy() {
        this.proxy = null;
    }

    public void setAuthentication(String username, String password) {
        this.authentication = new AuthenticationBuilder().addUsername(username).addPassword(password).build();
    }

    public String toString() {
        return this.defaultSession.getLocalRepository().getBasedir().toString();
    }

    public void deploy(@NotNull ArtifactRevisionId coordinate, @NotNull Path location2) {
        if (coordinate == null) {
            AetherClient.$$$reportNull$$$0(0);
        }
        if (location2 == null) {
            AetherClient.$$$reportNull$$$0(1);
        }
        DeployRequest request = new DeployRequest();
        request.setRepository(this.defaultRemoteRepo);
        DefaultArtifact artifact = new DefaultArtifact(coordinate.getGroup(), coordinate.getModule(), coordinate.getType(), coordinate.getExt(), coordinate.getRevision());
        request.addArtifact(artifact.setFile(location2.toFile()));
        try {
            this.system.deploy(this.defaultSession, request);
        }
        catch (DeploymentException e) {
            throw new RuntimeException("deployment failed", e);
        }
    }

    public boolean exists(@NotNull ArtifactRevisionId artifactId) {
        if (artifactId == null) {
            AetherClient.$$$reportNull$$$0(2);
        }
        Objects.requireNonNull(this.repositoryConnectorProvider, "RepositoryConnectorProvider is not yet initialized");
        try {
            DefaultArtifact artifact = new DefaultArtifact(artifactId.getGroup(), artifactId.getModule(), artifactId.getType(), artifactId.getExt(), artifactId.getRevision());
            VersionResult versionResult = this.system.resolveVersion(this.defaultSession, new VersionRequest((Artifact)artifact, Collections.singletonList(this.defaultRemoteRepo), "ctx"));
            ArtifactDownload request = new ArtifactDownload(artifact.setVersion(versionResult.getVersion()), "ctx", new File(""), null).setExistenceCheck(true);
            RepositoryConnector connector = this.repositoryConnectorProvider.newRepositoryConnector(this.defaultSession, this.defaultRemoteRepo);
            connector.get(Collections.singletonList(request), Collections.emptyList());
            connector.close();
            return !(request.getException() instanceof ArtifactNotFoundException);
        }
        catch (Exception e) {
            throw new RuntimeException("Existence check for " + artifactId + " failed", e);
        }
    }

    private RepositorySystem createRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.setService(LoggerFactory.class, NullLoggerFactory.class);
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        this.repositoryConnectorProvider = (RepositoryConnectorProvider)locator.getService(RepositoryConnectorProvider.class);
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    private static Artifact toSnapshotArtifact(ArtifactRevisionId mc) {
        return new DefaultArtifact(mc.getGroup(), mc.getModule(), mc.getType(), mc.getExt(), mc.getRevision() + "-SNAPSHOT");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coordinate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/recommenders/models/AetherClient";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "deploy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "exists";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

