/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.recommenders.java.util;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.recommenders.java.util.ArtifactRevisionId;
import com.intellij.recommenders.java.util.ZipFileCache;
import com.intellij.recommenders.models.ModelsRepository;
import com.intellij.serviceContainer.NonInjectable;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0001 B\u0017\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0016J$\u0010\u0014\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u001aJ\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001c\u001a\u00020\u0010H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u0010H\u0016J\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0010H\u0002R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/recommenders/java/util/ZipFileCacheService;", "Lcom/intellij/recommenders/java/util/ZipFileCache;", "Ljava/io/Closeable;", "repository", "Lcom/intellij/recommenders/models/ModelsRepository;", "emptyModelPath", "", "(Lcom/intellij/recommenders/models/ModelsRepository;Ljava/lang/String;)V", "NOT_FOUND", "Ljava/io/File;", "getNOT_FOUND", "()Ljava/io/File;", "NOT_FOUND$delegate", "Lkotlin/Lazy;", "openFiles", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "Lcom/intellij/recommenders/java/util/ArtifactRevisionId;", "Ljava/util/zip/ZipFile;", "close", "", "closeZipFile", "key", "value", "removalCause", "Lcom/github/benmanes/caffeine/cache/RemovalCause;", "content", "", "get", "coordinate", "isPresent", "", "openZipFile", "Companion", "intellij.recommenders"})
public abstract class ZipFileCacheService
implements ZipFileCache,
Closeable {
    private final LoadingCache<ArtifactRevisionId, ZipFile> openFiles;
    private final Lazy NOT_FOUND$delegate;
    private final ModelsRepository repository;
    private final String emptyModelPath;
    private static final Logger log;
    @NotNull
    public static final Companion Companion;

    private final File getNOT_FOUND() {
        Lazy lazy = this.NOT_FOUND$delegate;
        ZipFileCacheService zipFileCacheService = this;
        Object var3_3 = null;
        boolean bl = false;
        return (File)lazy.getValue();
    }

    private final void closeZipFile(ArtifactRevisionId key, ZipFile value, RemovalCause removalCause) {
        block0: {
            ZipFile zipFile = value;
            log.trace("Removing " + key + ", reason: " + removalCause + ", location: " + (zipFile != null ? zipFile.getName() : null));
            ZipFile zipFile2 = value;
            if (zipFile2 == null) break block0;
            zipFile2.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ZipFile openZipFile(ArtifactRevisionId key) {
        ZipFile zipFile;
        void location2;
        Pair<Path, Promise<Path>> pair = this.repository.getAndRefresh(key);
        Path path = (Path)pair.component1();
        Promise promise = (Promise)pair.component2();
        promise.onSuccess(new Consumer(this, (Path)location2, key){
            final /* synthetic */ ZipFileCacheService this$0;
            final /* synthetic */ Path $location;
            final /* synthetic */ ArtifactRevisionId $key;

            public final void accept(@Nullable Path newLocation) {
                if (Intrinsics.areEqual((Object)newLocation, (Object)this.$location) ^ true) {
                    ZipFileCacheService.access$getOpenFiles$p(this.this$0).invalidate((Object)this.$key);
                }
            }
            {
                this.this$0 = zipFileCacheService;
                this.$location = path;
                this.$key = artifactRevisionId;
            }
        });
        if (location2 != null) {
            log.trace("Opening " + key + ", location: " + location2);
            zipFile = new ZipFile(location2.toFile());
        } else {
            log.trace("Opening " + key + " failed, reason: NOT_FOUND");
            zipFile = new ZipFile(this.getNOT_FOUND());
        }
        return zipFile;
    }

    @Override
    @Nullable
    public ZipFile get(@NotNull ArtifactRevisionId coordinate) {
        Intrinsics.checkNotNullParameter((Object)coordinate, (String)"coordinate");
        try {
            return (ZipFile)this.openFiles.get((Object)coordinate);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public boolean isPresent(@NotNull ArtifactRevisionId coordinate) {
        Intrinsics.checkNotNullParameter((Object)coordinate, (String)"coordinate");
        return this.openFiles.getIfPresent((Object)coordinate) != null;
    }

    @NotNull
    public final Map<ArtifactRevisionId, ZipFile> content() {
        ConcurrentMap concurrentMap = this.openFiles.asMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"openFiles.asMap()");
        return concurrentMap;
    }

    @Override
    public void close() {
        this.openFiles.invalidateAll();
    }

    @NonInjectable
    public ZipFileCacheService(@NotNull ModelsRepository repository, @NotNull String emptyModelPath) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)emptyModelPath, (String)"emptyModelPath");
        this.repository = repository;
        this.emptyModelPath = emptyModelPath;
        Function3 function3 = (Function3)new Function3<ArtifactRevisionId, ZipFile, RemovalCause, Unit>(this){

            public final void invoke(@Nullable ArtifactRevisionId p1, @Nullable ZipFile p2, @NotNull RemovalCause p3) {
                Intrinsics.checkNotNullParameter((Object)p3, (String)"p3");
                ZipFileCacheService.access$closeZipFile((ZipFileCacheService)this.receiver, p1, p2, p3);
            }
        };
        RemovalListener removalListener = new RemovalListener(function3){
            private final /* synthetic */ Function3 function;
            {
                this.function = function3;
            }

            public final /* synthetic */ void onRemoval(Object p0, Object p1, RemovalCause p2) {
                Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(p0, p1, (Object)p2), (String)"invoke(...)");
            }
        };
        function3 = (Function1)new Function1<ArtifactRevisionId, ZipFile>(this){

            @NotNull
            public final ZipFile invoke(@NotNull ArtifactRevisionId p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ZipFileCacheService.access$openZipFile((ZipFileCacheService)this.receiver, p1);
            }
        };
        LoadingCache loadingCache = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).maximumSize(30L).removalListener(removalListener).build(new CacheLoader((Function1)function3){
            private final /* synthetic */ Function1 function;
            {
                this.function = function1;
            }

            public final /* synthetic */ Object load(Object p0) {
                return this.function.invoke(p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"Caffeine.newBuilder()\n  \u2026.build(this::openZipFile)");
        this.openFiles = loadingCache;
        this.NOT_FOUND$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ ZipFileCacheService this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @NotNull
            public final File invoke() {
                void var1_1;
                File location2 = new File(PathManager.getSystemPath(), ZipFileCacheService.access$getEmptyModelPath$p(this.this$0));
                if (!location2.exists()) {
                    Closeable closeable = new ZipOutputStream(new FileOutputStream(location2));
                    boolean bl = false;
                    boolean bl2 = false;
                    Throwable throwable = null;
                    try {
                        ZipOutputStream it = (ZipOutputStream)closeable;
                        boolean bl3 = false;
                        it.putNextEntry(new ZipEntry("/"));
                        it.closeEntry();
                        it.close();
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                return var1_1;
            }
            {
                this.this$0 = zipFileCacheService;
                super(0);
            }
        }));
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ZipFileCacheService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        log = logger;
    }

    public static final /* synthetic */ LoadingCache access$getOpenFiles$p(ZipFileCacheService $this) {
        return $this.openFiles;
    }

    public static final /* synthetic */ void access$closeZipFile(ZipFileCacheService $this, ArtifactRevisionId key, ZipFile value, RemovalCause removalCause) {
        $this.closeZipFile(key, value, removalCause);
    }

    public static final /* synthetic */ ZipFile access$openZipFile(ZipFileCacheService $this, ArtifactRevisionId key) {
        return $this.openZipFile(key);
    }

    public static final /* synthetic */ String access$getEmptyModelPath$p(ZipFileCacheService $this) {
        return $this.emptyModelPath;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/recommenders/java/util/ZipFileCacheService$Companion;", "", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.recommenders"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

