/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.recommenders.java.resolver;

import com.intellij.recommenders.java.resolver.ModuleRevisionIdResolver;
import com.intellij.recommenders.java.util.ModuleRevisionId;
import com.intellij.util.io.PathKt;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/recommenders/java/resolver/ByMavenPomPropertiesResolver;", "Lcom/intellij/recommenders/java/resolver/ModuleRevisionIdResolver;", "()V", "POM_PROPERTIES_FILE_REGEX", "Lkotlin/text/Regex;", "isPomPropertiesFile", "", "it", "Ljava/nio/file/Path;", "suggest", "Lcom/intellij/recommenders/java/util/ModuleRevisionId;", "root", "toModuleRevisionId", "pomProperties", "Ljava/util/Properties;", "toPropertiesFile", "intellij.recommenders.java"})
public final class ByMavenPomPropertiesResolver
implements ModuleRevisionIdResolver {
    private final Regex POM_PROPERTIES_FILE_REGEX = new Regex(".*/META-INF/maven/.*/.*/pom.properties");

    @Override
    @Nullable
    public ModuleRevisionId suggest(@NotNull Path root) {
        Path metaInfFolder;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Path path = metaInfFolder = root.resolve("META-INF/");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"metaInfFolder");
        if (!PathKt.exists((Path)path)) {
            return null;
        }
        Stream stream = Files.walk(metaInfFolder, new FileVisitOption[0]).filter(new Predicate(this){
            final /* synthetic */ ByMavenPomPropertiesResolver this$0;

            public final boolean test(Path it) {
                Path path = it;
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it");
                return ByMavenPomPropertiesResolver.access$isPomPropertiesFile(this.this$0, path);
            }
            {
                this.this$0 = byMavenPomPropertiesResolver;
            }
        }).map(new Function(this){
            final /* synthetic */ ByMavenPomPropertiesResolver this$0;

            public final Properties apply(Path it) {
                Path path = it;
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it");
                return ByMavenPomPropertiesResolver.access$toPropertiesFile(this.this$0, path);
            }
            {
                this.this$0 = byMavenPomPropertiesResolver;
            }
        }).map(new Function(this){
            final /* synthetic */ ByMavenPomPropertiesResolver this$0;

            @Nullable
            public final ModuleRevisionId apply(Properties it) {
                Properties properties = it;
                Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"it");
                return ByMavenPomPropertiesResolver.access$toModuleRevisionId(this.this$0, properties);
            }
            {
                this.this$0 = byMavenPomPropertiesResolver;
            }
        }).distinct();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"Files.walk(metaInfFolder\u2026d(it) }\n      .distinct()");
        List candidates2 = CollectionsKt.filterNotNull((Iterable)StreamsKt.toList(stream));
        return (ModuleRevisionId)CollectionsKt.singleOrNull((List)candidates2);
    }

    private final Properties toPropertiesFile(Path it) {
        Properties properties = new Properties();
        boolean bl = false;
        boolean bl2 = false;
        Properties $this$apply = properties;
        boolean bl3 = false;
        $this$apply.load(PathKt.inputStream((Path)it));
        return properties;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isPomPropertiesFile(Path it) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CollectionsKt.toSet((Iterable)it);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            Path path = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it2.toString();
            collection.add(string2);
        }
        return ((List)destination$iv$iv).containsAll(CollectionsKt.listOf((Object[])new String[]{"META-INF", "maven", "pom.properties"}));
    }

    private final ModuleRevisionId toModuleRevisionId(Properties pomProperties) {
        String groupId = pomProperties.getProperty("groupId");
        String artifactId = pomProperties.getProperty("artifactId");
        String version = pomProperties.getProperty("version");
        return groupId == null || artifactId == null || version == null ? null : ModuleRevisionId.Companion.of(groupId, artifactId, version);
    }

    public static final /* synthetic */ boolean access$isPomPropertiesFile(ByMavenPomPropertiesResolver $this, Path it) {
        return $this.isPomPropertiesFile(it);
    }

    public static final /* synthetic */ Properties access$toPropertiesFile(ByMavenPomPropertiesResolver $this, Path it) {
        return $this.toPropertiesFile(it);
    }

    public static final /* synthetic */ ModuleRevisionId access$toModuleRevisionId(ByMavenPomPropertiesResolver $this, Properties pomProperties) {
        return $this.toModuleRevisionId(pomProperties);
    }
}

