/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.recommenders.java.engines;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.recommenders.java.engines.JavaModelKey;
import com.intellij.recommenders.java.engines.JavaServices;
import com.intellij.recommenders.java.engines.StaticsModelProvider;
import com.intellij.recommenders.java.util.CompletionOnAny;
import com.intellij.recommenders.java.util.IModelRevisionId;
import com.intellij.recommenders.java.util.PsiUtils;
import com.intellij.recommenders.java.util.ResolvedTypeName;
import com.intellij.recommenders.java.util.Settings;
import com.intellij.serviceContainer.NonInjectable;
import com.jetbrains.recommenders.java.commons.Recommendation;
import com.jetbrains.recommenders.java.commons.names.IFieldName;
import com.jetbrains.recommenders.java.commons.names.IMemberName;
import com.jetbrains.recommenders.java.commons.names.IMethodName;
import com.jetbrains.recommenders.java.commons.names.ITypeName;
import com.jetbrains.recommenders.java.commons.names.SimpleName;
import com.jetbrains.recommenders.java.commons.names.VmMethodName;
import com.jetbrains.recommenders.java.models.StaticsModel3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\"\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\"\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/recommenders/java/engines/StaticsRecommender;", "", "()V", "modelProvider", "Lcom/intellij/recommenders/java/engines/StaticsModelProvider;", "(Lcom/intellij/recommenders/java/engines/StaticsModelProvider;)V", "evaluate", "", "Lcom/jetbrains/recommenders/java/commons/Recommendation;", "Lcom/jetbrains/recommenders/java/commons/names/SimpleName;", "receiverType", "Lcom/intellij/psi/PsiType;", "context", "Lcom/intellij/recommenders/java/util/CompletionOnAny;", "receiver", "Lcom/intellij/recommenders/java/util/ResolvedTypeName;", "intellij.recommenders.java"})
public final class StaticsRecommender {
    private final StaticsModelProvider modelProvider;

    @NotNull
    public final List<Recommendation<SimpleName>> evaluate(@NotNull PsiType receiverType2, @NotNull CompletionOnAny context) {
        List<Recommendation<SimpleName>> list;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)receiverType2, (String)"receiverType");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                list = PsiUtils.INSTANCE.toResolvedType(receiverType2);
                if (list == null) break block2;
                ResolvedTypeName resolvedTypeName = list;
                boolean bl = false;
                boolean bl2 = false;
                ResolvedTypeName it = resolvedTypeName;
                boolean bl3 = false;
                list = this.evaluate(it, context);
                if (list != null) break block3;
            }
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<Recommendation<SimpleName>> evaluate(@NotNull ResolvedTypeName receiver, @NotNull CompletionOnAny context) {
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            List list;
            JavaModelKey key = new JavaModelKey(receiver.getName(), receiver.getGroup(), receiver.getModule(), receiver.getRevision(), "java-statics-v3");
            this.modelProvider.healthCheck();
            StaticsModel3 staticsModel3 = (StaticsModel3)this.modelProvider.acquireModel((IModelRevisionId)key);
            if (staticsModel3 != null) {
                List list2;
                StaticsModel3 staticsModel32 = staticsModel3;
                boolean bl = false;
                boolean bl2 = false;
                StaticsModel3 it = staticsModel32;
                boolean bl3 = false;
                try {
                    void $this$filterTo$iv$iv;
                    Iterable $this$filterIsInstanceTo$iv$iv;
                    Iterable $this$filterIsInstance$iv;
                    Set<IMemberName> usedMembers = context.getStaticMembersReferencedInEnclosingMethod();
                    ITypeName iTypeName = receiver.getName();
                    PsiMethod psiMethod = context.getEnclosingMethod();
                    if (psiMethod == null || (psiMethod = PsiUtils.INSTANCE.toMethodName(psiMethod)) == null) {
                        psiMethod = VmMethodName.NULL;
                    }
                    Iterable iterable = usedMembers;
                    PsiMethod psiMethod2 = psiMethod;
                    ITypeName iTypeName2 = iTypeName;
                    StaticsModel3 staticsModel33 = it;
                    boolean $i$f$filterIsInstance = false;
                    void var17_21 = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof IMethodName)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Collection collection = (List)destination$iv$iv;
                    $this$filterIsInstance$iv = usedMembers;
                    collection = CollectionsKt.toSet((Iterable)collection);
                    $i$f$filterIsInstance = false;
                    $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof IFieldName)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List list3 = (List)destination$iv$iv;
                    Set set = SetsKt.emptySet();
                    Set set2 = SetsKt.emptySet();
                    Set set3 = CollectionsKt.toSet((Iterable)list3);
                    Collection collection2 = collection;
                    PsiMethod psiMethod3 = psiMethod2;
                    ITypeName iTypeName3 = iTypeName2;
                    staticsModel33.setQuery(new StaticsModel3.StaticsQuery(iTypeName3, (IMethodName)psiMethod3, (Set)collection2, set3, set2, set));
                    Iterable $this$filter$iv = it.recommend();
                    boolean $i$f$filter = false;
                    $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        Recommendation it2 = (Recommendation)element$iv$iv;
                        boolean bl4 = false;
                        if (!(it2.getProbability().getValue() > Settings.INSTANCE.getMinProbabilityThreshold())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list2 = (List)destination$iv$iv;
                }
                finally {
                    this.modelProvider.releaseModel(it);
                }
                list = list2;
            } else {
                boolean bl = false;
                list = CollectionsKt.emptyList();
            }
            return list;
        }
        catch (ProcessCanceledException e) {
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(StaticsRecommender.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.warn("An exception occurred during completion context analysis", (Throwable)e);
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
    }

    @NonInjectable
    public StaticsRecommender(@NotNull StaticsModelProvider modelProvider) {
        Intrinsics.checkNotNullParameter((Object)modelProvider, (String)"modelProvider");
        this.modelProvider = modelProvider;
    }

    public StaticsRecommender() {
        this(new StaticsModelProvider(JavaServices.getZipCache(), JavaServices.getModelsIndex()));
    }
}

