/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.recommenders.java.engines;

import com.intellij.recommenders.java.engines.JavaModelKey;
import com.intellij.recommenders.java.util.ZipFileCacheService;
import com.intellij.recommenders.models.ModelsIndex;
import com.intellij.recommenders.util.AbstractUniformPoolingModelProvider;
import com.jetbrains.recommenders.java.commons.IInstanceModel;
import com.jetbrains.recommenders.java.commons.names.ITypeName;
import com.jetbrains.recommenders.java.models.BayesInstanceModel;
import com.jetbrains.recommenders.java.models.ModelUtils;
import java.io.Closeable;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/recommenders/java/engines/InstancesModelProvider;", "Lcom/intellij/recommenders/util/AbstractUniformPoolingModelProvider;", "Lcom/intellij/recommenders/java/engines/JavaModelKey;", "Lcom/jetbrains/recommenders/java/commons/IInstanceModel;", "Ljava/io/Closeable;", "modelArchives", "Lcom/intellij/recommenders/java/util/ZipFileCacheService;", "modelsIndex", "Lcom/intellij/recommenders/models/ModelsIndex;", "(Lcom/intellij/recommenders/java/util/ZipFileCacheService;Lcom/intellij/recommenders/models/ModelsIndex;)V", "loadModel", "key", "zip", "Ljava/util/zip/ZipFile;", "intellij.recommenders.java"})
public final class InstancesModelProvider
extends AbstractUniformPoolingModelProvider<JavaModelKey, IInstanceModel>
implements Closeable {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public IInstanceModel loadModel(@NotNull JavaModelKey key, @NotNull ZipFile zip) {
        IInstanceModel iInstanceModel;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)zip, (String)"zip");
        String path = key.getName().getPackage() + '/' + key.getName().getClassName() + ".jbif";
        ZipEntry zipEntry = zip.getEntry(path);
        if (zipEntry == null) {
            return BayesInstanceModel.Companion.empty(key.getName());
        }
        ZipEntry entry = zipEntry;
        Closeable closeable = zip.getInputStream(entry);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl3 = false;
            ITypeName iTypeName = key.getName();
            InputStream inputStream = it;
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"it");
            iInstanceModel = BayesInstanceModel.Companion.of(iTypeName, ModelUtils.load((InputStream)inputStream));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return iInstanceModel;
    }

    public InstancesModelProvider(@NotNull ZipFileCacheService modelArchives, @NotNull ModelsIndex modelsIndex) {
        Intrinsics.checkNotNullParameter((Object)modelArchives, (String)"modelArchives");
        Intrinsics.checkNotNullParameter((Object)modelsIndex, (String)"modelsIndex");
        super(modelsIndex, modelArchives, 0, 0, 12, null);
    }
}

