/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.workspaceModel.performanceTesting.command;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.ModuleManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import com.jetbrains.workspaceModel.performanceTesting.extension.StringExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\r"}, d2={"Lcom/jetbrains/workspaceModel/performanceTesting/command/RemoveModuleCommand;", "Lcom/intellij/openapi/ui/playback/commands/AbstractCommand;", "text", "", "line", "", "(Ljava/lang/String;I)V", "_execute", "Lorg/jetbrains/concurrency/Promise;", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "Companion", "intellij.workspaceModel.performanceTesting"})
public final class RemoveModuleCommand
extends AbstractCommand {
    @NotNull
    public static final String PREFIX = "%removeModule";
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ActionCallback actionCallback = (ActionCallback)new ActionCallbackProfilerStopper();
        String string = this.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
        String moduleName = StringExtensionsKt.extractCommandArgument(string, PREFIX);
        ApplicationManager.getApplication().invokeLater(new Runnable(context, moduleName, actionCallback){
            final /* synthetic */ PlaybackContext $context;
            final /* synthetic */ String $moduleName;
            final /* synthetic */ ActionCallback $actionCallback;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                int n;
                void $this$filterTo$iv$iv;
                ModuleManager moduleManger;
                ModuleManager moduleManager = moduleManger = ModuleManagerEx.getInstance((Project)this.$context.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"moduleManger");
                Module[] modules = moduleManager.getModules();
                Intrinsics.checkNotNullExpressionValue((Object)modules, (String)"modules");
                Module[] $this$filter$iv = modules;
                boolean $i$f$filter2 = false;
                Module[] moduleArray = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                void var9_12 = $this$filterTo$iv$iv;
                int n2 = ((void)var9_12).length;
                for (n = 0; n < n2; ++n) {
                    void element$iv$iv;
                    void it = element$iv$iv = var9_12[n];
                    boolean bl = false;
                    void v1 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                    if (!Intrinsics.areEqual((Object)v1.getName(), (Object)this.$moduleName)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List matchedModulesByName = (List)destination$iv$iv;
                if (matchedModulesByName.size() != 1) {
                    Collection<String> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Module[] $i$f$filter2 = modules;
                    StringBuilder stringBuilder = new StringBuilder().append("Expected only 1 module for deletion (").append(this.$moduleName).append("), but got ").append(matchedModulesByName.size()).append(". ").append("All modules: ");
                    boolean $i$f$map = false;
                    destination$iv$iv = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>(((void)$this$map$iv).length);
                    boolean $i$f$mapTo = false;
                    void var10_15 = $this$mapTo$iv$iv;
                    n = ((void)var10_15).length;
                    for (int i = 0; i < n; ++i) {
                        void it;
                        void item$iv$iv;
                        void bl = item$iv$iv = var10_15[i];
                        collection = destination$iv$iv2;
                        boolean bl2 = false;
                        StringBuilder stringBuilder2 = new StringBuilder().append("Name: ");
                        void v3 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
                        String string = stringBuilder2.append(v3.getName()).append(" File: ").append(it.getModuleFilePath()).toString();
                        collection.add(string);
                    }
                    collection = (List)destination$iv$iv2;
                    String errorMessage = stringBuilder.append(collection).toString();
                    this.$actionCallback.reject(errorMessage);
                    return;
                }
                try {
                    moduleManger.disposeModule((Module)CollectionsKt.first((List)matchedModulesByName));
                }
                catch (Exception e) {
                    this.$actionCallback.reject("Removing module " + this.$moduleName + " finished unsuccessfully");
                    return;
                }
                this.$actionCallback.setDone();
            }
            {
                this.$context = playbackContext;
                this.$moduleName = string;
                this.$actionCallback = actionCallback;
            }
        });
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    public RemoveModuleCommand(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(RemoveModuleCommand.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Remov\u2026oduleCommand::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/workspaceModel/performanceTesting/command/RemoveModuleCommand$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PREFIX", "", "intellij.workspaceModel.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

