/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml.xmlbeans;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.javaee.UriUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.ws.common.CommonWsUtils;
import com.intellij.ws.common.InvokeExternalCodeUtil;
import com.intellij.ws.common.engines.LibraryDescriptor;
import com.intellij.ws.common.engines.LibraryInfo;
import com.intellij.ws.xml.WSBundle;
import com.intellij.ws.xml.WebServicesPluginSettings;
import com.intellij.ws.xml.WsJavaExternalProcessHandler;
import com.intellij.ws.xml.engines.ExternalEngine;
import com.intellij.ws.xml.utils.LibUtils;
import java.io.File;
import java.util.LinkedList;
import org.jetbrains.annotations.Nullable;

public class XmlBeansMappingEngine
implements ExternalEngine {
    private static final String XML_BEANS_LIBRARY_NAME = "XmlBeans";
    private static final String XML_BEANS_RT_LIBRARY_NAME = "XmlBeans Runtime";
    public static final String XML_BEANS_2_ENGINE = "XmlBeans 2";
    static final Logger LOG = Logger.getInstance((String)"webservicesplugin.xmlbeans.java");

    @Override
    public String getName() {
        return XML_BEANS_2_ENGINE;
    }

    @Override
    public LibraryDescriptor[] getLibraryDescriptors(String bindingType, boolean isForGeneratedCode) {
        Object commonXmlBeansPrefix = LibUtils.accessingLibraryJarsFromPluginBundledLibs(this.getBasePath()) ? "" : "lib" + File.separator;
        Object[] commonJars = new String[]{(String)commonXmlBeansPrefix + "xbean.jar", (String)commonXmlBeansPrefix + "jsr173_1.0_api.jar", (String)commonXmlBeansPrefix + "resolver.jar"};
        if (isForGeneratedCode) {
            return new LibraryDescriptor[]{new LibraryInfo(XML_BEANS_RT_LIBRARY_NAME, (String[])ArrayUtil.append((Object[])commonJars, (Object)((String)commonXmlBeansPrefix + "xmlpublic.jar")))};
        }
        return new LibraryDescriptor[]{new LibraryInfo(XML_BEANS_LIBRARY_NAME, (String[])commonJars)};
    }

    @Override
    public String getBasePath() {
        return WebServicesPluginSettings.getInstance().getXmlBeansPath();
    }

    public static void doXmlBeanGen(String url, String completeFileName, String[] classPath, Module module, boolean addToLibs, @Nullable Runnable onSuccess, @Nullable Runnable toRestart) {
        String outputPath;
        LinkedList<Object> parameters2 = new LinkedList<Object>();
        int beginIndex = ((String)completeFileName).lastIndexOf(File.separatorChar);
        if (beginIndex == -1) {
            beginIndex = ((String)completeFileName).lastIndexOf(47);
        }
        String outputFileName = ((String)completeFileName).substring(beginIndex + 1);
        if (beginIndex != -1) {
            outputPath = ((String)completeFileName).substring(0, beginIndex);
            outputPath = StringUtil.trimStart((String)outputPath, (String)"file:");
        } else {
            outputPath = url.substring(0, url.lastIndexOf(47));
        }
        Project project = module.getProject();
        completeFileName = outputPath + File.separator + outputFileName;
        VirtualFile outputFile = UriUtil.findRelativeFile((String)completeFileName, null);
        if (outputFile != null) {
            FileModificationService.getInstance().prepareFileForWrite(PsiManager.getInstance((Project)project).findFile(outputFile));
        }
        parameters2.add("-out");
        parameters2.add(completeFileName);
        parameters2.add("-quiet");
        parameters2.add(url);
        WebServicesPluginSettings.getInstance().addLastXmlBeansUrl(url);
        parameters2.add("-dl");
        WsJavaExternalProcessHandler externalProcessHandler = new WsJavaExternalProcessHandler("Schema Compiler", "org.apache.xmlbeans.impl.tool.SchemaCompiler", classPath, ArrayUtilRt.toStringArray(parameters2), module, true);
        Consumer actionAtFailure = e -> {
            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)WSBundle.message("generate.java.code.from.xmlbeans.compiler.error", new Object[0]));
            LOG.debug((Throwable)e);
        };
        if (toRestart != null) {
            String outputPath1 = outputPath;
            InvokeExternalCodeUtil.invokeExternalProcess2(externalProcessHandler, project, () -> {
                XmlBeansMappingEngine.addToLibs(module, addToLibs, outputPath1, outputFileName);
                if (onSuccess != null) {
                    onSuccess.run();
                }
            }, (Consumer<? super Exception>)actionAtFailure, (Computable<Boolean>)((Computable)() -> true), toRestart);
        } else {
            try {
                InvokeExternalCodeUtil.invokeExternalProcess(externalProcessHandler, project);
            }
            catch (Exception e2) {
                actionAtFailure.consume((Object)e2);
                return;
            }
            XmlBeansMappingEngine.addToLibs(module, addToLibs, outputPath, outputFileName);
        }
    }

    private static void addToLibs(Module module, boolean addToLibs, String outputPath, String outputFileName) {
        if (addToLibs) {
            LibraryDescriptor[] generatedLibInfos = new LibraryDescriptor[]{new LibraryInfo(null, outputFileName)};
            LibUtils.setupLibraries(module, generatedLibInfos, (String)(outputPath.length() > 0 ? outputPath + File.separatorChar : ""), true);
            CommonWsUtils.setupLibsForDeployment(module, generatedLibInfos);
        }
    }
}

