/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml.view;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.microservices.cache.SourceTestLibSearcher;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.ModuleEndpointsFilter;
import com.intellij.microservices.uast.url.UastUrlAttributeUtils;
import com.intellij.microservices.utils.EndpointsViewUtils;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.uast.UastModificationTracker;
import com.intellij.ws.xml.jam.WSJamWebMethod;
import com.intellij.ws.xml.jam.WSJamWebService;
import com.intellij.ws.xml.utils.WsModuleUtil;
import com.intellij.ws.xml.view.WSEndpointsProvider;
import icons.JavaUltimateIcons;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u00162\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/ws/xml/view/WSEndpointsProvider;", "Lcom/intellij/microservices/endpoints/EndpointsProvider;", "Lcom/intellij/ws/xml/jam/WSJamWebService;", "Lcom/intellij/ws/xml/jam/WSJamWebMethod;", "()V", "endpointType", "Lcom/intellij/microservices/endpoints/EndpointType;", "getEndpointType", "()Lcom/intellij/microservices/endpoints/EndpointType;", "presentation", "Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getPresentation", "()Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "servicesSearcher", "Lcom/intellij/microservices/cache/SourceTestLibSearcher;", "getEndpointData", "", "group", "endpoint", "dataId", "", "getEndpointGroups", "", "project", "Lcom/intellij/openapi/project/Project;", "filter", "Lcom/intellij/microservices/endpoints/EndpointsFilter;", "getEndpointPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getEndpoints", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getStatus", "Lcom/intellij/microservices/endpoints/EndpointsProvider$Status;", "isValidEndpoint", "", "intellij.javaee.jax.ws"})
public final class WSEndpointsProvider
implements EndpointsProvider<WSJamWebService, WSJamWebMethod> {
    private final SourceTestLibSearcher<WSJamWebService> servicesSearcher = new SourceTestLibSearcher("WS_SERVERS", (Function2)servicesSearcher.1.INSTANCE);
    @NotNull
    private final FrameworkPresentation presentation = new FrameworkPresentation("JEE-XML-Web-Services", "JEE XML Web Services", AllIcons.Nodes.PpWeb);

    @NotNull
    public EndpointType getEndpointType() {
        return EndpointTypes.XML_WEB_SERVICE_TYPE;
    }

    @NotNull
    public FrameworkPresentation getPresentation() {
        return this.presentation;
    }

    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return WsModuleUtil.isJaxWSLibAttached(project) ? EndpointsProvider.Status.AVAILABLE : EndpointsProvider.Status.UNAVAILABLE;
    }

    @NotNull
    public Iterable<WSJamWebService> getEndpointGroups(@NotNull Project project, @NotNull EndpointsFilter filter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        if (!(filter instanceof ModuleEndpointsFilter)) {
            return CollectionsKt.emptyList();
        }
        if (!WsModuleUtil.isJaxWSLibAttached(((ModuleEndpointsFilter)filter).getModule())) {
            return CollectionsKt.emptyList();
        }
        return this.servicesSearcher.iterable(((ModuleEndpointsFilter)filter).getModule(), ((ModuleEndpointsFilter)filter).getFromTests(), ((ModuleEndpointsFilter)filter).getFromLibraries());
    }

    @NotNull
    public Iterable<WSJamWebMethod> getEndpoints(@NotNull WSJamWebService group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        List<WSJamWebMethod> list = group.getWebMethods();
        Intrinsics.checkNotNullExpressionValue(list, (String)"group.webMethods");
        return list;
    }

    @NotNull
    public ItemPresentation getEndpointPresentation(@NotNull WSJamWebService group, @NotNull WSJamWebMethod endpoint) {
        String string;
        String className;
        String string2;
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        PsiClass psiClass = group.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"group.psiElement");
        String string3 = psiClass.getQualifiedName();
        if (string3 != null) {
            String string4 = string3;
            boolean bl = false;
            boolean bl2 = false;
            String it = string4;
            boolean bl3 = false;
            string2 = StringUtil.getShortName((String)it);
        } else {
            string2 = className = null;
        }
        if ((string = group.getServiceName()) == null) {
            string = className;
        }
        String serviceName = string;
        PsiMethod psiMethod = endpoint.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"endpoint.psiElement");
        PsiParameterList psiParameterList = psiMethod.getParameterList();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"endpoint.psiElement.parameterList");
        Object[] objectArray = psiParameterList.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"endpoint.psiElement.parameterList.parameters");
        String parameters2 = ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)getEndpointPresentation.parameters.1.INSTANCE, (int)24, null);
        StringBuilder stringBuilder = new StringBuilder().append(serviceName).append('.');
        PsiMethod psiMethod2 = endpoint.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethod2, (String)"endpoint.psiElement");
        return (ItemPresentation)new PresentationData(stringBuilder.append(psiMethod2.getName()).append(parameters2).toString(), className, JavaUltimateIcons.Web.XmlService, (TextAttributesKey)(UastUrlAttributeUtils.isUastDeclarationDeprecated((PsiElement)((PsiElement)endpoint.getPsiElement())) ? CodeInsightColors.DEPRECATED_ATTRIBUTES : null));
    }

    @Nullable
    public Object getEndpointData(@NotNull WSJamWebService group, @NotNull WSJamWebMethod endpoint, @NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return EndpointsViewUtils.getCommonEndpointValue((PsiElement)((PsiElement)endpoint.getPsiElement()), (String)dataId);
    }

    public boolean isValidEndpoint(@NotNull WSJamWebService group, @NotNull WSJamWebMethod endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return group.isPsiValid() && endpoint.isPsiValid();
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (ModificationTracker)UastModificationTracker.Companion.getInstance(project);
    }
}

