/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml.utils.ui;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.UIUtil;
import com.intellij.ws.xml.WSBundle;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class MyDialogWrapper
extends DialogWrapper {
    protected static final Logger LOG = Logger.getInstance(MyDialogWrapper.class);
    protected Project myProject;
    private PsiClass myClass;
    private PsiFile myFile;

    public MyDialogWrapper(Project project) {
        super(project, true);
        this.myProject = project;
        this.setValidationDelay(1000);
    }

    protected boolean postponeValidation() {
        return false;
    }

    protected String getDimensionServiceKey() {
        return "#" + ((Object)((Object)this)).getClass().getName();
    }

    public PsiClass getCurrentClass() {
        if (this.myClass != null && !this.myClass.isValid() && this.myFile != null) {
            this.myClass = (PsiClass)ArrayUtil.getFirstElement((Object[])((PsiJavaFile)this.myFile).getClasses());
        }
        return this.myClass;
    }

    protected boolean hasClassNameInUI() {
        return true;
    }

    public void setCurrentClass(PsiClass aClass) {
        this.myClass = aClass;
        this.myFile = this.myClass != null ? this.myClass.getContainingFile() : null;
    }

    public void setCurrentFile(PsiFile aFile) {
        this.myFile = aFile;
    }

    public PsiFile getCurrentFile() {
        return this.myFile;
    }

    protected void init() {
        super.init();
        this.setClassNameToUI(this.myClass);
    }

    public void setClassNameToUI(PsiClass aClass) {
        if (!this.hasClassNameInUI()) {
            return;
        }
        JComponent className = this.getClassName();
        if (className != null) {
            String text = aClass != null ? this.getClassNameTextToSet(aClass) : "*UNDEFINED*";
            this.doSetClassNameText(className, text);
        }
    }

    protected void doSetClassNameText(JComponent className, @Nls String text) {
        if (className instanceof JLabel) {
            ((JLabel)className).setText(text);
        } else if (className instanceof JTextField) {
            ((JTextField)className).setText(text);
        } else {
            throw new UnsupportedOperationException();
        }
        this.validate();
    }

    @NlsSafe
    protected String getClassNameTextToSet(PsiClass aClass) {
        return aClass.getName();
    }

    protected JComponent getClassName() {
        return null;
    }

    protected void doHelpAction() {
        String helpId = this.getHelpId();
        HelpManager.getInstance().invokeHelp("webservices." + helpId.substring(0, helpId.lastIndexOf(46)));
    }

    public void doInitFor(JLabel textComponent, JComponent component, char mnemonic) {
        textComponent.setLabelFor(component);
        textComponent.setDisplayedMnemonic(mnemonic);
    }

    @NotNull
    protected Alarm.ThreadToUse getValidationThreadToUse() {
        Alarm.ThreadToUse threadToUse = Alarm.ThreadToUse.POOLED_THREAD;
        if (threadToUse == null) {
            MyDialogWrapper.$$$reportNull$$$0(0);
        }
        return threadToUse;
    }

    protected abstract ValidationInfo doValidate(ValidationData var1);

    protected abstract ValidationData createValidationData();

    protected ValidationInfo doValidate() {
        ValidationData validationData = this.createValidationData();
        if (validationData != null) {
            validationData.acquire();
        }
        if (EDT.isCurrentThreadEdt()) {
            return (ValidationInfo)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> (ValidationInfo)ReadAction.compute(() -> this.doValidate(validationData)), WSBundle.message("progress.validating", new Object[0]), false, this.myProject);
        }
        Ref info = new Ref();
        boolean finished = ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> info.set((Object)this.doValidate(validationData)));
        if (finished) {
            return (ValidationInfo)info.get();
        }
        return null;
    }

    @NotNull
    @NonNls
    protected abstract String getHelpId();

    protected boolean isAcceptableFile(VirtualFile virtualFile) {
        return FileTypeRegistry.getInstance().isFileOfType(virtualFile, (FileType)JavaFileType.INSTANCE);
    }

    public void configureComboBox(JComboBox combo, List<String> lastValues) {
        combo.setModel(new DefaultComboBoxModel<String>(ArrayUtilRt.toStringArray(lastValues)));
        if (combo.getItemCount() != 0) {
            combo.setSelectedIndex(0);
            combo.getEditor().selectAll();
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    @Nls
    protected static String getNoClassInSelectedTextEditor() {
        return WSBundle.message("no.class.in.selected.text.editor.error.message", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/xml/utils/ui/MyDialogWrapper", "getValidationThreadToUse"));
    }

    public static abstract class ValidationData {
        public final void acquire() {
            try {
                UIUtil.invokeAndWaitIfNeeded(() -> this.doAcquire());
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }

        protected abstract void doAcquire();
    }
}

