/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml.utils.ui;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public abstract class MethodTableCellRenderer
extends DefaultTableCellRenderer {
    private Font myFont;
    private Font myBoldFont;

    protected abstract String getProblemByMethod(PsiMethod var1);

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        PsiMethod method = (PsiMethod)value;
        String s = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)3, (int)2);
        Component tableCellRendererComponent = super.getTableCellRendererComponent(table, s, isSelected, hasFocus, row, column);
        String problem = this.getProblemByMethod(method);
        String toolTip = null;
        if (problem == null) {
            tableCellRendererComponent.setEnabled(true);
            if (this.myFont == null) {
                this.myFont = tableCellRendererComponent.getFont();
            }
            if (this.myBoldFont == null) {
                this.myBoldFont = this.myFont.deriveFont(1);
            }
        } else {
            toolTip = problem;
            tableCellRendererComponent.setEnabled(false);
        }
        ((JComponent)tableCellRendererComponent).setToolTipText(toolTip);
        return tableCellRendererComponent;
    }
}

