/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml.utils;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.ws.common.FileUtils;
import com.intellij.ws.common.InvokeExternalCodeUtil;
import com.intellij.ws.xml.WSBundle;
import com.intellij.ws.xml.WsJavaExternalProcessHandler;
import com.intellij.ws.xml.engines.ExternalEngine;
import com.intellij.ws.xml.engines.ExternalEngineThatBundlesJEEJars;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WSInvokeExternalCodeUtil {
    public static void addEndorsedJarDirectory(@NotNull WsJavaExternalProcessHandler processHandler, @NotNull ExternalEngine engine, @Nullable Module targetModule) {
        if (processHandler == null) {
            WSInvokeExternalCodeUtil.$$$reportNull$$$0(0);
        }
        if (engine == null) {
            WSInvokeExternalCodeUtil.$$$reportNull$$$0(1);
        }
        if (!(engine instanceof ExternalEngineThatBundlesJEEJars)) {
            return;
        }
        Object basePath = engine.getBasePath();
        if (targetModule != null) {
            boolean isJdkNotHigher16;
            Sdk projectJdk = InvokeExternalCodeUtil.JavaExternalProcessHandler.evaluateJdkForModule(targetModule);
            boolean bl = isJdkNotHigher16 = projectJdk != null && !JavaSdk.getInstance().isOfVersionOrHigher(projectJdk, JavaSdkVersion.JDK_1_7);
            if (isJdkNotHigher16) {
                String endorsedDirectory = basePath != null ? InvokeExternalCodeUtil.ourBasePath2TempEndorsedDirectory.get(basePath) : null;
                File file = null;
                if (endorsedDirectory != null) {
                    file = new File(endorsedDirectory);
                }
                if (file == null || !file.exists() && !file.mkdirs()) {
                    try {
                        endorsedDirectory = FileUtils.createTempDir("endorsed.temp").getPath();
                        InvokeExternalCodeUtil.ourBasePath2TempEndorsedDirectory.put((String)basePath, endorsedDirectory);
                        file = new File(endorsedDirectory);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                for (String jeeJarName : ((ExternalEngineThatBundlesJEEJars)((Object)engine)).getJEEJarUrls(targetModule)) {
                    File sourceJar = new File(jeeJarName);
                    int i = jeeJarName.lastIndexOf(File.separatorChar);
                    if (i == -1) {
                        i = jeeJarName.lastIndexOf(47);
                    }
                    File destJar = new File(file, jeeJarName.substring(i + 1));
                    assert (sourceJar.exists()) : jeeJarName;
                    if (destJar.exists() && sourceJar.length() == destJar.length()) continue;
                    try {
                        FileInputStream inputStream = new FileInputStream(sourceJar);
                        FileUtils.saveStreamContentAsFile(destJar.getPath(), inputStream);
                        inputStream.close();
                        destJar.deleteOnExit();
                    }
                    catch (IOException e) {
                        Messages.showErrorDialog((String)WSBundle.message("exception.when.copying.endorsed.jars.message", sourceJar.getPath(), destJar.getPath()), (String)WSBundle.message("exception.when.copying.endorsed.jars.title", new Object[0]));
                        break;
                    }
                }
            }
            if (isJdkNotHigher16) {
                String tempPath = InvokeExternalCodeUtil.ourBasePath2TempEndorsedDirectory.get(basePath);
                if (new File((String)basePath, "lib").exists()) {
                    basePath = (String)basePath + File.separatorChar + "lib";
                }
                processHandler.addCommandLineProperty("java.endorsed.dirs", (String)(tempPath != null ? tempPath : basePath));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "processHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "engine";
                break;
            }
        }
        objectArray[1] = "com/intellij/ws/xml/utils/WSInvokeExternalCodeUtil";
        objectArray[2] = "addEndorsedJarDirectory";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

