/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml.utils;

import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.util.ArrayUtilRt;
import com.intellij.ws.common.CommonWsUtils;
import com.intellij.ws.common.FileUtils;
import com.intellij.ws.common.InvokeExternalCodeUtil;
import com.intellij.ws.common.engines.LibraryDescriptor;
import com.intellij.ws.xml.engines.ExternalEngine;
import com.intellij.ws.xml.facet.WebServicesClientLibraries;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LibUtils {
    private LibUtils() {
    }

    public static String[] getLibUrlsForToolRunning(ExternalEngine engine, Module module) {
        if (WebServicesClientLibraries.isSupported(engine.getName())) {
            LibraryInfo[] info = WebServicesClientLibraries.getRequiredLibraries(engine.getName());
            HashSet<String> libs = new HashSet<String>();
            for (LibraryInfo lib : info) {
                String[] classes = lib.getRequiredClasses();
                if (classes.length == 0) continue;
                String[] libraries = LibUtils.getLibUrlsForToolRunning(classes[0], module.getProject());
                Collections.addAll(libs, libraries);
            }
            if (CompilerModuleExtension.getInstance((Module)module).getCompilerOutputPath() != null) {
                libs.add(CompilerModuleExtension.getInstance((Module)module).getCompilerOutputPath().getPath());
            }
            return ArrayUtilRt.toStringArray(libs);
        }
        return LibUtils.getLibsUrlsFromLibInfos(engine.getLibraryDescriptors(null, false), engine.getBasePath());
    }

    public static String[] getLibUrlsForToolRunning(String fqn, Project project) {
        Library lib = LibraryUtil.findLibraryByClass((String)fqn, (Project)project);
        if (lib == null) {
            VirtualFile[] roots = LibraryUtil.getLibraryRoots((Project)project);
            VirtualFile[] files = new VirtualFile[1];
            VirtualFile[] virtualFileArray = roots;
            int n = virtualFileArray.length;
            for (int i = 0; i < n; ++i) {
                VirtualFile root;
                files[0] = root = virtualFileArray[i];
                if (!LibraryUtil.isClassAvailableInLibrary((VirtualFile[])files, (String)fqn)) continue;
                return new String[]{files[0].getPresentableUrl()};
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        VirtualFile[] files = lib.getFiles(OrderRootType.CLASSES);
        String[] jars = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            jars[i] = files[i].getPresentableUrl();
        }
        return jars;
    }

    public static void setupLibsForGeneratedCode(Module module, ExternalEngine engine, String bindingType) {
        String libPath = LibUtils.detectLibPath(engine);
        if (libPath != null) {
            LibUtils.setupLibraries(module, LibUtils.getGeneratedCodeLibInfos(engine, bindingType, module), libPath, false);
        }
    }

    public static LibraryDescriptor[] getGeneratedCodeLibInfos(ExternalEngine engine, String bindingType, Module module) {
        return engine.getLibraryDescriptors(bindingType, true);
    }

    static void addRequiredLibraryIfNeeded(LibraryTable libraryTable, LibraryDescriptor info, String libPath, ModifiableRootModel rootModel) {
        String name = info.getName();
        Library library = null;
        if (name != null) {
            library = libraryTable.getLibraryByName(name);
        } else {
            Iterator libraryIterator = libraryTable.getLibraryIterator();
            String firstJarName = info.getLibJars()[0];
            block0: while (libraryIterator.hasNext()) {
                Library lib = (Library)libraryIterator.next();
                if (lib.getName() != null) continue;
                for (VirtualFile f : lib.getFiles(OrderRootType.CLASSES)) {
                    if (!firstJarName.equals(f.getPresentableName())) continue;
                    library = lib;
                    break block0;
                }
            }
        }
        if (library == null) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                Library library2 = name != null ? libraryTable.createLibrary(name) : libraryTable.createLibrary();
                Library.ModifiableModel model = library2.getModifiableModel();
                for (String jar : info.getLibJars()) {
                    LibUtils.addOneJar(jar, model, libPath);
                }
                model.commit();
                if ("project".equals(libraryTable.getTableLevel())) {
                    LibraryOrderEntry orderEntry = rootModel.addLibraryEntry(library2);
                    LibUtils.rearrageEntries(rootModel, orderEntry);
                }
            });
        } else if (LibUtils.noReferenceToLibrary(rootModel, library)) {
            Library library1 = library;
            ApplicationManager.getApplication().runWriteAction(() -> {
                LibraryOrderEntry orderEntry = rootModel.addLibraryEntry(library1);
                LibUtils.rearrageEntries(rootModel, orderEntry);
            });
        }
    }

    private static void rearrageEntries(ModifiableRootModel rootModel, LibraryOrderEntry orderEntry) {
        OrderEntry[] orderEntries = rootModel.getOrderEntries();
        OrderEntry[] newOrderEntries = new OrderEntry[orderEntries.length];
        newOrderEntries[0] = orderEntry;
        int index = 1;
        for (OrderEntry oe : orderEntries) {
            if (oe == orderEntry) continue;
            newOrderEntries[index++] = oe;
        }
        rootModel.rearrangeOrderEntries(newOrderEntries);
    }

    private static boolean noReferenceToLibrary(ModifiableRootModel rootModel, Library library) {
        LibraryOrderEntry libraryOrderEntry = rootModel.findLibraryOrderEntry(library);
        if (libraryOrderEntry != null) {
            return false;
        }
        for (OrderEntry o : rootModel.getOrderEntries()) {
            LibraryOrderEntry orderEntry;
            String name;
            if (!(o instanceof LibraryOrderEntry) || (name = (orderEntry = (LibraryOrderEntry)o).getLibraryName()) == null || !name.equals(library.getName())) continue;
            return false;
        }
        return true;
    }

    private static void addOneJar(String jarFileName, Library.ModifiableModel model, String libPath) {
        File file = new File((libPath + jarFileName).replace('\\', '/'));
        VirtualFile fileByIoFile = LocalFileSystem.getInstance().findFileByIoFile(file);
        if (fileByIoFile == null) {
            fileByIoFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
        }
        if (fileByIoFile != null) {
            VirtualFile fileByPath = JarFileSystem.getInstance().findFileByPath(fileByIoFile.getPath() + "!/");
            model.addRoot(fileByPath, OrderRootType.CLASSES);
        }
    }

    static String detectLibPath(@NotNull ExternalEngine engine) {
        String s;
        if (engine == null) {
            LibUtils.$$$reportNull$$$0(0);
        }
        if ((s = engine.getBasePath()) == null) {
            return null;
        }
        if (!new File(s).exists()) {
            throw new RuntimeException("Required libs are missed");
        }
        return s + File.separatorChar;
    }

    public static String[] getLibsUrlsFromLibInfos(LibraryDescriptor[] libInfos, String basePath) {
        ArrayList<CallSite> result = new ArrayList<CallSite>();
        for (LibraryDescriptor libInfo : libInfos) {
            for (String s : libInfo.getLibJars()) {
                result.add((CallSite)((Object)(basePath + File.separator + s)));
            }
        }
        return ArrayUtilRt.toStringArray(result);
    }

    public static void setupLibraries(Module currentModule, LibraryDescriptor[] libInfos, String libPath, boolean moduleLibrary) {
        ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)currentModule).getModifiableModel();
        LibraryTable libraryTable = moduleLibrary ? modifiableModel.getModuleLibraryTable() : LibraryTablesRegistrar.getInstance().getLibraryTable(currentModule.getProject());
        for (LibraryDescriptor libInfo : libInfos) {
            LibUtils.addRequiredLibraryIfNeeded(libraryTable, libInfo, libPath, modifiableModel);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                modifiableModel.commit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static XmlTag findServletWithName(XmlTag[] tags, @NotNull String axisServletName, @Nullable String deploymentServletClass) {
        if (axisServletName == null) {
            LibUtils.$$$reportNull$$$0(1);
        }
        for (XmlTag tag : tags) {
            XmlTag name;
            String stringValue;
            XmlTag[] subTags = tag.findSubTags("servlet-name");
            if (subTags.length == 0 || !(stringValue = LibUtils.getStringValue(name = subTags[0])).equals(axisServletName)) continue;
            return tag;
        }
        return deploymentServletClass != null ? LibUtils.findServletByClass(tags, deploymentServletClass) : null;
    }

    public static XmlTag findServletByClass(XmlTag[] tags, @NotNull String servletClassName) {
        if (servletClassName == null) {
            LibUtils.$$$reportNull$$$0(2);
        }
        for (XmlTag tag : tags) {
            XmlTag name;
            String stringValue;
            XmlTag[] subTags = tag.findSubTags("servlet-class");
            if (subTags.length == 0 || !(stringValue = LibUtils.getStringValue(name = subTags[0])).equals(servletClassName)) continue;
            return tag;
        }
        return null;
    }

    public static String getStringValue(XmlTag name) {
        String stringValue = "";
        XmlTagValue value = name.getValue();
        if (value instanceof String) {
            stringValue = (String)value;
        } else if (value instanceof XmlTagValue) {
            stringValue = value.getTrimmedText();
        }
        return stringValue.trim();
    }

    @Nullable
    public static Module findModuleByOutputPath(Project project, String output) {
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        Module currentModule = null;
        block0: for (Module module : modules) {
            VirtualFile[] files;
            for (VirtualFile file : files = OrderEnumerator.orderEntries((Module)module).getAllSourceRoots()) {
                if (!file.getPresentableUrl().equals(output)) continue;
                currentModule = module;
                break block0;
            }
        }
        return currentModule;
    }

    public static File saveSourceGeneratedFile(String wsdlUrl, String outputPath, @Nullable String packagePrefix) throws IOException {
        int i;
        URL url = new URL(wsdlUrl);
        InputStream stream = url.openStream();
        int i2 = wsdlUrl.indexOf(63, i = wsdlUrl.lastIndexOf(47));
        Object fileName = wsdlUrl.substring(i, i2 != -1 ? i2 : wsdlUrl.length());
        if (i2 != -1 && !((String)fileName).endsWith(".wsdl") && ((String)fileName).indexOf(46) == -1) {
            fileName = (String)fileName + ".wsdl";
        }
        String s = outputPath + (String)(packagePrefix != null ? "/" + packagePrefix.replace('.', File.separatorChar) : "");
        File f = new File(s);
        f.mkdirs();
        String fullFileName = s + (String)fileName;
        File file = LibUtils.isSameFile(url, fullFileName) ? new File(fullFileName) : FileUtils.saveStreamContentAsFile(fullFileName, stream);
        CommonWsUtils.scanFile(file, new CommonWsUtils.FileProcessor(){
            final Pattern p = Pattern.compile("(?:(?:location|schemaLocation)\\s*=\\s*(\"|'))([^\"']*)\\1");

            @Override
            public void fileScanningEnded() throws IOException {
            }

            @Override
            public boolean process(String s) throws IOException {
                if (s.contains("location") || s.contains("schemaLocation")) {
                    Matcher matcher = this.p.matcher(s);
                    StringBuilder result = new StringBuilder();
                    while (matcher.find()) {
                    }
                    matcher.appendTail(result);
                }
                return true;
            }
        });
        return file;
    }

    private static boolean isSameFile(URL url, String fullFileName) {
        try {
            return new File(fullFileName).equals(new File(url.toURI()));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String findOutputDir(Module module) {
        VirtualFile[] files = OrderEnumerator.orderEntries((Module)module).getAllSourceRoots();
        String generateSourcesDir = null;
        for (VirtualFile file : files) {
            if (file.getExtension() != null || !file.isWritable()) continue;
            generateSourcesDir = file.getPresentableUrl();
            break;
        }
        return generateSourcesDir;
    }

    public static String retrieveTargetNamespace(File savedWsdlFile) throws InvokeExternalCodeUtil.ExternalCodeException {
        final String[] detectedNsFromWsdl = new String[1];
        try {
            CommonWsUtils.scanFile(savedWsdlFile, new CommonWsUtils.FileProcessor(){
                final Pattern p = Pattern.compile("(?:(?:namespace|targetNamespace)\\s*=\\s*(\"|'))([^\"']*)\\1");

                @Override
                public void fileScanningEnded() throws IOException {
                }

                @Override
                public boolean process(String s) throws IOException {
                    Matcher matcher;
                    if ((s.contains("namespace=\"") || s.contains("targetNamespace=\"")) && (matcher = this.p.matcher(s)).find() && detectedNsFromWsdl[0] == null) {
                        detectedNsFromWsdl[0] = matcher.group(2);
                    }
                    return true;
                }
            });
        }
        catch (IOException e) {
            throw new InvokeExternalCodeUtil.ExternalCodeException(e);
        }
        return detectedNsFromWsdl[0];
    }

    public static boolean accessingLibraryJarsFromPluginBundledLibs(String basePath) {
        return !new File(basePath + File.separatorChar + "lib").exists();
    }

    public static InputStream getResourcesStream(String templateName) {
        return LibUtils.class.getResourceAsStream("/schemas/resources/" + templateName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engine";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "axisServletName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "servletClassName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/xml/utils/LibUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "detectLibPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findServletWithName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findServletByClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

