/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.ws.common.WsPsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TagValueClassReference
implements PsiReference {
    private final XmlTag myElement;
    private TextRange myRange;

    TagValueClassReference(XmlTag element) {
        this.myElement = element;
        String text = element.getValue().getText();
        String trimmedText = text.trim();
        int start = element.getValue().getTextRange().getStartOffset() - element.getTextRange().getStartOffset() + text.indexOf(trimmedText);
        if (trimmedText.endsWith("[]")) {
            trimmedText = trimmedText.substring(0, trimmedText.length() - 2);
            trimmedText = trimmedText.trim();
        }
        this.myRange = new TextRange(start, start + trimmedText.length());
    }

    @NotNull
    public PsiElement getElement() {
        XmlTag xmlTag = this.myElement;
        if (xmlTag == null) {
            TagValueClassReference.$$$reportNull$$$0(0);
        }
        return xmlTag;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myRange;
        if (textRange == null) {
            TagValueClassReference.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    @NotNull
    public String getCanonicalText() {
        String trimmedText = this.myElement.getValue().getTrimmedText();
        String string = trimmedText.substring(0, Math.min(this.myRange.getLength(), trimmedText.length()));
        if (string == null) {
            TagValueClassReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String string) throws IncorrectOperationException {
        if (string == null) {
            TagValueClassReference.$$$reportNull$$$0(3);
        }
        PsiElement psiElement = ElementManipulators.handleContentChange((PsiElement)this.myElement, (TextRange)this.myRange, (String)string);
        this.myRange = new TextRange(this.myRange.getStartOffset(), this.myRange.getStartOffset() + string.length());
        return psiElement;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            TagValueClassReference.$$$reportNull$$$0(4);
        }
        return this.handleElementRename(((PsiClass)element).getQualifiedName());
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            TagValueClassReference.$$$reportNull$$$0(5);
        }
        return this.myElement.getManager().areElementsEquivalent(this.resolve(), element);
    }

    @Nullable
    public PsiElement resolve() {
        return WsPsiUtil.findClass(this.getCanonicalText(), this.myElement.getProject(), null);
    }

    public boolean isSoft() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/xml/references/TagValueClassReference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/xml/references/TagValueClassReference";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

